/* -*-c,save-*- */

/*

 * PATDEF.H - Pattern definations

 * Robert Heller. Created: Sat Oct 19, 1985 13:20:03.09

 * Last Mod: 

 * 

 * (c) Copyright 1985 by Robert Heller

 *     All Rights Reserved

 * 

 * 

 */

/*

 * This file contains the definations for the Pattern Matching System.

 * This includes typedefs, #defines and externs.

 */



/* a basic string descriptor: */

typedef struct {

    char *base;			/* base pointer to the string */

    short int offset;		/* offset to first character */

    short int length;		/* string length */

    } STRING_DESCR;



/* argument descriptor */

typedef struct arg_descr {

    short int data_type;	/* data type of argument */

#define FLONUM 1		/* arg is a float */

#define FIXNUM 2		/* arg is an int */

#define STRING 3		/* arg is a pointer to a string descr */

#define FUNCTION 4		/* arg is a pointer to a function */

#define PATTERN 5		/* arg is a pointer to a pattern */

#define UNDEFINED 0		/* undefined data type */

    union {

	float flonum;		/* float lives here */

	long int fixnum;	/* int lives here */

	STRING_DESCR *string;	/* string descr. ptr lives here */

	long int (*function)(); /* function ptr. lives here */

	struct pattern_node *pattern; /* and pattern lives here */

	} value;

    } ARG_DESCR;



/* pattern node object */

typedef struct pattern_node {

    short int (*prog)();	/* match routine */

    struct pattern_node *subs;	/* pointer to sub. nodes */

    struct pattern_node *alts;	/* pointer to alt. nodes */

    ARG_DESCR *arg;		/* argument */

    short int resid;		/* residual */

    short int __mark;		/* mark field (used by copy functions) */

    struct pattern_node *__new;	/* pointer to new pattern (used by copy functions) */

    } PATTERN_NODE;



#ifndef PMODULE

#ifdef SUCCESS

#undef SUCCESS

#endif

extern PATTERN_NODE *breakk(),*breakk_c(),*len(),*any(),*any_c(),*notany();

extern PATTERN_NODE *notany_c(),*span(),*span_c(),*arbno(),*alt(),*concat();

extern PATTERN_NODE *lit_string(),*c_lit_string(),*star(),*cassign();

extern PATTERN_NODE *assign(),*pos(),*rpos(),*tab(),*rtab(),*NIL,*FENCE;

extern PATTERN_NODE *FAIL,*SUCCESS,*ABORT,*REM,*ARB,*BAL;



#endif



#define MATCH_SUCCESS 1	/* success == TRUE */

#define MATCH_FAIL    0 /* failure == FALSE */

               