/*
	Replaces ASCII tab characters with multiple spaces
	based on common modulo 8 tab "stops".


24/Jun/84 Adapted BDS C version for DR C compiler, added
	  improved file opening module and usage
	  message, broke UNTAB code off into its own function,
	  tidied up a few minor bugs.
	  Bill Bolton, Software Tools RCPM, Australia	

*/

#include <STDIO.H>

#define VERS 1		/* main version number */
#define REVISION 0	/* sub version number */
#define CPMEOF 0x1a	/* CP/M-86 end of file marker */
#define ERROR 0		/* Normal file error condition */
#define FERROR -1	/* Flush file error */
#define CR 0x0		/* ASCII Carriage Return */
#define LF 0x0a		/* ASCII Line Feed */
#define BS 0x08		/* ASCII Backspace */
#define TAB 0x09	/* ASCII Tab */

/*
	Argument vector indices
*/

#define FROM_FILE 1
#define TO_FILE   2


main(argc,argv)
int argc;
char *argv[];

{
	FILE *fdin,*fdout;

	printf("\nReplaces TABs with multiple spaces, CP/M-86 Version %d.%d\n",VERS,REVISION);
	printf("Software Tools\n");
	if( argc != 3 )
			usage();
	else {
		if( (fdin = fopen(argv[FROM_FILE],"r")) == ERROR){
			printf("\nCannot find file %s\n",argv[FROM_FILE]);
			usage();
		}
		else {
			if( (fdout  = fopen(argv[TO_FILE],"w")) == ERROR )
				printf("\nCan't open %s\n",argv[TO_FILE]);
			else {
				printf("\nWorking\n");
				untab(fdin,fdout);
			}
		}
	}
	exit();
}


untab(fdin,fdout)
FILE *fdin;	/* the input file buffer */
FILE *fdout;	/* the output file buffer */

{
	int	column;
	int	c;

	column = 0;

	while ((c=getc(fdin)) != FERROR) {

		switch(c) {
		 	case CR:
				 column = 0;
			case LF:
				 putc1(c,fdout);
				 column = 0;	
				 continue;

			case TAB:
				 do {  
					putc1(' ',fdout);
					column++;
				 } while (column % 8);
				 continue;

			default:
				 column++;
		}
		putc1(c,fdout);
	}

	fclose(fdin);
	if (fclose(fdout) == FERROR)
		exit(puts("\nOutput file close error\n"));
}

putc1(c,buf)
char c;

{
/*	putchar(c);
*/	if (putc(c,buf) < 0) {
		printf("\n\nUNTAB : disk write error.");
		exit();
	}
}


usage()

{
		printf("\nUsage:\n\n");
		printf("\tUNTAB d:file1 d:file2\n\n");
		printf("Where:\n");
		printf("\tfile1 = source file, (* and ? not allowed)\n");
		printf("\tfile2 = destination file, (* and ? not allowed)\n");
		printf("\td:    = optional drive identifier\n\n");
		printf("i.e.\tUNTAB A:FOOBAR.TXT B:FUBAR.DOC\n");
}

/* End of UNTAB */
