;
	title	'Quick Set - File Attribute Bit Set Program'
;
;	7Jan84	by Mike Griswold, Ft. Worth, TX
;
;	This program allows for setting the three system
;	attribute bits, t1', t2', t3', to the control R/O,
;	SYS and Archive features.  Usage is:
;		QS file.typ {options}
;
;	where options are:
;		R for R/O
;		S for SYS
;		A for Archive
;
;	All other option letters are ignored.  Only the
;	first three letters in the option field are
;	used, all others are ignored.  To turn off an
;	attribute use QS without the option letter.
;
;
;
;	aseg			; for RMAC
;
	org	0100h
start:	lxi	sp,0100h
	lda	05dh		; see if file specified
	cpi	' '
	jz	no$file		; give usage message

	jmp	0		; exit
;
;	Output string from HL until '$'.
;
sout:	xchg			; DE points to string
	mvi	c,09
	call	5
	ret
;
;	Print usage string if no file was given.
;
no$file:
	lxi	h,usage
	call	sout
	jmp	0		; abort
;
;	Message strings
;
mess0:	db	' not found.',0dh,0ah,'$'
mess1:	db	' set to: $'
dirmess:db	'DIR $'
sysmess:db	'SYS $'
rwmess:	db	'RW $'
romess:	db	'RO $'
armess:	db	'Archive$'
;
usage:	db	0dh,0ah,'QS usage is:  QS  filename options'
	db	0dh,0ah,0ah,'where legal options are:'
	db	0dh,0ah,0ah,09h,'R - Sets RO attribute'
	db	0dh,0ah,09h,'S - Sets SYS attribute'
	db	0dh,0ah,09h,'A - Sets Archive attribute$'
;
;	Local storage
;
ro:	ds	1		; RO flag
sys:	ds	1		; SYS flag
arch:	ds	1		; Archive flag
;
	end	0100h
ive attribute$'
;
;	Local storage
;
ro:	ds	1		; RO flag
sys:	ds	1		; SYS flag
a