/*	WMEXEC.C		09/07/83	LEE JAY LORENZEN	*/

/*** INCLUDE FILES ******************************************************/

#include <portab.h>


/*** DEFINES ***********************************************************/

#define IO_IM_HERE 0x13


/*** STRUCTURES DECLARATIONS ******************************************/


/*** EXTERNAL FUNCTION DECLARATIONS ***********************************/

EXTERN VOID PD_KEEP();				/* in PDKEEP.A86	*/

EXTERN VOID WM_PK();				/* in WWCALL.A86	*/
EXTERN VOID WM_CALL();
EXTERN VOID IO_CALL();


/*** GLOBAL VARIABLES *************************************************/


/*** SUB FUNCTIONS ****************************************************/


/*** Window Manager INSTALL routine **************************************/

	WORD
wm_install()
{
	WORD		imhere,
			nvc,
			top;
	WORD		ax,bx,cx,dx;

						/* get window manager	*/
						/*   information	*/
	WM_CALL(&imhere,&nvc,&top);
						/* see if other manager	*/
						/*   is resident	*/
	if ( imhere != 0 )
	  return(FALSE);
						/* install self as 	*/
						/*   resident manager	*/
						/*   but not active	*/
	ax = IO_IM_HERE;
	cx = 0x0001;
	dx = nvc;
	IO_CALL(&ax,&bx,&cx,&dx);
						/* set keep flag	*/
	PD_KEEP(1);
						/* return successfully	*/
	return(TRUE);
}


/*** Window Manager EXIT routine *****************************************/

	VOID
wm_exit()
{
	WORD		imhere,
			nvc,
			top;
	WORD		ax,bx,cx,dx;

						/* figure out who's on	*/
						/*   so we can return	*/
						/*   key control to	*/
						/*   them		*/
	WM_CALL(&imhere,&nvc,&top);
						/* give up keyboard but	*/
						/*   stay resident	*/
	ax = IO_IM_HERE;
	cx = 0x0001;
	dx = top;
	IO_CALL(&ax,&bx,&cx,&dx);
						/* get out		*/
	return;
}


/*** Window Manager ABORT routine *****************************************/

	VOID
wm_abort()
{
	WORD		imhere,
			nvc,
			top;
	WORD		ax,bx,cx,dx;

						/* figure out who's on	*/
						/*   so we can return	*/
						/*   key control to	*/
						/*   them		*/
	WM_CALL(&imhere,&nvc,&top);
						/* give up keyboard and	*/
						/*   remove self as	*/
						/*   manager		*/
	ax = IO_IM_HERE;
	cx = 0x0000;
	dx = top;
	IO_CALL(&ax,&bx,&cx,&dx);
						/* clear keep flag	*/
	PD_KEEP(0);
						/* get out		*/
	return;
}

