/*	WMWINDOW.C		12/08/83	LEE JAY LORENZEN	*/

/*** INCLUDE FILES ******************************************************/

#include <portab.h>


/*** DEFINES ***********************************************************/

#define VS_TOP_LEFT 2
#define VS_BOT_RIGHT 4
#define VS_WIN_SIZE 12
#define VS_CUR_TRACK 30

#define IO_NEW_WINDOW 0x14
#define IO_CURSOR_VIEW 0x15


/*** STRUCTURES DECLARATIONS ******************************************/


/*** EXTERNAL FUNCTION DECLARATIONS ***********************************/

EXTERN VOID WM_PK();				/* in WWCALL.A86	*/
EXTERN VOID WM_CALL();
EXTERN VOID IO_CALL();

EXTERN WORD between();				/* in WMUTIL.C		*/
EXTERN VOID wm_nrnc();
EXTERN VOID wm_vrvc();


/*** GLOBAL VARIABLES *************************************************/


/*** SUB FUNCTIONS  ****************************************************/

/*** Window Manager WINDOW routine *****************************************/

	WORD
wm_window(cmd, x_amnt, y_amnt)
	WORD		cmd;
	WORD		x_amnt,
			y_amnt;
{
	WORD		imhere,
			nvc,
			top;
	WORD		ax,bx,cx,dx;
	WORD		tl,tlx,tly,
			br,brx,bry,
			vp,vpx,vpy,
			old_nrows,nrows,
			old_ncols,ncols;
	WORD		winsize;
	WORD		change;

						/* set change flag to	*/
						/*   FALSE		*/
	change = FALSE;
						/* find out who's on	*/
						/*   top		*/
	WM_CALL(&imhere, &nvc, &top);
						/* get top left and	*/
						/*   bottom right x,y's	*/
	WM_PK(0, top, VS_TOP_LEFT, &tl);
	WM_PK(0, top, VS_BOT_RIGHT, &br);
						/* convert to tlx,tly,	*/
						/*   brx,bry		*/
	tlx = tl & 0x00ff;
	tly = (tl & 0xff00) >> 8;
	brx = br & 0x00ff;
	bry = (br & 0xff00) >> 8;
						/* get window size	*/
	wm_nrnc(top, &nrows, &ncols);
						/* do changes based on	*/
						/*   current cmd	*/
	if ( cmd == 1 )
	{
						/* calculate current	*/
						/*   view point		*/
	  wm_vrvc(top, &vpy, &vpx);
	  vpx--;
	  vpy--;
						/* scrolling changes 	*/
						/*   x view point	*/
	  vpx += x_amnt;
	  vpx = between(0, vpx, 79);
						/* if this is legal	*/
						/*   view point then	*/
						/*   change view point	*/
	  if ( ((80 - vpx) >= ncols )   )
	  {
	    ax = IO_CURSOR_VIEW;
	    cx = ( (vpy & 0x00ff) << 8 ) + vpx;
	    WM_PK(0, top, VS_CUR_TRACK, &dx);
	    dx = ( (dx & 0x00ff) << 8 ) + top;		
	    IO_CALL(&ax, &bx, &cx, &dx);
	    change = TRUE; 
	  }
						/* scrolling changes 	*/
						/*   y view point	*/
	  vpy += y_amnt;
	  vpy = between(0, vpy, 23);
						/* if this is legal	*/
						/*   view point then	*/
						/*   change view point	*/
	  if ( ( (24 - vpy) >= nrows ) )
	  {
	    ax = IO_CURSOR_VIEW;
	    cx = ( (vpy & 0x00ff) << 8 ) + vpx;
	    WM_PK(0, top, VS_CUR_TRACK, &dx);
	    dx = ( (dx & 0x00ff) << 8 ) + top;		
	    IO_CALL(&ax, &bx, &cx, &dx);
	    change = TRUE; 
	  }
						/* get out of here	*/
	  return(change);
	}
	if ( cmd == 0 )
	{
						/* placing changes top	*/
						/*   left corner	*/
	  tlx += x_amnt;
	  tly += y_amnt;
	  tlx = between(0, tlx, 79);
	  tly = between(0, tly, 23);
	}
	if ( cmd == 2 )
	{
						/* sizing changes # of	*/
						/*   rows and columns	*/
	  old_ncols = ncols;
	  old_nrows = nrows;
	  ncols += x_amnt;
	  nrows += y_amnt;
	  ncols = between(1, ncols, 80);
	  nrows = between(1, nrows, 24);
	  if ( ( old_ncols != ncols ) ||
	       ( old_nrows != nrows )   )
	    change = TRUE;
	}
						/* update window size	*/
						/*   in case it changed	*/
						/*   we have to do this	*/
						/*   since xios doesn't	*/
						/*   update window size	*/
						/*   after full key	*/
	winsize = (nrows << 8) + ncols;
	WM_PK(1, top, VS_WIN_SIZE, &winsize);
						/* calculate new value	*/
						/*   of br and tl	*/
	brx = tlx + ncols - 1;
	bry = tly + nrows - 1;
	brx = between(0, brx, 79);
	bry = between(0, bry, 23);
	bx = (bry << 8) + brx;
	cx = (tly << 8) + tlx;
						/* if changed then	*/
						/*   update and return	*/
						/*   TRUE else return	*/
						/*   FALSE		*/
	if ( ( bx != br ) ||
	     ( cx != tl )   )
	{
	  ax = IO_NEW_WINDOW;
	  dx = top;
	  IO_CALL(&ax, &bx, &cx, &dx);
	  change = TRUE;
	}

	return(change);
}

