
***************************************************************
*
*       This routine sets the real time clock on a CompPro System
* Support 1 board. Time is entered in 24 hour format.
*                        by Bob Harbour
*                         3/12/88
*
****************************************************************

    .text
    .globl _setclk

clcom    equ   $0FF005A          * clock chip command address
cldata   equ   $0FF005B          * "          " data address

hold     equ   $40               * clock command bit masks
write    Equ   $20
inline   equ   $0A
outline  equ   $09
digoff   equ   $30               * ascii to bcd offset

mx       equ   16                * max number of digits input
numdig   equ   10
mask     equ   $0F


_setclk  move.l  #prompt,D1      * set up to output the prompt
         move.w  #outline,D0
         trap    #2              * call opsys

         move.l  #inbuf,A2       * set up to get input string
         move.l  #inbuf,D1  
         move.w  #inline,D0
         move.b  #mx,(A2)        * put max string length into buffer
         trap    #2              * call opsys

         move.l  #numdig,D4      * init loop counter
         move.l  #limit,A0       * init pointer to digit limits
         move.l  #digaddr,A1     * init pointer to digit addresses
         addi    #$02,A2         * move ptr off of string statistics
         move.b  #hold,clcom     * set hold bit in clock

top      move.b  (A2)+,D2        * get a character
         cmpi.b  #$30,D2         * check character for digit
         blt     notval          * less than zero, not a valid digit
         cmpi.b  #$39,D2
         bgt     notval          * greater than 9, not valid digit
         subi    #digoff,D2      * make it BCD
         andi    #mask,D2        * skim off junk bits

         btst   #0,D4            * check for limits, even or odd pass
         bne     odd             * its odd
         clr     D3
         move.b  D2,D3           * get tens digit
         mulu    #10,D3          * make it decade
         cmp.b   (A0),D3         * check it against max
         bgt     toohi           * if greater, go to error routine
         bra    ok               * not greater, go around odd stuff

odd      add.b   D2,D3           * put ones digit into total
         cmp.b   (A0)+,D3        * check it against limit
         bgt     toohi           * out of range, go to error routine

ok       cmpi.b  #numdig-2,D4    * is this days ten digit?
         bne     notDten         * no, skip special proccessing
         andi    #$03,D2         * clear out any bits above b2
         bra     notHten         * skip next check

notDten  cmpi.b  #numdig-6,D4    * is this hours 10 digit ?
         bne     notHten         * no, skip this
         or      #$08,D2         * set 24 hour mode bit

notHten  move.b  (A1)+,D1        * data complete, make control word
         or      #hold,D1        * set hold bit
         move.b  D1,clcom        * send clock address and hold bit
         move.b  D2,cldata       * send clock data
         or      #write,D1       * set write bit
         move.b  D1,clcom        * send clock write command
         eori    #write,D1       * clear write bit
         move.b  D1,clcom        * send clock back comm wd - write bit
    
         btst    #0,D4           * see if even or odd loop pass
         beq     next            * even pass, next char is not delimiter
         move.b  (A2)+,D2        * odd pass, do dummy read on delimiter

next     subi    #1,D4           * pass finished, dec count
         bne     top             * go again if not done

         clr     D2
         move.b  D2,clcom        * clear hold bit
         rts


notval   move.l  #badchr,D1      * set up bad character prompt addr
         move.w  #outline,D0     * and bdos call number
         trap    #2              * print it
         jmp     _setclk         * go try again


toohi    move.l  #outrng,D1      * get msg for out of range digit
         move.w  #outline,D0
         trap    #2              * print it
         jmp     _setclk         * go try again


         .data
         .even
prompt   dc.b    'Enter date and time in 24 hour format: MM/DD/YY:HH:MM $'
badchr   dc.b    $0A,$0D,'Invalid digit entered !',$0A,$0D,'$'
outrng   dc.b    $0A,$0D,'Invalid Time or Date entered !',$0A,$0D,'$'   
digaddr  dc.b    $0A,$09,$08,$07,$0C,$0B,$05,$04,$03,$02
limit    dc.b    12,31,99,24,59

         .bss
         .even
inbuf    ds.b     mx              * input string buffer area

         .end

