/************************************************************************/
/*																								*/
/*	       					F C O P Y - v1.0											*/
/*				  					   by														*/
/*			 					Tim Olmstead												*/
/*																								*/
/*																								*/
/*	  		This program will (I hope) copy CP/M diskettes on an 				*/
/*	  		IBM PC/AT.																		*/
/*																								*/
/*			       																			*/
/************************************************************************/

/* permission is hereby granted to copy, modify and redistribute this code
 * in terms of the GNU Library General Public License, Version 2 or later,

 * at your option.

 */


/* Edit history.

   Date        Description

   ---------------------------------------------------------

   12-17-97    Third BETA release, v0.02


               - format on-the-fly working now

               - Known problem with Winbond FDC chip not fixed yet


   12-15-97    Second BETA release , v0.01


               - AI code implemented and working

               - 360k DOS format added to table

               - CP/M-86 8 sector format working with AI


   12-10-97    Initial BETA release, v0.00



*/


char version[32] = "FCOPY v0.02 **BETA** 12/17/97\n\n";

#include <stdio.h>
#include <stdlib.h>
#include <alloc.h>
#include <conio.h>
#include <dos.h>
#include <fcntl.h>
#include <time.h>
#include <bios.h>
#include <io.h>
#include "fcopy.h"

#define true -1
#define false 0


/* #define debug_proc		/* print proc headers during debug */
/* #define debug_chip		/* debug access to floppy chip */

#define timeout 1000000L
#define timeout_error -1
#define sr0_error -2
#define track_error -3

/* commands for read/write code */
#define read_cmd 0
#define write_cmd 1

#ifdef __cplusplus
	#define __CPPARGS ...
#else
	#define __CPPARGS
#endif


/* function prototype headers */
int	recal();
int	cmdstat(void);
int	resultstat(void);
void 	st0(void);
void  st1(void);   /* display status register 1 */
void  st2(void);	/* display status register 2 */
void 	select_drive(void);
void 	steal_vectors(void);
void 	show_status(void);
void 	fdc_specify(void);
void  wait_for_int(void);
int   sense_interrupt(void);
void  pfdata(int byte);
int   gfdata(void);
void  reset(void);
void  restore_vectors(void);
void	motor_off(void);
void  fdc_seek(int trk);
int   read_id(void);      /* read the id bytes from the disk */
void  display_results(void);   /* print out the value of the results bytes */
void  id_disk(void); /* identify media format */
void  dma_setup(unsigned int length, char mode, char *p);
int   read_track(int first_sector, int sec_cnt);
void  display(void);
void  get_results(void);
void  match_up(void);
void  crlf(void);
void id_track(void); /* identify media format on a track by trak basis */
void capture_data(void);
void usage(void);
void restore_disk(void);      /* write disk image from hard disk */
void capture_disk(void);      /* capture disk image to hard disk */
void read_cfg_file(void);     /* read disk info from cfg fiole */
void restore_data(void);      /* write disk image */
int format_track(int trk);   /* format track */
void make_fmt_list(int tk);
int write_track(int tk, int len);
int verify_track(int tk, int length);
int get_close(void);
void get_order(void);


/* This structure is used to hold the track definition read in from the CFG
   file created during a disk capture. */
struct track_definition
      {
         int   trk;     /* track # */
         int   hd;      /* head # */
         int   size;    /* sector size, uncoded */
         int   gap;     /* read/write gap length */
         int   fgap;    /* gap length for format */
         int   density; /* mfm/fm */
         int   speed;   /* data rate */
         int   min;     /* minimum sector # on track */
         int   max;     /* max sector # on track */
         int   num;     /* number of sectors on track */
         int   order[52]; /* sector numbering order list */
      };

/* disk is an array of track_definition structures large enough to hold the
   definition of the entire disk. At this time, the largest floppy disk
   supported has 80 tracks, and 2 heads. Thus, this structure will hold 160
   track definitions. */  
struct track_definition disk[160]; /* full description of disk */


/* Media type table. This table represents all media formats
   supported by FCOPY. It contains the definitions for EOT, GAP, Format GAP,
   sector size code, and FM/MFM values */

const num_formats = 20; /* 1... */
const eight_start = 0;  /* 8" drive starting point in table */
const eight_end   = 4;  /* end of 8" drives in table */
const five_start  = 5;  /* start of 5 1/4" drive tables */
const five_end    = 13; /* end of 5 1/4" drive tables */
const three_start = 14; /* start of 3.5" drive tables */
const three_end   = 19; /* end os 3.5" drive tables */
struct media
      {
         int fm_mfm;    /* FM/MFM code */
         int code;      /* sector size (encoded) */
         int speed;     /* data rate */
         int size;      /* sector size (unencoded) */
         int eot;       /* last sector on track */
         int gap;       /* gap byte size for read/write */
         int fmt_gap;   /* gap byte size for format */
      };

struct media media_type[num_formats] = {

   /* First group is for 8" Single Density (500 khz?) */
  { fm_mode,  0, khz250,  128, 0x1a, 0x7, 0x1b}, /* 8" SD,  128 BPS : type 0 */
  { mfm_mode, 1, khz500,  256, 0x1a, 0xe, 0x36}, /* 8" DD,  256 BPS : type 1 */
  { mfm_mode, 2, khz500,  512, 0xf, 0x1b, 0x54}, /* 8" DD,  512 BPS : type 2 */
  { mfm_mode, 3, khz500, 1024, 0x8, 0x35, 0x74}, /* 8" DD, 1024 BPS : type 3 */
  { mfm_mode, 4, khz500, 2048, 0x4, 0x99, 0xff}, /* 8" DD, 2048 BPS : type 4 */

   /* Double Density (360K) 5 1/4" drive (250KHZ) */
  { mfm_mode, 1, khz250,  256, 0x8, 0x18, 0x30}, /* 5 1/4" DD,  256 BPS : type 5 */
  { mfm_mode, 2, khz250,  512, 0x4, 0x46, 0x87}, /* 5 1/4" DD,  512 BPS : type 6 */
  { mfm_mode, 2, khz250,  512, 0x9, 0x2a, 0x50}, /* 5 1/4" DD,  512 BPS : type 7 */
  { mfm_mode, 3, khz250, 1024, 0x2, 0xc8, 0xff}, /* 5 1/4" DD, 1024 BPS : type 8 */

   /* High (or QUAD) Density 5 1/4" drive (500KHZ) */
  { mfm_mode, 1, khz500,  256, 0x10, 0x20, 0x32},/* 5 1/4" HD,  256 BPS : type 9 */
  { mfm_mode, 2, khz500,  512,  0x9, 0x2a, 0x50},/* 5 1/4" HD,  512 BPS : type 10*/
  { mfm_mode, 2, khz500,  512,  0xf, 0x1b, 0x54},/* 5 1/4" HD,  512 BPS : type 11 */
  { mfm_mode, 3, khz500, 1024,  0x4, 0x80, 0xf0},/* 5 1/4" HD, 1024 BPS : type 12*/
  { mfm_mode, 4, khz500, 2048,  0x2, 0xc8, 0xff},/* 5 /14" HD, 2048 BPS : type 13*/

   /* 3.5" 720K type format */
  { mfm_mode, 1, khz250,  256,  0xf,  0xe, 0x36},/* 3.5" HD,  256 BPS : type 14 */
  { mfm_mode, 2, khz250,  512,  0x9, 0x2a, 0x50},/* 3.5" HD,  512 BPS : type 15 */
  { mfm_mode, 3, khz250, 1024,  0x5, 0x35, 0x74},/* 3.5" HD, 1024 BPS : type 16 */

  /* 3.5" 1.44mb type format */
  { mfm_mode, 1, khz500,  256, 0x1e, 0x20, 0x32},/* 3.5" HD,  256 BPS : type 17 */
  { mfm_mode, 2, khz500,  512, 0x12, 0x1b, 0x6c},/* 3.5" HD,  512 BPS : type 18 */
  { mfm_mode, 3, khz500, 1024,  0x8, 0x35, 0x74} /* 3.5" HD, 1024 BPS : type 19 */
   };

int	page_table[4] = {	0x87, 0x83, 0x81, 0x82};
int	sizes[] = {128, 256, 512, 1024, 2048, 4096, 8192};
int 	dma_errno = 0;
int	ptn;	/* present track # */

void * old_fdc_isr;

char	c;
int 	a, b, i;
int	command;
int	port_num, port_data;
int	rate;    			/* step rate */
int   density;          /* data density : FM/MFM */
int	drive;				/* drive to use */
int   drive_type;       /* drive type code from BIOS */
int   cfg_type;         /* drive_type from CFG file */
int	head;					/* head # */
int   num_heads;        /* number of surfaces on diskette */
int	sector;				/* sector # */
int	track;				/* track for operation */
unsigned int   track_length;     /* length of a track */
int   num_tracks;       /* number of tracks on disk */
int	eot;					/* end of track sector # */
int	gap;					/* gap length */
int   fgap;             /* format gap length */
int	bps;					/* bytes per sector code */
int   this_media;       /* table entry for current media */
int	fdc_flag;			/* boolean flag used to indicate int */
char  *bp, *bp1;        /* disk buffer */
char  *fp, *fp1;        /* format buffer */
int	done;					/* floppy isr flag */
int	results[7];			/* a place to store the result bytes */
int	ok;					/* boolean flag to show no error */
int	double_sided;		/* flag to show double sided media */
int	max_sec, min_sec, num_sec;
int	sec_list[52];		/* array of sector numbers. Tarbell double density
									128 byte sectors has 52 sectors per track, so we
									pick that as our largest even though we aren't
									initialy going to support 8" media. This leaves
									the door open. */
FILE  *fopen(), *in_file, *readme_file, *log_file, *cfg_file, *data_file;
char  *s;
char  cmd = ' ';

void interrupt fdcint(__CPPARGS)

/* define our floppy isr */

{
	asm {   /* send EOI to interrupt controller */
		mov al, 0x20
		mov dx, 0x20
		out dx, al
	}
	done = -1;  /* show interrupt occured */
}

void main(int argc, char * argv[])

{
	clrscr();
   printf(version);
   drive = -1;
   while (--argc > 0)
      for (s = argv[argc]; *s != '\0'; s++)
      {
         switch (*s)
         {
            case 'a' :
            case 'A' : drive = 0;
                       break;
            case 'b' :
            case 'B' : drive = 1;
                       break;
            case 'c' :
            case 'C' : cmd = 'C';
                       break;
            case 'r' :
            case 'R' : cmd = 'R';
                       break;
         }
      }
   if ((drive < 0) | (cmd == ' '))
      usage();
   switch (cmd)
   {
      case 'C' : capture_disk();
                 break;
      case 'R' : restore_disk();
                 break;
   }
}

void restore_disk(void)   /* write disk image from hard disk */

{
/* open files for this run */
   if ((log_file = fopen("fcopy_r.log","w")) == NULL)
   {
      printf("Can't open log file.\n");
      abort();
   }
   fprintf(log_file, version);
	bp = (char *) malloc(16384);   /* allocate data buffer */
	if (bp == NULL)
   {
		printf("Can't allocate data buffer. ABORT\n");
		fprintf(log_file,"Can't allocate data buffer. ABORT\n");
      fclose(log_file);
      abort();
   }
 	fp = (char *) malloc(256);   /* allocate buffer for format info */
	if (bp == NULL)
   {
		printf("Can't allocate format buffer. ABORT\n");
		fprintf(log_file,"Can't allocate format buffer. ABORT\n");
      fclose(log_file);
      abort();
   }

   fprintf(log_file, "Restoring disk image.\n");
   printf("Restoring disk image.\n");

	steal_vectors();
   read_cfg_file();

   /* extract some parameters from the structure "disk" and use them
      to initialize some global variables. These are used to keep track
      of how the floppy controller is initialized as we work. */
   rate = disk[0].speed;   /* get starting data rate */
   bps = disk[0].size;     /* get starting sector size */
   density = disk[0].density; /* and density */
   reset();                /* reset floppy chip, set data rate */
   select_drive();         /* select drive for operation */
	recal();                /* go to track 0 */
   fdc_seek(20);           /* seek track 20 */
   recal();                /* then restore again */

   restore_data(); /* get the data from this diskette now */
	restore_vectors();
	motor_off();
	free(bp);		/* release dynamic memory */
   fclose(log_file);
}

void restore_data(void)

{
   int   t, h, last_track, length; /* temp vars */
   int   index, x;
   unsigned int num_read;   /* number actualy written */
   int      handle;

   if (_dos_open("fcopy.dat", O_RDONLY, &handle) != 0)
   {
      printf("Can't open data file.\n");
      fprintf(log_file, "Can't open data file.\n");
      fclose(log_file);
      abort();
   }
   last_track = 0;
   fdc_seek(0);   /* restore head */
   index = 0;     /* index var for table access */
   for (t = 0; t < num_tracks; t++)
      for (h = 0; h < num_heads; h++)
      {
         if (t != last_track) /* do we need to move the head? */
         {
            fdc_seek(t);      /* step the head */
            last_track = t;   /* keep track of where we are */
         }
         if (rate != disk[index].speed) /* check data rate */
         {                          /* did data rate change? */
            rate = disk[index].speed;   /* capture new data rate */
            reset();                /* set data rate */
         }
         if (bps != disk[index].size)   /* check sector size */
            bps = disk[index].size;     /* capture any change */
         if (density != disk[index].density) /* check density */
            density = disk[index].density; /* capture any change */

   /* format the track we are about to write */
         if (!format_track(index)) /* format the track using info in array "disk" */
         {
            printf("FATAL ERROR - Can't format diskette.\n");
            fprintf(log_file, "FATAL ERROR - Can't format diskette.\n");
            fclose(log_file);

         }
         length = sizes[disk[index].size];
         x = disk[index].num;
         length = length * x;


   /* read one track worth of  data */
         if (_dos_read(handle, bp, length, &num_read) != 0)
         {
            printf("FATAL ERROR - READ ERROR ACCESSING DATA FILE.\n");
            fprintf(log_file, "FATAL ERROR - READ ERROR ACCESSING DATA FILE.\n");
            fclose(log_file);
            abort();
         }
         if (num_read != length)
         {
            printf("FATAL ERROR - DOS READ DID NOT RETURN ENOUGH DATA.\n");
            fprintf(log_file,"FATAL ERROR - DOS READ DID NOT RETURN ENOUGH DATA.\n");
            fclose(log_file);
            abort();
         }
         if (num_read != 0) {}

   /* write the data to the floppy */
         if (!write_track(index, length))/* write data using info in array "disk" */
         {
            display_results();
            printf("*");

         }
         else
            printf(".");
         if (!verify_track(index, length))  /* verify track */
         {
            printf("%s, %x, %s %x %s ","VERIFY ERROR - track : ", t, " head : ", h, "\n");
         }
         ++index;          /* bump table pointer */
      }
   close(handle);
}

int write_track(int tk, int length)

{
/* assume that data rate and motor on times have already been set */

	int	x, dma_cmd, fpy_cmd, ok, tries;

#ifdef debug_proc
	printf(" write_track ");
#endif
   tries = 10;
   do
   {
	   dma_cmd = memory_read;           /* get DMA command */
	   fpy_cmd = 0x5 | disk[tk].density;/* get floppy chip command */
	   cmdstat();						/* make sure that we can issue a command */
	   dma_setup(length, dma_cmd, bp);/* set up the DMA for floppy read/write */
	   pfdata(fpy_cmd);   /* byte 1, no MT or SK */
	   x = (drive & 3) | ((disk[tk].hd & 1) << 2);
	   pfdata(x);					/* byte 2, no IPS, HD, drive */
      x = disk[tk].trk;
	   pfdata(x);			/* byte 3, track */
      x = disk[tk].hd;
	   pfdata(x);				/* byte 4, drive head */
      x = disk[tk].min;
	   pfdata(x);	/* sector # */
      x = disk[tk].size;
	   pfdata(x);				/* bytes/sector code as needed */
      x = disk[tk].max;
	   pfdata(x);     		/* end of track sector # */
      x = disk[tk].gap;
	   pfdata(x);				/* gap length */
      if (disk[tk].size == 0)
         pfdata(0x80);
      else
	      pfdata(0xff);
	   wait_for_int();
	   get_results();			/* get results of operation */
	   outp(dma_clear_ff, 0); /* clear byte pointer flip-flop */
      if ((results[0] & 0xc0) != 0)
      {
         ok = false;
         --tries;
      }
      else
         ok = true;
   }
   while ((!ok) && (tries > 0));
   outp(dma_mode, 0); /* make sure the dma controller shuts down */
   return ok;
}


int verify_track(int tk, int length)

{
/* assume that data rate and motor on times have already been set */

	int	x, dma_cmd, fpy_cmd, ok, tries;

#ifdef debug_proc
	printf(" verify_track ");
#endif
   tries = 10;
   do
   {
	   dma_cmd = memory_read;           /* get DMA command */
	   fpy_cmd = scan_equal | disk[tk].density;/* get floppy chip command */
	   cmdstat();						/* make sure that we can issue a command */
	   dma_setup(length, dma_cmd, bp);/* set up the DMA for floppy read/write */
	   pfdata(fpy_cmd);   /* byte 1, no MT or SK */
	   x = (drive & 3) | ((disk[tk].hd & 1) << 2);
	   pfdata(x);					/* byte 2, no IPS, HD, drive */
      x = disk[tk].trk;
	   pfdata(x);			/* byte 3, track */
      x = disk[tk].hd;
	   pfdata(x);				/* byte 4, drive head */
      x = disk[tk].min;
	   pfdata(x);	/* sector # */
      x = disk[tk].size;
	   pfdata(x);				/* bytes/sector code as needed */
      x = disk[tk].max;
	   pfdata(x);     		/* end of track sector # */
      x = disk[tk].gap;
	   pfdata(x);				/* gap length */
      if (disk[tk].size == 0)
         pfdata(0x80);
      else
	      pfdata(0xff);
	   wait_for_int();
	   get_results();			/* get results of operation */
	   outp(dma_clear_ff, 0); /* clear byte pointer flip-flop */
      if ((results[2] & 0xc) != 0x8)
      {
         ok = false;
         --tries;
      }
      else
         ok = true;
   }
   while ((!ok) && (tries > 0));
   outp(dma_mode, 0); /* make sure the dma controller shuts down */
   return ok;
}

void read_cfg_file(void)   /* read disk info from cfg file */
                                      
{
   int   t, x; /* temp variable */
   if ((cfg_file = fopen("fcopy.cfg","r")) == NULL)
   {
      printf("Can't open cfg file.\n");
      fprintf(log_file,"FATAL ERROR - CAN'T OPEN CFG FILE.\n");
      fclose(log_file);
      abort();
   }
   fprintf(log_file, "Reading config file....");
   fscanf(cfg_file, "%d %d %d %d %x", &cfg_type, &rate, &num_heads,
      &num_tracks, &density);
   for (t = 0; t < num_tracks*num_heads; t++) /* do all tracks */
   {
      fscanf(cfg_file, "%u %u %u %X %X %X %u %u %u %u",&disk[t].trk,
         &disk[t].hd, &disk[t].size, &disk[t].gap, &disk[t].fgap,
         &disk[t].density, &disk[t].speed, &disk[t].min, &disk[t].max,
         &disk[t].num);
      for (x = 0; x < disk[t].num; x++) /* read in sector ordering */
         fscanf(cfg_file, "%d", &disk[t].order[x]);
   }
   fprintf(log_file,"Done.\n");
   fclose(cfg_file);   /* Through with cfg file now */
}

void capture_disk(void)  /* capture disk image to hard disk */

{
/* open files for this run */
   if ((log_file = fopen("fcopy_c.log","w")) == NULL)
   {
      printf("Can't open log file.\n");
      abort();
   }
   fprintf(log_file, version);
   if ((cfg_file = fopen("fcopy.cfg","w")) == NULL)
   {
      printf("Can't open cfg file.\n");
      abort();
   }
	bp = (char *) malloc(16384);
	if (bp == NULL)
   {
		printf("Can't allocate temp buffer. ABORT\n");
		fprintf(log_file,"Can't allocate temp buffer. ABORT\n");
      abort();
   }
	steal_vectors();
	head = 0;
	sector = 1;
	gap = 0x2a;	/* fake gap length for now */

   fprintf(log_file, "Capturing disk image.\n");
   printf("Capturing disk image.\n");
	id_disk();
   if (rate == 1)
   {
      printf("Accessing a 360K floppy in a 1.2m drive is not supported.\n");
      fprintf(log_file,
         "Accessing a 360K floppy in a 1.2m drive is not supported.\n");
      fclose(log_file);
      fclose(cfg_file);
      abort();
   }
   match_up(); /* try to match media format with a table entry */
   if (this_media >= 0)
   {
      fprintf(log_file, "Media type = %u", this_media);
   }
   else
   {
      printf("Media type not found in table. AI enabled.\n");
      fprintf(log_file, "Media type not found in table. AI enabled.\n");
      if (!get_close()) /* can we get close? */
      {                 /* too bad, we failed */
         printf("Attempt failed.\n");
         fprintf(log_file, "Attempt failed.\n");
         fclose(log_file);
         fclose(cfg_file);
         abort();
      }
      else
      {

      }
   }
   crlf();
   capture_data(); /* get the data from this diskette now */
	restore_vectors();
	motor_off();
	free(bp);		/* release dynamic memory */
   fclose(log_file);
   fclose(cfg_file);
}

void usage(void)

{
   printf("Usage : fcopy [drive letter] [command]\n");
   printf("        drive letter is required\n");
   printf("        and must be A or B\n");
   printf("\n");
   printf("        Command : \n");
   printf("          r  : restore image\n");
   printf("          c  : capture image\n");
   printf("\n");
   printf("       Parameters are NOT case sensitive and may appear\n");
   printf("       in any order.\n");
   printf("\n");
   abort();
}

void capture_data(void)

{
   unsigned int num_written;   /* number actualy written */
   int      handle;
   num_written = 0;           /* fool this DUMB compiler */
   int   tries = 5;
   int   ok = false;
   int   last_track;

   if (_dos_creat("fcopy.dat", _A_NORMAL, &handle) != 0)
   {
      printf("Can't open output file for data.\n");
      fprintf(log_file, "Can't open output file for data.\n");
      fclose(log_file);
      abort();
   }
   track_length = (media_type[this_media].size * num_sec); /* track length */
   fprintf(log_file, "%s %u %s %u %s %u %s","Track length = ", track_length,
    " This_media= ", this_media, " Size = ", media_type[this_media].size,"\n");
   fprintf(log_file, "trk hd size gap fgap density speed min max num order\n");

   last_track = 0;
   for (track = 0; track < num_tracks; track++)  /* scan the disk */
      for (head = 0; head <= (num_heads-1); head++)
      {
         id_track(); /* id media format for this track */
         ok = false; /* preset for retries */
         tries = 5;
         if (last_track != track)
         {
            fdc_seek(track);
            last_track = track;
         }
         do
         {
            if (read_track(min_sec, num_sec)) /* read a track */
            {
               _dos_write(handle, bp, track_length, &num_written);
               if (num_written != 0) {}
               printf(".");
               ok = true;
            }
            else
            {
               printf("*");
               display_results();
               --tries;
            }
         }
         while ((tries > 0) && (!ok));
      }
   close(handle);
}                              

void crlf(void)

{
   printf("\n");
   fprintf(log_file, "\n");
}

void match_up(void)

{
   int   x, y, z, found;
   int   start, finish;

   found = false; /* start out pessimistic */
   switch (drive_type)
   {
      case 1 : start = five_start;  /* 5.25", 360K drive */
               finish = five_end;
               break;
      case 2 : start = five_start;  /* 5.25", 1.2mb drive */
               finish = five_end;
               break;
      case 3 : start = three_start; /* 3.5", 720K drive */
               finish = three_end;
               break;
      case 4 : start = three_start; /* 3.5", 1.44mb drive */
               finish = three_end;
               break;
   } /* end switch */
   fprintf(log_file, "%s %u %s %u %s %u %s", "start = ", start, " finish = ",
      finish, " drive_type = ", drive_type, "\n");
   for (this_media = start; this_media <= finish; this_media++)
   {
      x = media_type[this_media].speed;   /* check data rate */
      if (x == rate)
      {
         y = media_type[this_media].code;  /* check sector size */
         if (y == bps)
         {
            z = media_type[this_media].fm_mfm;  /* check fm/mfm */
            if (z == density)
               if (eot == media_type[this_media].eot)
               {
                  found = true; /* show that we found a match */
                  break;
               }
         } /* if (y == bps) */
      }    /* if (x == rate) */
   }       /* for */
   if (!found)
      this_media = -1; /* show error */
}


int get_close(void)

/* This function will try to get close to the parameters of the disk just id'd.
   Data rate, density, and sector size must match. Number of sectors per track
   is flexible.

   This routine is a severly hacked version of match_up().
*/   
{
   int   x, y, z, found;
   int   start, finish;
   float percent, ty, tz;

   found = false; /* start out pessimistic */
   switch (drive_type)
   {
      case 1 : start = five_start;  /* 5.25", 360K drive */
               finish = five_end;
               break;
      case 2 : start = five_start;  /* 5.25", 1.2mb drive */
               finish = five_end;
               break;
      case 3 : start = three_start; /* 3.5", 720K drive */
               finish = three_end;
               break;
      case 4 : start = three_start; /* 3.5", 1.44mb drive */
               finish = three_end;
               break;
   } /* end switch */
   fprintf(log_file, "%s %u %s %u %s %u %s", "start = ", start, " finish = ",
      finish, " drive_type = ", drive_type, "\n");
   for (this_media = start; this_media <= finish; this_media++)
   {
      x = media_type[this_media].speed;   /* check data rate */
      if (x == rate)
      {
         y = media_type[this_media].code;  /* check sector size */
         if (y == bps)
         {
            z = media_type[this_media].fm_mfm;  /* check fm/mfm */
            if (z == density)
            {
               found = true; /* show that we found a match */
               break;
            }
         } /* if (y == bps) */
      }    /* if (x == rate) */
   }       /* for */
   if (!found)
   {
      this_media = -1; /* show error */
      return false;
   }
   x = this_media; /* capture pointer to media_table */
   fprintf(log_file,"%s %u %s", "Using table entry ",x,".\n");
   fprintf(log_file,"%s %u %s %u %s %u %s ","Wanted : rate = ", rate,
      " size = ", bps, " density = ",density, " spt = ", eot,".\n");
   fprintf(log_file,"%s %u %s %u %s %u %s ","Got    : rate = ",
      media_type[x].speed," size = ", media_type[x].code, " density = ",
      media_type[x].fm_mfm, " spt = ", media_type[x].eot,".\n");
/* OK! We have found a match for drive type, data rate, density, and
   sector size. Now we will try to extarpolate the gap values from this
   table entry.
*/
   z = media_type[x].eot;
   y = eot - z; /* calculate the difference between spt
                                    wanted and actual */
   ty = y; /* convert to floating point */
   tz = z;
   if (y > 0)     /* is table entry less spt than actual? */
   {              /* yes, actual is greater than table entry */
      fprintf(log_file, "Table entry is less than actual spt.\n");
      percent = (tz/ty); /* what percent of table is difference? */
      fgap = (media_type[x].fmt_gap * percent) * 0.6; /* calculate format gap
                                                         length */
   }
   else           /* no, actual is less than table entry */
   {
      y = y * -1; /* make positive # */
      fprintf(log_file, "Table entry is greater than actual spt.\n");
      percent = (ty/tz); /* what percent of table is difference? */
      fgap = (media_type[x].fmt_gap * percent) * 0.5; /* calculate format gap
                                                         length */
   }
   gap = (fgap/2)-1; /* per Allison */
   if (fgap > 0xff)
      fgap = 0xff;

   media_type[x].gap = gap;         /* sub in the new values */
   media_type[x].fmt_gap = fgap;    /* into the table so we can use */
   media_type[x].eot = eot;         /* this entry for subsequent ops */
   fprintf(log_file,"%s %x %s %x %s","Calculated values are : gap = ", gap,
      " fgap = ", fgap, ".\n");
   printf("%s %x %s %x %s","Calculated values are : gap = ", gap,
      " fgap = ", fgap, ".\n");
   return true;
}

void display(void)

{
	int x, z;
	char y;
	bp1 = bp;	/* copy pointer to data buffer */
	for (x=1; x<=16; x++)
	{
		y = *bp1;
		z = y;
		z = z & 0xff;
		printf(" %X",z);
		bp1++;
	}
	printf("\n");
}

void try_id(void)

{
	for (rate=0; rate <=3; rate++)  /* step through data rates */
	{
		reset();
		select_drive();
		recal();
		if (read_id()) break;
	}
}

int   check_density(void)

{
   return(read_id());
}

void get_density(void)

{
   density = mfm_mode;  /* try mfm first */
   try_id();            /* see if it works */
   if (ok) return;      /* if ok, bye bye */

   /* If we get here, it wasn't mfm. Try fm. */
   density = fm_mode;  /* try mfm first */
   try_id();            /* try single density */
}

void id_track(void) /* identify media format on a track by track basis */

/* Id the parameters for the currently selected track. It is assumed that
   id_disk has been called at least once to verify that there is a diskette
   that we can talk to present. This routine will be used to get the info
   for each track as the data is read from the disk. */

{
/* Assume that initial density, and rate, have been determined. Use those
   values to make sure we can read this track. If we encounter a track with
   a different format, we will figure it al out again. If we can get away with
   using the same parameters as last time, it will be faster as we don't have
   to test all the different data rates. */

   if (!check_density())
   {
      get_density();
   }
	if (!ok)
   {

/* This would be a fatal error. If id_disk couldn't identify the disk, we should
   have never gotten this far. */

		printf("FATAL ERROR : Unreadable track. ** ABORTING **\n");
		fprintf(log_file,"FATAL ERROR : Unreadable track. ** ABORTING **\n");
      fclose(log_file);
      fclose(cfg_file);
/*      abort(); */
   }
   bps = results[6]; /* set for read ops */

/* OK! data rate, and sector size are known. Now find out how many sectors
	per track there are. Also record sector number ordering. */

   get_order();   /* use common code to get sector ordering, min, max, etc. */
   
/* write parameters to log file, and cfg file */
   fprintf(cfg_file,"%u %u %u %X %X %X %u %u %u %u",track, head, bps,
      media_type[this_media].gap, media_type[this_media].fmt_gap,
      density, rate, min_sec, max_sec, num_sec);  /* write to cfg file */
   fprintf(log_file,"%u %u %u %X %X %X %u %u %u %u",track, head, bps,
      media_type[this_media].gap, media_type[this_media].fmt_gap,
      density, rate, min_sec, max_sec, num_sec);  /* write to cfg file */

/*	      Sector ordering is : */
	for (a = 0; a < num_sec; a++)
   {
		fprintf(cfg_file, " %u", sec_list[a]); /* display sector ordering */
		fprintf(log_file, " %u", sec_list[a]); /* display sector ordering */
   }
   fprintf(cfg_file, "\n");
   fprintf(log_file, "\n");
}

void get_order(void)

{
   int   a, tries;

	for (a=0; a<52; a++)		/* zap the sector number list */
	   sec_list[a] = 0xff;
	min_sec = 100; 				/* preset vars out of range for test */
	max_sec = -1;
	for (a=0; a < 75; a++)		/* find lowest/ highest sec # */
	   {
         tries = 10; /* how long before we quit */
         do
         {
		      if (read_id())
            {
		         if (results[5] < min_sec)
			         min_sec = results[5];
               if (results[5] > max_sec)
			         max_sec = results[5];
               ok = true;  /* show that it worked */
            }
            else
            {
               ok = false; /* show that we had a problem */
               --tries;
            }
         }
         while ((tries > 0) && (!ok));
	   }
	   eot = max_sec; /* save end of track sector # */

/*	We must find the beginning of the track again now. We spent some time
	printing messages, and we need to get back into sync with the disk again */

	      do
		      read_id();					/* read the next sector id bytes */
	      while (results[5] != min_sec);	/* find the first sector again */

	      a = 0;
         sec_list[a] = results[5];  /* store first sector # */
         ++a;                       /* point to next list entry */
	      num_sec = 0;					/* count them as we go */
	      do
	      {
		      read_id();				   /* read the next sector id bytes */
		      sec_list[a] = results[5]; /* add it to the list */
		      ++a;                    /* bump index pointer */
		      ++num_sec;					/* and count this sector too */
	      }
	      while (results[5] != min_sec);	/* go around the disk once */
}

void  id_disk(void) /* identify media format */

{
   union REGS regs;

   regs.h.ah = 0x8; /* function number */
   regs.h.dl = drive; /* drive to query */
   int86(0x13, &regs, &regs); /* ask bios about the drive */
   drive_type = regs.h.bl;    /* get the answer */
   printf("%s %u %s","Drive # = ", drive," Drive type = ");
   fprintf(log_file, "Drive type = ");
   switch (drive_type)
   {
      case 1 : printf("5.25, 360K\n");
               fprintf(log_file, "5.25, 360K\n");
               break;
      case 2 : printf("5.25, 1.2M\n");
               fprintf(log_file, "5.25, 1.2M\n");
               break;
      case 3 : printf("3.5, 720K\n");
               fprintf(log_file, "3.5, 720K\n");
               break;
      case 4 : printf("3.5, 1.44m\n");
               fprintf(log_file, "3.5, 1.44m\n");
               break;
   }
   get_density(); /* get density and rate */
	printf("Identifying diskette : ");
	fprintf(log_file, "Identifying diskette : ");
	if (!ok)
   {
		printf("Unable to identify media.\n");
		fprintf(log_file, "Unable to identify media.\n");
   }
	else
		{
			printf("Data rate = ");
			fprintf(log_file, "Data rate = ");
			switch (rate)
			{
				case 0 : printf("500 KHZ, ");
                     fprintf(log_file, "500 KHZ, ");
							break;
				case 1 : printf("300 KHZ, ");
                     fprintf(log_file, "300 KHZ, ");
							break;
				case 2 : printf("250 KHZ, ");
                     fprintf(log_file, "250 KHZ, ");
							break;
				case 3 : printf("1000 KHZ\n");
                     fprintf(log_file, "1000 KHZ, ");
							break;
			} /* end switch (rate) */
	      head = 1;
	      read_id();
	      if (ok)
	      {
		      printf("DS");
		      fprintf(log_file, "DS");
		      double_sided = true;
	      }
	      else
	      {
		      printf("SS");
		      fprintf(log_file, "SS");
		      double_sided = false;
	      }
         if (density == fm_mode)
         {
            printf("SD\n");
            fprintf(log_file, "SD\n");
         }
         else
         {
            printf("DD\n");
            fprintf(log_file, "DD\n");
         }
         if (double_sided)
            num_heads = 2;
         else
            num_heads = 1;
			printf("Sector size = ");
			fprintf(log_file, "Sector size = ");
			bps = results[6]; /* set for read ops */
			switch (results[6])
			{
				case 0 : printf("128 bytes per sector.\n");
                     fprintf(log_file, "128 bytes per sector.\n");
							break;
				case 1 : printf("256 bytes per sector.\n");
                     fprintf(log_file, "256 bytes per sector.\n");
							break;
				case 2 : printf("512 bytes per sector.\n");
                     fprintf(log_file, "512 bytes per sector.\n");
							break;
				case 3 : printf("1024 bytes per sector.\n");
                     fprintf(log_file, "1024 bytes per sector.\n");
							break;
				case 4 : printf("2048 bytes per sector.\n");
                     fprintf(log_file, "2048 bytes per sector.\n");
							break;
				case 5 : printf("4096 bytes per sector.\n");
                     fprintf(log_file, "4096 bytes per sector.\n");
							break;
				case 6 : printf("8192 bytes per sector.\n");
                     fprintf(log_file, "8192 bytes per sector.\n");
							break;
			} /* end switch (results[6])*/
	      head = 0;

/* OK! data rate, and sector size are known. Now find out how many sectors
	per track there are. Also record sector number ordering. */

         get_order();   /* get sector order */
	      printf("%s %u %s %u %s","Min_sec = ", min_sec," Max_sec = ",
            max_sec, "\n");
	      fprintf(log_file, "%s %u %s %u %s","Min_sec = ", min_sec," Max_sec = ",
            max_sec, "\n");

/* Display sector ordering */

	      printf("%s %u %s", "Total # of sectors is ", num_sec, "\n");
	      fprintf(log_file, "%s %u %s", "Total # of sectors is ", num_sec, "\n");
	      printf("Sector ordering is : ");
	      fprintf(log_file, "Sector ordering is : ");
	      for (a = 0; a < num_sec; a++)
         {
		      printf(" %u", sec_list[a]); /* display sector ordering */
		      fprintf(log_file, " %u", sec_list[a]); /* display sector ordering */
         }

/* Find out how many tracks there are */

         a = -1;   /* start at track 0 */
         ok = true;
         do
         {
            ++a;     /* bump track # */
            fdc_seek(a); /* try to go there */
            if (!read_id())   /* is there readable data there ? */
               ok = false;
         }
         while ((results[3] == a) & (ok));  /* does the track # match what
                                          we think it should be ? */
         fdc_seek(0);            /* go back to track 00 */
         num_tracks = a;         /* capture results */

/*    Display what we found */
         
         printf("\nNumber of tracks is : %u", num_tracks);
         fprintf(log_file, "\nNumber of tracks is : %u", num_tracks);
         crlf();
         fprintf(log_file,"drive rate heads tracks density\n");
         fprintf(log_file,"%u %u %u %u %X %s", drive_type, rate, num_heads,
            num_tracks, density, "\n");
         fprintf(cfg_file,"%u %u %u %u %X %s", drive_type, rate, num_heads,
            num_tracks, density, "\n");

		}  /* end else !ok */
}        /* end id_disk */

int  read_id(void)      /* read the id bytes from the disk */

{
	int	x;

	ok = true; /* start out optimistic */
	done = 0;
	cmdstat();	/* make sure we can issue a command */
	x= readid | density;
	pfdata(x);   /* issue the command */
	x = ((head & 1) << 2) | (drive & 3);
	pfdata(x);
	wait_for_int(); 
	get_results();
	if(((results[0] & 0xc0) == 0x00 ) && (results[1] == 0))
		return true;
   else
   {
	   ok = false;
      return false;
   }
}

void get_results(void)

{	int	x;	
	do      	/* wait for chip to be ready with result bytes */
	{	x = inp(fstatus);
      x = x & 0xc0; }
	while (x != 0xc0);
	for (x=0; x <=6; x++)
	{
		results[x] = gfdata();
	}
   x = inp(fstatus);
   if ((results[0] & 0xc0) != 0)
   {
      display_results;
/*      abort(); */
   }

}

void display_results(void)   /* print out the value of the results bytes */

{
	printf("Result bytes :\n");
	printf("------------------------------\n");
	fprintf(log_file,"Result bytes :\n");
	fprintf(log_file,"------------------------------\n");
	st0();	/* display status register 0 */
	st1();	/* display status register 1 */
	st2(); 	/* display status register 2 */
	printf("Track = %x\n", results[3]); /* track # */
	printf("Head = %x\n",  results[4]); /* head # */
	printf("Sector = %x\n", results[5]); /* sector # */
	printf("BP/S = %x\n", results[6]); /* BP/S # */
	fprintf(log_file,"Track = %x\n", results[3]); /* track # */
	fprintf(log_file,"Head = %x\n",  results[4]); /* head # */
	fprintf(log_file,"Sector = %x\n", results[5]); /* sector # */
	fprintf(log_file,"BP/S = %x\n", results[6]); /* BP/S # */
}

void fdc_seek(int trk)

{
	done = 0;
	cmdstat();						/* make sure chip is ready for a command */
	pfdata(seek_cmd);
	pfdata(drive);
	pfdata(trk);
	wait_for_int();
	sense_interrupt();
}

void	motor_off(void)

{
 	outp(drv_control, 0xc);	/* turn off the floppy motor */
}

void steal_vectors(void)

{
	unsigned int	sg, of, tof;

#ifdef debug_proc
	printf(" steal_vectors ");
#endif
	old_fdc_isr = getvect(fdc_vec);
/*	setvect(fdc_vec, fdcint); */
	sg = FP_SEG(fdcint); /* get the pieces of */
	of = FP_OFF(fdcint);	/* the vector */
	tof = fdc_vec * 4; 			/* point to vector in table */
	poke(0, tof, of);				/* plug the vector back into the table */
	poke(0, tof+2, sg);
}


void restore_vectors(void)

{
	unsigned int	sg, of, tof;
#ifdef debug_proc
	printf(" restore_vectors ");
#endif
	sg = FP_SEG(old_fdc_isr); /* get the pieces of */
	of = FP_OFF(old_fdc_isr);	/* the old vector */
	tof = fdc_vec * 4; 			/* point to vector in table */
	poke(0, tof, of);				/* plug the vector back into the table */
	poke(0, tof+2, sg);
}

int	recal(void)

/*	move the head to cylinder zero, return TRUE if successful	*/
/*	print error message if unsuccessful				*/
{
int	k;			/* try counter				*/

	for(k=0; k < 3; k++)
	{
		done = 0;
		pfdata(recalibrate);	   /* send command byte			*/
		pfdata(drive);	         /* recal cmd has two bytes */
		wait_for_int();			/* wait for interrupt */
		sense_interrupt();	   /* check status */
		if ((results[0] & 0xc0) == 0x00) return true;
	}/* for */
	printf("\nRecal error drive %c ",drive+'A');
	if ((results[0] & 0x3) != drive ) printf("incorrect drive select\n");
	if ((results[0] & 0xc0) != 0 ) printf("not ready\n");
	if ((results[0] & equipment) != 0 ) printf("equipment error\n");
	return(false);
}	/* recal */


/* reads the 8272 status port until the chip is ready for a command	*/
/* byte, must be done before each command byte is sent to the 8272	*/

int	cmdstat(void)
{
	int	x;

	do
      x = inp(fstatus);
	while (( x & 0x80)!= 0x80);
    return(true);
}

int	resultstat(void)
{
	int x;
	do
		x = (inp(fstatus) & 0xc0);
	while (x != 0xc0) ;
	return(true);
}

/*	 print value of 8272 status register 0's bits			*/

void st0(void)
{
int  drive,hd,nr,ec,se,ic, byte;
    
   byte = results[0];
    drive = byte & 3;			/* drive number			   */
    hd   = (byte >> 2) & 1;	/* head address ie; 0 or 1	*/
    nr   = (byte >> 3) & 1;	/* not ready if 1		      */
    ec   = (byte >> 4) & 1;	/* equipment check		   */
    se   = (byte >> 5) & 1;	/* seek end			         */
    ic   = (byte >> 6) & 3;	/* interrupt code, does not*/
	 printf("ST0>  %s %u %s %u %s %u %s %u %s %u %s %u \n",
	"drive = ",drive,
	" head = ",hd," nr = ",nr," ec = ",ec," se = ",se," ic = ",ic);
	 fprintf(log_file, "ST0>  %s %u %s %u %s %u %s %u %s %u %s %u \n",
	"drive = ",drive,
	" head = ",hd," nr = ",nr," ec = ",ec," se = ",se," ic = ",ic);
}/* st0 */

void st1(void)   /* display status register 1 */

{
	int eot, crc, or, nd, nw, mam, data;

   data = results[1];
	eot = (data >> 7) & 1; 		/* EOT bit */
	crc = (data >> 5) & 1;   	/* crc error bit */
	or  = (data >> 4) & 1;		/* over run error */
	nd  = (data >> 2) & 1;		/* no data */
	nw  = (data >> 1) & 1;		/* write protect */
	mam = (data & 1);				/* missing address mark */
	printf("ST1 > %s %u %s %u %s %u %s %u %s %u %s %u \n",
	"EPT = ",eot, " CRC = ",crc," OR = ",or," ND = ",nd," nw = ",
		nw," MAM = ",mam);
	fprintf(log_file, "ST1 > %s %u %s %u %s %u %s %u %s %u %s %u \n",
	"EPT = ",eot, " CRC = ",crc," OR = ",or," ND = ",nd," nw = ",
		nw," MAM = ",mam);
}

void st2(void)	/* display status register 2 */

{
	int	cm, crcdata, wt, seh, sns, bt, mamdata, data;

   data = results[2];
	cm = (data >> 7) & 1;			/* control mark */
	crcdata = (data >> 6) * 1;   /* crc error in data */
	wt = (data >> 5) & 1;			/* wrong track */
	seh = (data >> 3) & 1;			/* scan equal hit */
	sns = (data >> 2) & 1;			/* scan not satisfied */
	bt = (data >>1) & 1;				/* bad track */
	mamdata = (data & 1);				/* missing address mark for data */
	printf("ST2>  %s %u %s %u %s %u %s %u %s %u %s %u %s %u \n",
	"CM = ",cm, " CRC_DATA = ",crcdata," WT = ",wt," SEH = ",seh," SNS = ",
		sns," BT = ", bt, " MAM_DATA = ",mamdata);
	fprintf(log_file, "ST2>  %s %u %s %u %s %u %s %u %s %u %s %u %s %u \n",
	"CM = ",cm, " CRC_DATA = ",crcdata," WT = ",wt," SEH = ",seh," SNS = ",
		sns," BT = ", bt, " MAM_DATA = ",mamdata);
}

void select_drive(void)

/* select the drive specified by the global variable "drive". */

{
	int	x;
#ifdef debug_proc
	printf(" select_drive ");
	show_status();
#endif

	if (drive == 0)
		x = dsel0 | 0xc;
	else
		x = dsel1 | 0xc;
	outp(drv_control, x);
}

void show_status(void)

{
	int x;
	x = inp(fstatus);
	printf("Main status = %x", x);
}

void reset(void)

{
	int 	ok = 0;
	long 	start, now;

#ifdef debug_proc
	printf(" reset ");
#endif

   _bios_timeofday(_TIME_GETCLOCK, &start); 
	done = 0;
	outp(frate, rate);			/* set data rate */
	outp(drv_control, 0x0c);	/* verify that reset (bit D2 of DOR) is high */
	outp(drv_control, 0x08);	/* strobe reset low */
	outp(drv_control, 0x0c);	/* set reset pin back to high */
	wait_for_int();		      /* wait for int from floppy chip */
	do {
		if(inp(fstatus) == 0x80) {
			ok = 1;
			break;   }
		_bios_timeofday(_TIME_GETCLOCK, &now);   }
	while (now < (start + timeout)); /* for timeout feature, waiting for
													xtal to stabilize */
	if (! ok) return;
	sense_interrupt();	/* sr0 = 0xc0 */
	sense_interrupt();	/* sr0 = 0xc1 */
	sense_interrupt();	/* sr0 = 0xc2 */
	sense_interrupt();	/* sr0 = 0xc3 */
	fdc_specify();				/* to set step rate time, motor off time, motor on time,
									and dma */
}

int sense_interrupt(void)

{
#ifdef debug_proc
	printf(" sense_interrupt ");
#endif
	cmdstat();
   pfdata(0x08);		      /* command byte of sense interrupt command */
	results[0] = gfdata();  /* get st0 */
	results[1] = gfdata();	/* read present track # too */
   if ((results[0] & 0xc0) != 0)
      return false;
   else
      return true;
}

void fdc_specify(void)

{
#ifdef debug_proc
	printf(" fdc_specify ");
#endif
	cmdstat();				/* and can accept a command */
	pfdata(3);	         /* specify command */
	pfdata(0xaf);        /* from IBM tech ref manuals */
	pfdata(0x2);
	while ((inp(fstatus) & 0x10) == 0x10) ;
}

void wait_for_int(void)

{
	do
		if (done == true)
			return;
	while (done == 0);
}                               

void pfdata(int byte)

{
#ifdef debug_proc
	printf(" pfdata ");
#endif
   while ((inp(fstatus) & 0xc0) != 0x80) ;
   outp(fdata, byte);
}


int gfdata(void)
/*
This function is used to read a byte from the floppy controller.
*/

{
#ifdef debug_proc
	printf(" gfdata ");
#endif
   while ((inp(fstatus) & 0xc0) != 0xc0) ;
	return inp(fdata);
}

int format_track(int trk) /* format track */

/* glogal variables density, track, head, bps,
   and drive must be set prior to call */

{
	int	x, dma_cmd, fpy_cmd;
	int	length;
   int   tries = 10;

#ifdef debug_proc
	printf(" format_track ");
#endif
   do
   {
      make_fmt_list(trk);        /* make the data for the format */
      fpy_cmd = format_trk | disk[trk].density;  /* floppy command */
	   dma_cmd = memory_read;     /* get DMA command */
	   length = disk[trk].num * 4;/* calculate xfer length */
	   cmdstat();						/* make sure that we can issue a command */
	   dma_setup(length, dma_cmd, fp);/* set up the DMA for format */
	   pfdata(fpy_cmd);   /* byte 1, no MT or SK */
	   x = (drive & 3) | ((disk[trk].hd & 1) << 2);
	   pfdata(x);					/* byte 2, no IPS, HD, drive */
      x = disk[trk].size;
	   pfdata(x);	/* byte 3, bytes/sector code */
      x = disk[trk].num;
	   pfdata(x);  /* # of sectors per track */
      x = disk[trk].fgap;
	   pfdata(x);	/* gap length */
	   pfdata(0xf6);  /* data pattern */
	   wait_for_int();
	   get_results();			/* get results of operation */
	   outp(dma_clear_ff, 0); /* clear byte pointer flip-flop */
      if ((results[0] & 0xc0) == 0)
         return true;
   }
   while (tries < 0);    /* give it 10 tries to work */
   return false;
}       /* format_track */

void make_fmt_list(int tk)

/* The format command requires 4 bytes of information for each sector on
   the track. Here we will build that information in the global buffer */

{
   int   x;

   fp1 = fp; /* clone the pointer to the buffer */
   for (x = 0; x < disk[tk].num; x++)
   {
      *fp1 = disk[tk].trk;       /* track # */
      fp1++;                      /* bump pointer */
      *fp1 = disk[tk].hd;        /* head # */
      fp1++;                      /* bump pointer again */
      *fp1 = disk[tk].order[x];  /* sector # */
      fp1++;                      /* yup, one more time */
      *fp1 = disk[tk].size;      /* encoded sector size */
      fp1++;                      /* are we done yet? */
   }
}

int read_track(int first_sector, int sec_cnt)

{
/* assume that data rate and motor on times have already been set */

	int	x, dma_cmd, fpy_cmd;
	int	length;
   int   tries = 10;

#ifdef debug_proc
	printf(" read_track ");
#endif
   do
   {
	dma_cmd = memory_write;    /* get DMA command */
	fpy_cmd = 0x6 | mfm_mode;  /* get floppy chip command */
	length = sizes[bps] * sec_cnt; /* get xfer length */
   cmdstat();						/* make sure that we can issue a command */
	dma_setup(length, dma_cmd, bp);/* set up the DMA for floppy read/write */
	pfdata(fpy_cmd);        /* byte 1, no MT or SK */
	x = (drive & 3) | ((head & 1) << 2); 
	pfdata(x);					/* byte 2, no IPS, HD, drive */
	pfdata(track);			   /* byte 3, track */
	pfdata(head);				/* byte 4, drive head */
	pfdata(first_sector);	         /* sector # */
	pfdata(bps);				/* bytes/sector code as needed */
	pfdata(eot);     		   /* end of track sector # */
	pfdata(gap);				/* gap length */
	pfdata(0xff);
	wait_for_int();
	get_results();			/* get results of operation */
	outp(dma_clear_ff, 0); /* clear byte pointer flip-flop */
   if ((results[0] & 0xc0) == 0)
   {
      ok = true;
      return true;
   }
   else
   {
      ok = false;
      --tries;
   }
  }
   while ((tries > 0) && (!ok));
   outp(dma_mode, 0);   /* make sure the dma controller shuts down */
   return false;
 }


void dma_setup(unsigned int xfer_length, char mode, char *p)
/* DMA dma controller setup routine.   */

/*	mode = 'r' (for a DMA read from memory, i.e. for a floppy diak write).
			 'w' (for a DMA write to memory, i.e. for a floppy read)
*/

{
	long  page;
	long	temp;
	long  tof, ts, t1;
                                        
#ifdef debug_proc
	printf(" dma_setup");
#endif
	asm {	CLI };	/* disable interrupts */
	outp(dma_clear_ff, 0);  /* clear byte pointer ff */
	outp(dma_mode, mode); 

	/* Convert seg:ofs type buffer address to flat address.
		Extract page value and write to page register. */
	tof = FP_OFF(p); /* get offset of buffer pointer */
	ts = FP_SEG(p);	/* get segment */
	t1 = (ts << 4);   /* shift segment 4 bits to the left */
	temp = (tof + t1); /* combine to form flat mamory address */

	/* load starting address --- least significant byte first */
	outp(dma2_address, (temp & 0xff));
	outp(dma2_address, ((temp >> 8) & 0xff));

   /* get value for page register */
	page = ((temp >> 16)& 0xf); /* get page value; DMA only has 16 bits of addr */
	outp(dma_page, page); /* write to page register for DMA channel 2 */

	/* load count register --- lsb byte first */
	xfer_length--;                             /* decrement xfer length */
	outp(dma2_count, (xfer_length & 0xff));    /* write low byte of xfer count */
	outp(dma2_count, ((xfer_length >> 8) & 0xff)); /* write high byte of xfer count */
	asm { STI };	/* enable interrupts */
	outp(dma_mask, mask);	/* clear mask register for channel 2 */
}


