;*******************************************************************************
;*                                  z80em86                                    *
;*           A Z80 CPU emulator coded in Intel 86 assembly language            *
;*                                                                             *
;*                               Bit Set Group                                 *
;*                                                                             *
;*                    Copyright (C) 1992-2009 Stewart Kay                      *
;*******************************************************************************
;
;===============================================================================
; ChangeLog (most recent entries are at top)
;===============================================================================
; v1.0.0 - 10 February 2009, S.J.Kay
; - Convert sources from TASM to NASM format and prepare for GPL release.
; - Changed all uses of 'Z80' map segment to 'es:Z80'
; - Added 'align=16' to all SEGMENT declarations. (nasm def is align=1)
;
; v1.00 - 29 April 1995 S.J.Kay
; - Last time code was worked on before releasing under the GPL.
;
; v0.00 - 1992 S.J.Kay
; - Started to code the Z80 emulator.

;===============================================================================
; z80em86 - A Z80 CPU emulator coded in Intel 86 assembly language.
; Copyright (C) 1992-2009 Stewart Kay
;
; This program is free software; you can redistribute it and/or modify
; it under the terms of the GNU General Public License as published by
; the Free Software Foundation; either version 2 of the License, or
; (at your option) any later version.
;
; This program is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
; GNU General Public License for more details.
;
; You should have received a copy of the GNU General Public License
; along with this program; if not, write to the Free Software
; Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
;===============================================================================

SEGMENT	Z80map	public align=16
Z80:

SEGMENT	.code	public align=16

GLOBAL	Z_SET0w, Z_SET1w, Z_SET2w, Z_SET3w, Z_SET4w, Z_SET5w, Z_SET6w, Z_SET7w
GLOBAL	Z_SET0v, Z_SET1v, Z_SET2v, Z_SET3v, Z_SET4v, Z_SET5v, Z_SET6v, Z_SET7v
GLOBAL	Z_SET0b, Z_SET0c, Z_SET0d, Z_SET0e, Z_SET0h, Z_SET0l, Z_SET0z, Z_SET0a
GLOBAL	Z_SET1b, Z_SET1c, Z_SET1d, Z_SET1e, Z_SET1h, Z_SET1l, Z_SET1z, Z_SET1a
GLOBAL	Z_SET2b, Z_SET2c, Z_SET2d, Z_SET2e, Z_SET2h, Z_SET2l, Z_SET2z, Z_SET2a
GLOBAL	Z_SET3b, Z_SET3c, Z_SET3d, Z_SET3e, Z_SET3h, Z_SET3l, Z_SET3z, Z_SET3a
GLOBAL	Z_SET4b, Z_SET4c, Z_SET4d, Z_SET4e, Z_SET4h, Z_SET4l, Z_SET4z, Z_SET4a
GLOBAL	Z_SET5b, Z_SET5c, Z_SET5d, Z_SET5e, Z_SET5h, Z_SET5l, Z_SET5z, Z_SET5a
GLOBAL	Z_SET6b, Z_SET6c, Z_SET6d, Z_SET6e, Z_SET6h, Z_SET6l, Z_SET6z, Z_SET6a
GLOBAL	Z_SET7b, Z_SET7c, Z_SET7d, Z_SET7e, Z_SET7h, Z_SET7l, Z_SET7z, Z_SET7a

; declared in INSTHAND.ASM
EXTERN  Z80IX, Z80IY

%include "macros.asm"

;***********************************************************
;*      SET     0,B              Flags: S Z - H - P/V N C  *
;*                                      . . x . x  .  . .  *
;***********************************************************
Z_SET0b:
        lahf
        or      ch,00000001b
        XinstB

;***********************************************************
;*      SET     1,B              Flags: S Z - H - P/V N C  *
;*                                      . . x . x  .  . .  *
;***********************************************************
Z_SET1b:
        lahf
        or      ch,00000010b
        XinstB

;***********************************************************
;*      SET     2,B              Flags: S Z - H - P/V N C  *
;*                                      . . x . x  .  . .  *
;***********************************************************
Z_SET2b:
        lahf
        or      ch,00000100b
        XinstB

;***********************************************************
;*      SET     3,B              Flags: S Z - H - P/V N C  *
;*                                      . . x . x  .  . .  *
;***********************************************************
Z_SET3b:
        lahf
        or      ch,00001000b
        XinstB

;***********************************************************
;*      SET     4,B              Flags: S Z - H - P/V N C  *
;*                                      . . x . x  .  . .  *
;***********************************************************
Z_SET4b:
        lahf
        or      ch,00010000b
        XinstB

;***********************************************************
;*      SET     5,B              Flags: S Z - H - P/V N C  *
;*                                      . . x . x  .  . .  *
;***********************************************************
Z_SET5b:
        lahf
        or      ch,00100000b
        XinstB

;***********************************************************
;*      SET     6,B              Flags: S Z - H - P/V N C  *
;*                                      . . x . x  .  . .  *
;***********************************************************
Z_SET6b:
        lahf
        or      ch,01000000b
        XinstB

;***********************************************************
;*      SET     7,B              Flags: S Z - H - P/V N C  *
;*                                      . . x . x  .  . .  *
;***********************************************************
Z_SET7b:
        lahf
        or      ch,10000000b
        XinstB

;***********************************************************
;*      SET     0,C              Flags: S Z - H - P/V N C  *
;*                                      . . x . x  .  . .  *
;***********************************************************
Z_SET0c:
        lahf
        or      cl,00000001b
        XinstB

;***********************************************************
;*      SET     1,C              Flags: S Z - H - P/V N C  *
;*                                      . . x . x  .  . .  *
;***********************************************************
Z_SET1c:
        lahf
        or      cl,00000010b
        XinstB

;***********************************************************
;*      SET     2,C              Flags: S Z - H - P/V N C  *
;*                                      . . x . x  .  . .  *
;***********************************************************
Z_SET2c:
        lahf
        or      cl,00000100b
        XinstB

;***********************************************************
;*      SET     3,C              Flags: S Z - H - P/V N C  *
;*                                      . . x . x  .  . .  *
;***********************************************************
Z_SET3c:
        lahf
        or      cl,00001000b
        XinstB

;***********************************************************
;*      SET     4,C              Flags: S Z - H - P/V N C  *
;*                                      . . x . x  .  . .  *
;***********************************************************
Z_SET4c:
        lahf
        or      cl,00010000b
        XinstB

;***********************************************************
;*      SET     5,C              Flags: S Z - H - P/V N C  *
;*                                      . . x . x  .  . .  *
;***********************************************************
Z_SET5c:
        lahf
        or      cl,00100000b
        XinstB

;***********************************************************
;*      SET     6,C              Flags: S Z - H - P/V N C  *
;*                                      . . x . x  .  . .  *
;***********************************************************
Z_SET6c:
        lahf
        or      cl,01000000b
        XinstB

;***********************************************************
;*      SET     7,C              Flags: S Z - H - P/V N C  *
;*                                      . . x . x  .  . .  *
;***********************************************************
Z_SET7c:
        lahf
        or      cl,10000000b
        XinstB

;***********************************************************
;*      SET     0,D              Flags: S Z - H - P/V N C  *
;*                                      . . x . x  .  . .  *
;***********************************************************
Z_SET0d:
        lahf
        or      dh,00000001b
        XinstB

;***********************************************************
;*      SET     1,D              Flags: S Z - H - P/V N C  *
;*                                      . . x . x  .  . .  *
;***********************************************************
Z_SET1d:
        lahf
        or      dh,00000010b
        XinstB

;***********************************************************
;*      SET     2,D              Flags: S Z - H - P/V N C  *
;*                                      . . x . x  .  . .  *
;***********************************************************
Z_SET2d:
        lahf
        or      dh,00000100b
        XinstB

;***********************************************************
;*      SET     3,D              Flags: S Z - H - P/V N C  *
;*                                      . . x . x  .  . .  *
;***********************************************************
Z_SET3d:
        lahf
        or      dh,00001000b
        XinstB

;***********************************************************
;*      SET     4,D              Flags: S Z - H - P/V N C  *
;*                                      . . x . x  .  . .  *
;***********************************************************
Z_SET4d:
        lahf
        or      dh,00010000b
        XinstB

;***********************************************************
;*      SET     5,D              Flags: S Z - H - P/V N C  *
;*                                      . . x . x  .  . .  *
;***********************************************************
Z_SET5d:
        lahf
        or      dh,00100000b
        XinstB

;***********************************************************
;*      SET     6,D              Flags: S Z - H - P/V N C  *
;*                                      . . x . x  .  . .  *
;***********************************************************
Z_SET6d:
        lahf
        or      dh,01000000b
        XinstB

;***********************************************************
;*      SET     7,D              Flags: S Z - H - P/V N C  *
;*                                      . . x . x  .  . .  *
;***********************************************************
Z_SET7d:
        lahf
        or      dh,10000000b
        XinstB

;***********************************************************
;*      SET     0,E              Flags: S Z - H - P/V N C  *
;*                                      . . x . x  .  . .  *
;***********************************************************
Z_SET0e:
        lahf
        or      dl,00000001b
        XinstB

;***********************************************************
;*      SET     1,E              Flags: S Z - H - P/V N C  *
;*                                      . . x . x  .  . .  *
;***********************************************************
Z_SET1e:
        lahf
        or      dl,00000010b
        XinstB

;***********************************************************
;*      SET     2,E              Flags: S Z - H - P/V N C  *
;*                                      . . x . x  .  . .  *
;***********************************************************
Z_SET2e:
        lahf
        or      dl,00000100b
        XinstB

;***********************************************************
;*      SET     3,E              Flags: S Z - H - P/V N C  *
;*                                      . . x . x  .  . .  *
;***********************************************************
Z_SET3e:
        lahf
        or      dl,00001000b
        XinstB

;***********************************************************
;*      SET     4,E              Flags: S Z - H - P/V N C  *
;*                                      . . x . x  .  . .  *
;***********************************************************
Z_SET4e:
        lahf
        or      dl,00010000b
        XinstB

;***********************************************************
;*      SET     5,E              Flags: S Z - H - P/V N C  *
;*                                      . . x . x  .  . .  *
;***********************************************************
Z_SET5e:
        lahf
        or      dl,00100000b
        XinstB

;***********************************************************
;*      SET     6,E              Flags: S Z - H - P/V N C  *
;*                                      . . x . x  .  . .  *
;***********************************************************
Z_SET6e:
        lahf
        or      dl,01000000b
        XinstB

;***********************************************************
;*      SET     7,E              Flags: S Z - H - P/V N C  *
;*                                      . . x . x  .  . .  *
;***********************************************************
Z_SET7e:
        lahf
        or      dl,10000000b
        XinstB

;***********************************************************
;*      SET     0,H              Flags: S Z - H - P/V N C  *
;*                                      . . x . x  .  . .  *
;***********************************************************
Z_SET0h:
        lahf
        or      bh,00000001b
        XinstB

;***********************************************************
;*      SET     1,H              Flags: S Z - H - P/V N C  *
;*                                      . . x . x  .  . .  *
;***********************************************************
Z_SET1h:
        lahf
        or      bh,00000010b
        XinstB

;***********************************************************
;*      SET     2,H              Flags: S Z - H - P/V N C  *
;*                                      . . x . x  .  . .  *
;***********************************************************
Z_SET2h:
        lahf
        or      bh,00000100b
        XinstB

;***********************************************************
;*      SET     3,H              Flags: S Z - H - P/V N C  *
;*                                      . . x . x  .  . .  *
;***********************************************************
Z_SET3h:
        lahf
        or      bh,00001000b
        XinstB

;***********************************************************
;*      SET     4,H              Flags: S Z - H - P/V N C  *
;*                                      . . x . x  .  . .  *
;***********************************************************
Z_SET4h:
        lahf
        or      bh,00010000b
        XinstB

;***********************************************************
;*      SET     5,H              Flags: S Z - H - P/V N C  *
;*                                      . . x . x  .  . .  *
;***********************************************************
Z_SET5h:
        lahf
        or      bh,00100000b
        XinstB

;***********************************************************
;*      SET     6,H              Flags: S Z - H - P/V N C  *
;*                                      . . x . x  .  . .  *
;***********************************************************
Z_SET6h:
        lahf
        or      bh,01000000b
        XinstB

;***********************************************************
;*      SET     7,H              Flags: S Z - H - P/V N C  *
;*                                      . . x . x  .  . .  *
;***********************************************************
Z_SET7h:
        lahf
        or      bh,10000000b
        XinstB

;***********************************************************
;*      SET     0,L              Flags: S Z - H - P/V N C  *
;*                                      . . x . x  .  . .  *
;***********************************************************
Z_SET0l:
        lahf
        or      bl,00000001b
        XinstB

;***********************************************************
;*      SET     1,L              Flags: S Z - H - P/V N C  *
;*                                      . . x . x  .  . .  *
;***********************************************************
Z_SET1l:
        lahf
        or      bl,00000010b
        XinstB

;***********************************************************
;*      SET     2,L              Flags: S Z - H - P/V N C  *
;*                                      . . x . x  .  . .  *
;***********************************************************
Z_SET2l:
        lahf
        or      bl,00000100b
        XinstB

;***********************************************************
;*      SET     3,L              Flags: S Z - H - P/V N C  *
;*                                      . . x . x  .  . .  *
;***********************************************************
Z_SET3l:
        lahf
        or      bl,00001000b
        XinstB

;***********************************************************
;*      SET     4,L              Flags: S Z - H - P/V N C  *
;*                                      . . x . x  .  . .  *
;***********************************************************
Z_SET4l:
        lahf
        or      bl,00010000b
        XinstB

;***********************************************************
;*      SET     5,L              Flags: S Z - H - P/V N C  *
;*                                      . . x . x  .  . .  *
;***********************************************************
Z_SET5l:
        lahf
        or      bl,00100000b
        XinstB

;***********************************************************
;*      SET     6,L              Flags: S Z - H - P/V N C  *
;*                                      . . x . x  .  . .  *
;***********************************************************
Z_SET6l:
        lahf
        or      bl,01000000b
        XinstB

;***********************************************************
;*      SET     7,L              Flags: S Z - H - P/V N C  *
;*                                      . . x . x  .  . .  *
;***********************************************************
Z_SET7l:
        lahf
        or      bl,10000000b
        XinstB

;***********************************************************
;*      SET     0,A              Flags: S Z - H - P/V N C  *
;*                                      . . x . x  .  . .  *
;***********************************************************
Z_SET0a:
        lahf
        or      al,00000001b
        XinstB

;***********************************************************
;*      SET     1,A              Flags: S Z - H - P/V N C  *
;*                                      . . x . x  .  . .  *
;***********************************************************
Z_SET1a:
        lahf
        or      al,00000010b
        XinstB

;***********************************************************
;*      SET     2,A              Flags: S Z - H - P/V N C  *
;*                                      . . x . x  .  . .  *
;***********************************************************
Z_SET2a:
        lahf
        or      al,00000100b
        XinstB

;***********************************************************
;*      SET     3,A              Flags: S Z - H - P/V N C  *
;*                                      . . x . x  .  . .  *
;***********************************************************
Z_SET3a:
        lahf
        or      al,00001000b
        XinstB

;***********************************************************
;*      SET     4,A              Flags: S Z - H - P/V N C  *
;*                                      . . x . x  .  . .  *
;***********************************************************
Z_SET4a:
        lahf
        or      al,00010000b
        XinstB

;***********************************************************
;*      SET     5,A              Flags: S Z - H - P/V N C  *
;*                                      . . x . x  .  . .  *
;***********************************************************
Z_SET5a:
        lahf
        or      al,00100000b
        XinstB

;***********************************************************
;*      SET     6,A              Flags: S Z - H - P/V N C  *
;*                                      . . x . x  .  . .  *
;***********************************************************
Z_SET6a:
        lahf
        or      al,01000000b
        XinstB

;***********************************************************
;*      SET     7,A              Flags: S Z - H - P/V N C  *
;*                                      . . x . x  .  . .  *
;***********************************************************
Z_SET7a:
        lahf
        or      al,10000000b
        XinstB

;***********************************************************
;*      SET     0,(HL)           Flags: S Z - H - P/V N C  *
;*                                      . . x . x  .  . .  *
;***********************************************************
Z_SET0z:
        lahf
        or      BYTE [es:Z80+bx],00000001b
        XinstB

;***********************************************************
;*      SET     1,(HL)           Flags: S Z - H - P/V N C  *
;*                                      . . x . x  .  . .  *
;***********************************************************
Z_SET1z:
        lahf
        or      BYTE [es:Z80+bx],00000010b
        XinstB

;***********************************************************
;*      SET     2,(HL)           Flags: S Z - H - P/V N C  *
;*                                      . . x . x  .  . .  *
;***********************************************************
Z_SET2z:
        lahf
        or      BYTE [es:Z80+bx],00000100b
        XinstB

;***********************************************************
;*      SET     3,(HL)           Flags: S Z - H - P/V N C  *
;*                                      . . x . x  .  . .  *
;***********************************************************
Z_SET3z:
        lahf
        or      BYTE [es:Z80+bx],00001000b
        XinstB

;***********************************************************
;*      SET     4,(HL)           Flags: S Z - H - P/V N C  *
;*                                      . . x . x  .  . .  *
;***********************************************************
Z_SET4z:
        lahf
        or      BYTE [es:Z80+bx],00010000b
        XinstB

;***********************************************************
;*      SET     5,(HL)           Flags: S Z - H - P/V N C  *
;*                                      . . x . x  .  . .  *
;***********************************************************
Z_SET5z:
        lahf
        or      BYTE [es:Z80+bx],00100000b
        XinstB

;***********************************************************
;*      SET     6,(HL)           Flags: S Z - H - P/V N C  *
;*                                      . . x . x  .  . .  *
;***********************************************************
Z_SET6z:
        lahf
        or      BYTE [es:Z80+bx],01000000b
        XinstB

;***********************************************************
;*      SET     7,(HL)           Flags: S Z - H - P/V N C  *
;*                                      . . x . x  .  . .  *
;***********************************************************
Z_SET7z:
        lahf
        or      BYTE [es:Z80+bx],10000000b
        XinstB

;***********************************************************
;*      SET     0,(IX+NN)        Flags: S Z - H - P/V N C  *
;*                                      . . x . x  .  . .  *
;*      SET     0,(IY+NN)        Flags: S Z - H - P/V N C  *
;*                                      . . x . x  .  . .  *
;***********************************************************
Z_SET0w:
Z_SET0v:
        lahf
        or      BYTE [es:Z80+si],00000001b
        XinstB

;***********************************************************
;*      SET     1,(IX+NN)        Flags: S Z - H - P/V N C  *
;*                                      . . x . x  .  . .  *
;*      SET     1,(IY+NN)        Flags: S Z - H - P/V N C  *
;*                                      . . x . x  .  . .  *
;***********************************************************
Z_SET1w:
Z_SET1v:
        lahf
        or      BYTE [es:Z80+si],00000010b
        XinstB

;***********************************************************
;*      SET     2,(IX+NN)        Flags: S Z - H - P/V N C  *
;*                                      . . x . x  .  . .  *
;*      SET     2,(IY+NN)        Flags: S Z - H - P/V N C  *
;*                                      . . x . x  .  . .  *
;***********************************************************
Z_SET2w:
Z_SET2v:
        lahf
        or      BYTE [es:Z80+si],00000100b
        XinstB

;***********************************************************
;*      SET     3,(IX+NN)        Flags: S Z - H - P/V N C  *
;*                                      . . x . x  .  . .  *
;*      SET     3,(IY+NN)        Flags: S Z - H - P/V N C  *
;*                                      . . x . x  .  . .  *
;***********************************************************
Z_SET3w:
Z_SET3v:
        lahf
        or      BYTE [es:Z80+si],00001000b
        XinstB

;***********************************************************
;*      SET     4,(IX+NN)        Flags: S Z - H - P/V N C  *
;*                                      . . x . x  .  . .  *
;*      SET     4,(IY+NN)        Flags: S Z - H - P/V N C  *
;*                                      . . x . x  .  . .  *
;***********************************************************
Z_SET4w:
Z_SET4v:
        lahf
        or      BYTE [es:Z80+si],00010000b
        XinstB

;***********************************************************
;*      SET     5,(IX+NN)        Flags: S Z - H - P/V N C  *
;*                                      . . x . x  .  . .  *
;*      SET     5,(IY+NN)        Flags: S Z - H - P/V N C  *
;*                                      . . x . x  .  . .  *
;***********************************************************
Z_SET5w:
Z_SET5v:
        lahf
        or      BYTE [es:Z80+si],00100000b
        XinstB

;***********************************************************
;*      SET     6,(IX+NN)        Flags: S Z - H - P/V N C  *
;*                                      . . x . x  .  . .  *
;*      SET     6,(IY+NN)        Flags: S Z - H - P/V N C  *
;*                                      . . x . x  .  . .  *
;***********************************************************
Z_SET6w:
Z_SET6v:
        lahf
        or      BYTE [es:Z80+si],01000000b
        XinstB

;***********************************************************
;*      SET     7,(IX+NN)        Flags: S Z - H - P/V N C  *
;*                                      . . x . x  .  . .  *
;*      SET     7,(IY+NN)        Flags: S Z - H - P/V N C  *
;*                                      . . x . x  .  . .  *
;***********************************************************
Z_SET7w:
Z_SET7v:
        lahf
        or      BYTE [es:Z80+si],10000000b
        XinstB

        end
