;File:	MODEMK.ASM
;Edit date:	85/11/05.
;Serial number 2.
;
;	MODEM - Send or receive file via serial modem port,
;		for the KAYPRO II.
;
;	RP/M call:
;
;		MODEM x d:filename
;
;	where	x = S  to send the file, or
;		  = R  to receive the file
;		d = disk drive
;
;	or, for terminal-to-terminal communications:
;
;		MODEMK x
;
;	where	x = T  for system emulating DTE
;		  = C  for system emulating DCE
;
;	One system must be DTE, the other DCE.
;
;	Assembly constants.
;
RDOS	EQU	0005H	;RDOS entry vector
RFCB	EQU	005CH	;resident fcb
RBUF	EQU	0080H	;resident sector buffer
RTPA	EQU	0100H	;user program origin
;
;	Ascii character codes.
;
cr	EQU	0DH	;carriage return
lf	EQU	0AH	;line feed
ack	EQU	06H	;acknowledge
nak	EQU	15H	;negative ack
soh	EQU	01H	;start of header
eot	EQU	04H	;end of transmission
cntlc	EQU	03H	;control-c
cntle	EQU	05H	;control-e
;
;	Assembly options.
;
FALSE	EQU	0
TRUE	EQU	NOT FALSE
U8251	EQU	FALSE
TEI	EQU	FALSE
KAYPRO	EQU	TRUE
Z80SIO	EQU	TRUE
;
;	TEI 3P+3S serial card USART port assignments.
;	This board has jumper selected data rate.
;
	IF	TEI
DATAA	EQU	02H	;serial data port
STATA	EQU	03H	;serial command/status port
MASKDA	EQU	02H	;data-available mask
	ENDIF
;
;	Kaypro port assignments.
;
	IF	KAYPRO
BAUDA	EQU	00H	;serial A data rate
DATAA	EQU	04H	;serial A data port
STATA	EQU	06H	;serial A command/status port
MASKDA	EQU	01H	;data-available mask
	ENDIF
;
;	RDOS functions.
;
FCCI	EQU	 1	;console char in
FCCO	EQU	 2	;console char out
FCBO	EQU	 9	;console buffer out
FCBI	EQU	10	;console buffer in
FCST	EQU	11	;console status
FSEL	EQU	14	;select disk
FOPN	EQU	15	;open file
FCLO	EQU	16	;close file
FDEL	EQU	19	;delete file
FRSR	EQU	20	;read sequential record
FWSR	EQU	21	;write sequential record
FCNF	EQU	22	;create new file
FDMA	EQU	26	;set dma
;
;	Assembly constants.
;
RECSIZ	EQU	128	;record size
MAXERR	EQU	10	;retry count
;
	ORG	RTPA
;
	LXI	H,0
	DAD	SP
	SHLD	OLDSP
	LXI	SP,STACK
	JMP	PRS
;
;	Data space.
;
RECNR:	DW	0	;next record
RRCNR:	DW	0	;current record
ERRCT:	DB	0	;error count
DBUF:	DS	1+8+3+1	;filename display buffer
	DS	2*24
STACK	EQU	$
OLDSP:	DW	0	;save stack pointer
;
;	HLA - Set HL = HL + A.
;
HLA:	ADD L ! MOV L,A ! RNC
	INR H ! RET
;
;	OPN - Open file.
;	Entry	DE = fcb fwa
;	Exit	 Z = true, if file not found
;
OPN:	MVI	C,FOPN
OPN1:	CALL	RDOS
	INR	A
	RET
;
;	RSR - Read sequential record.
;	Entry	DE = fcb fwa
;	Exit	 Z = true, if not eoi
;
RSR:	MVI	C,FRSR
RSR1:	CALL	RDOS
	ORA	A
	RET
;
;	DEL - Delete file.
;	Entry	DE = fcb fwa
;	Exit	 Z = true if file not found
;
DEL:	MVI	C,FDEL
DEL1:	CALL	RDOS
	INR	A
	RET
;
;	CNF - Create new file.
;	Entry	DE = fcb fwa
;	Exit	 Z = true if directory full
;
CNF:	MVI	C,FCNF
	JMP	DEL1
;
;	WSR - Write sequential record.
;	Entry	DE = fcb fwa
;	Exit	 Z = true if disk not full
;
WSR:	MVI	C,FWSR
WSR1:	CALL	RDOS
	ORA	A
	RET
;
;	CLO - Close file.
;	Entry	DE = fcb fwa
;	Exit	 Z = true if file not found
;
CLO:	MVI	C,FCLO
	JMP	DEL1
;
EOLA:	DB	cr,lf,'$'
;
;	EOL - Issue cr,lf to console.
;
EOL:	LXI	D,EOLA
;
;
;	MSG - Console message out.
;	Entry	DE = message fwa
;	Message ends in $
;
MSG:	MVI	C,FCBO
	CALL	RDOS
	RET
;
;	CCO - Console character out.
;	Entry	 A = char
;
CCO:	MOV	E,A
	MVI	C,FCCO
	CALL	RDOS
	RET
;
;	CCI - Console character input.
;	Exit	 A = char
;
CCI:	MVI	C,FCCI
	CALL	RDOS
	RET
;
;	BRK - Console break.
;	Exit	 Z = true if no break
;
BRK:	MVI	C,FCST	;get console statue
	CALL	RDOS
	ORA	A
	RZ		;If no key pressed
;
	MVI	C,FCCI	;get the char
	CALL	RDOS
	ORA	A
	RET
;
;	DRN - Display record number.
;
DRN:	MVI	A,cr
	CALL	DCH
	LHLD	RECNR
;
;	DHW - Display hex word.
;	Entry	HL = word to be displayed
;
DHW:	PUSH	H
	MOV	A,H	;display high byte
	CALL	DHB
	POP	H
	MOV	A,L
;
;	DHB - Display hex byte.
;	Display two hex digits.
;	Entry	 A = byte to be displayed
;
DHB:	PUSH	PSW
	RRC ! RRC ! RRC ! RRC
	CALL	DHD	;display hex digit
	POP	PSW
;
;	DHD - Display hex digit.
;	Entry	 A, low 4 bits = digit
;
DHD:	ANI	0FH
	CPI	10
	JNC	DHD1	;If not 0 through 9
;
	ADI	'0'
	JMP	DCH
;
DHD1:	ADI	'A'-10	;create "A, B, C, D, E, or F"
;
;	DCH - Display one character.
;	Entry	 A = ASCII encoded char
;
DCH:	MOV	E,A
	MVI	C,FCCO
	CALL	RDOS
	RET
;
;	DFN - Display filename.
;
DFN:	LXI	H,RFCB+1
	LXI	D,DBUF
	MVI	C,8
DFN1:	MOV	A,M
	CPI	' '
	JZ	DFN2	;If end of filename
;
	STAX	D
	INX	D
	INX	H
	DCR	C
	JNZ	DFN1	;loop over filename
;
DFN2:	MVI	A,'.'
	STAX	D
	INX	D
	LXI	H,RFCB+1+8
	MVI	C,3
DFN3:	MOV	A,M
	CPI	' '
	JZ	DFN4	;If end of filetype
;
	STAX	D
	INX	D
	INX	H
	DCR	C
	JNZ	DFN3	;loop over filetype
;
DFN4:	MVI	A,'$'
	STAX	D
	LXI	D,DBUF
	CALL	MSG
	RET
;
;	MMC - Move memory.
;	Entry	HL = source fwa
;		DE = destination fwa
;		 C = byte count
;
MMC:	MOV	A,M
	STAX	D
	INX	H
	INX	D
	DCR	C
	JNZ	MMC	;loop for C bytes
	RET
;
;	PPL - Process parameter list.
;
PPL:	POP	H	;HL=parameters fwa
	MOV	B,M	;byte count
PPL1:	INX	H
	MOV	A,M
	OUT	STATA
	DCR	B
	JNZ	PPL1	;loop over param list
;
	INX	H	;set return address
	PCHL		;return
;
;	PSD - Preset serial device.
;
PSD:	CALL	PPL	;process following list
	DB	PSDA-$-1
	IF	U8251
;
;	Preset 8251 USART.
;
	DB	0B7H,077H	;reset 8251
	DB	07AH		;1 stop bit, pe, 7 data bits, x16
	DB	007H		;enable recvr & xmitter, assert CTS
PSDA	EQU	$
	ENDIF
;
	IF	Z80SIO
	DB	18H	;clear error flags
	DB	4,45H	;x16,1 stop bit,parity
	DB	1,80H	;disable interrupts
	DB	3,0C1H	;async, 8 data bits, rcvr enable
	DB	5,0E8H	;dtr, 8 data bits, xmit enable
	DB	0C0H	;clear TxUnderrun
PSDA	EQU	$
	ENDIF
	RET
;
;	PMC - Put modem character.
;	Entry	 A = character
;		 C = checksum
;	Exit	 C = advanced checksum
;
PMC:	PUSH	PSW	;save char
	ADD	C
	MOV	C,A
;
;	Wait for UART transmitter ready.
;
PMC1:	IN	STATA
	IF	TEI
	ANI	01H
	JZ	PMC1	;If not TBE
	ENDIF
;
	IF	KAYPRO
	ANI	04H
	CPI	04H
	JNZ	PMC1	;If not TBE
	ENDIF
;
;	Send the character.
;
	POP	PSW
	OUT	DATAA
	RET
;
;	GMC - Get modem character.
;	Entry	 B = timeout value in seconds
;		 C = checksum
;	Exit	 A = character
;		 carry = 0, if data received
;		       = 1, if timed out
;		 C = advanced checksum
;
GMC:	PUSH	D
GMC1:	LXI	D,48000	;1 second count
GMCA	EQU	$-2
GMC2:	IN	STATA
	ANI	MASKDA
	JNZ	GMC3	;If UART has data
;
;	Advance the one-second countdown.
;
	DCR E ! JNZ GMC2	;loop for 1 sec
	DCR D ! JNZ GMC2	;loop for 1 sec
;
;	Advance time-out wait.
;
	DCR	B
	JNZ	GMC1	;If timeout not expired
;
;	We have timed out without receiving data.
;
	POP	D
	STC		;indicate timed out
	RET
;
;	Get the data byte from the UART.
;
GMC3:	IN	DATAA
	MOV	E,A
	ADD	C	;advance checksum
	MOV	C,A
	MOV	A,E
	POP	D
	ORA	A	;indicate data received
	RET
;
;	ATO - Display acknowledge timeout error.
;
ATO:	LXI	D,ATOA	;"ack time-out"
	CALL	MSG
	LDA	ERRCT	;display the error count
	CALL	DHB
	CALL	EOL	;cr,lf
	RET
;
ATOA:	DB	cr,lf,'ACK or SOH time out error count: $'
;
;	CFQ - Check console for quit or continue.
;	Exit	 Z = true, if retry
;
CFQ:	XRA	A	;reset error counter
	STA	ERRCT
	LXI	D,CFQA	;"quit or retry?"
	CALL	MSG
	CALL	CCI	;get console response
	ANI	5FH
	CPI	'R'
	RZ		;If retry
;
	CPI	'Q'
	JNZ	CFQ	;If neither, ask again
;
	ORA	A	;indicate quit
	RET
;
CFQA:	DB	cr,lf,'Quit or retry? (Q/R): $'
;
;	XPF - Export file.
;
XPF:	LXI	D,RFCB	;open the file
	CALL	OPN
	JZ	XPF6	;If file not found
;
	LXI	D,XPFA	;"file opened"
	CALL	MSG
XPF1:	XRA	A	;reset the error counter
	STA	ERRCT
;
;	Read and transmit next sector.
;
	LXI	D,RFCB
	CALL	RSR
	JNZ	XPF7	;If end of information
;
;	Advance the transmit record number.
;
	LHLD	RECNR
	INX	H
	SHLD	RECNR
;
;	Transmit or retransmit the record.
;
XPF2:	LXI	D,XPFB	;"transmitting record x"
	CALL	MSG
	LHLD	RECNR
	CALL	DHW
;
;	Transmit the record preamble.
;
	MVI	A,soh	;send  SOH, rn, -rn
	CALL	PMC
	LDA	RECNR
	CALL	PMC
	LDA	RECNR
	CMA
	CALL	PMC
;
;	Transmit the record data.
;
	MVI	C,0	;reset checksum
	MVI	B,RECSIZ
	LXI	H,RBUF
XPF3:	MOV	A,M	;send next character
	CALL	PMC
	INX	H
	DCR	B
	JNZ	XPF3	;loop over record size
;
;	Send the checksum.
;
	MOV	A,C
	CALL	PMC
;
;	Wait for acknowledge.
;
	MVI	B,4	;allow 4 seconds
	CALL	GMC
	JNC	XPF5	;If ack received
;
;	We have timed out waiting for acknowledge.
;
	CALL	ATO	;display error count
XPF4:	LDA	ERRCT	;advance error count
	INR	A
	STA	ERRCT
	CPI	MAXERR
	JC	XPF2	;If retry
;
;	Retry count is exhausted, check console.
;
	LXI	D,XPFC	;"no ack being rec'd"
	CALL	MSG
	CALL	CFQ	;check console
	JZ	XPF2	;If retry
;
;	Exit the operating system.
;
	LXI	D,XPFD	;"returning to RP/M"
	JMP	ERX
;
;	Process acknowledge received.
;
XPF5:	CPI	ack
	JZ	XPF1	;If positive acknowledge
;
;	Process negative acknowledge.
;
	PUSH	PSW
	LXI	D,XPFE	;"nak char:"
	CALL	MSG
	POP	PSW
	CALL	DHB
	JMP	XPF4
;
;	Process disk file not found.
;
XPF6:	LXI	D,XPFE	;"file not found"
	JMP	ERX
;
;	Process end of information on disk file.
;
XPF7:	XRA	A	;reset error counter
	STA	ERRCT
	LXI	D,XPFF	;"file transmitted"
	CALL	MSG
;
;	Send end-of-transmission.
;
XPF8:	MVI	A,eot
	CALL	PMC
	MVI	B,5	;allow 5 seconds
	CALL	GMC
	JC	XPF10	;If EOT ack timed out
;
	CPI	ack
	JZ	XPF11	;If EOT positive acknowledged
;
;	We have negative ack on our EOT.
;
	PUSH	PSW
	LXI	D,XPFG	;"eot not acknowledged:"
	CALL	MSG
	POP	PSW
	CALL	DHB
;
;	Check retry.
;
XPF9:	LDA	ERRCT
	INR	A
	STA	ERRCT
	CPI	MAXERR
	JC	XPF8	;If retry on EOT
;
;	Our EOT is not being acknowledged.
;
	LXI	D,XPFH	;"neg ack on EOT"
	JMP	ERX
;
;	Process EOT time-out.
;
XPF10:	CALL	ATO	;display error count
	JMP	XPF9
;
;	Process file transmit completed.
;
XPF11:	LXI	D,XPFI	;"EOT acknowledged"
	JMP	ERX
;
XPFA:	DB	cr,lf,'File opened.$'
XPFB:	DB	cr,'Transmitting record number $'
XPFC:	DB	cr,lf,'We are not receiving an acknowledge.$'
XPFD:	DB	cr,lf,'Returning to RP/M.$'
XPFE:	DB	cr,lf,'File not found.$'
XPFF:	DB	cr,lf,'File transmitted.$'
XPFG:	DB	cr,lf,'EOT not acknowledged: $'
XPFH:	DB	cr,lf,'We are not receiving EOT acknowledge.$'
XPFI:	DB	cr,lf,'EOT acknowledged.$'
;
;	ERX - Process exit to system.
;	Entry	DE = message fwa
;
;	Exits to RP/M.
;
ERX:	CALL	MSG
	LXI	D,RFCB	;close file
	CALL	CLO
ERX1:	LHLD	OLDSP	;return to RCP
	SPHL
	RET
;
;	IMF - Import file.
;
IMF:	LXI	D,RFCB	;delete any existing file
	CALL	DEL
	LXI	D,RFCB	;create new file
	CALL	CNF
;
IMF1:	XRA	A	;reset error counter
	STA	ERRCT
;
IMF2:	LXI	D,IMFA	;"waiting for record xxxx"
	CALL	MSG
	LHLD	RECNR
	INX	H
	CALL	DHW
;
	MVI	B,5	;allow 5 seconds
	CALL	GMC	;get modem char
	JNC	IMF5	;If char received
;
;	Process timed out.
;
IMF3:	CALL	ATO	;display error count
;
;	Discard remainder of any record being received.
;
IMF4:	MVI	B,1	;allow 1 second
	CALL	GMC
	JNC	IMF4	;loop to end of record
;
;	Send negative acknowledge.
;
	MVI	A,nak
	CALL	PMC
	LDA	ERRCT
	INR	A
	STA	ERRCT
	CPI	MAXERR
	JC	IMF2	;If retry
;
;	Retry count is exhausted.
;
	CALL	CFQ	;check console
	JZ	IMF2	;If retry
;
	LXI	D,IMFB	;"no valid preamble rec'd"
	JMP	ERX
;
;	Process received character.
;
IMF5:	CPI	soh
	JZ	IMF6	;If start of header
;
	CPI	00
	JZ	IMF2	;If 00 for speed check
;
	CPI	eot
	JZ	IMF12	;If end of transmission
;
	PUSH	PSW
	LXI	D,IMFC	;"no SOH rec'd"
	CALL	MSG
	POP	PSW
	CALL	DHB
	JMP	IMF4
;
;	Process start of header.
;
IMF6:	MVI	B,1	;get record number
	CALL	GMC
	JC	IMF3	;If timed out
;
	MOV	D,A	;save the record number
	MVI	B,1	;get complemented record number
	CALL	GMC
	JC	IMF3	;If timed out
;
	CMA
	CMP	D
	JZ	IMF7	;If valid record number rec'd
;
;	Process invalid record number.
;
	MOV	E,A
	PUSH	D
	LXI	D,IMFD	;"invalid record number"
	CALL	MSG
	POP	H
	CALL	DHW
	JMP	IMF4
;
;	Process record.
;
IMF7:	MOV	A,D	;record number being rec'd
	STA	RRCNR
	MVI	C,0	;reset checksum
	MVI	E,RECSIZ
	LXI	H,RBUF
;
IMF8:	MVI	B,1	;get next modem char
	CALL	GMC
	JC	IMF3	;If timed out
;
	MOV	M,A	;store data
	INX	H
	DCR	E
	JNZ	IMF8	;loop to end of record
;
;	Verify checksum.
;
	MOV	D,C
	MVI	B,1	;get checksum
	CALL	GMC
	JC	IMF3	;If timed out
;
	CMP	D
	JNZ	IMF11	;If checksums mismatch
;
;	We have a good record.
;
	LDA	RRCNR	;number of record rec'd
	MOV	B,A
	LDA	RECNR	;number of record expected
	INR	A
	CMP	B
	JNZ	IMF9	;If not next sequential record
;
;	Write record to disk.
;
	LXI	D,RFCB
	CALL	WSR
	JNZ	IMF10	;If disk is full
;
	LDA	RRCNR	;set next rec=rec rec'd
	STA	RECNR
;
;	Positive acknowledge the received record.
;
IMF9:	MVI	A,ack
	CALL	PMC
	JMP	IMF1
;
;	Process full disk error.

;
IMF10:	LXI	D,IMFE	;"disk is full"
	JMP	ERX
;
;	Process record checksum error.
;
IMF11:	LXI	D,IMFF	;"checksum error"
	CALL	MSG
	JMP	IMF4
;
;	Process end of transmission.
;
IMF12:	MVI	A,ack	;positive ack the EOT
	CALL	PMC
;
IMF13:	LXI	D,RFCB	;close the file
	CALL	CLO
	JZ	IMF14	;If close error
;
	LXI	D,IMFG	;"file rec'd"
	JMP	ERX
;
;	Process file close error.
;
IMF14:	LXI	D,IMFH	;"file close error"
	JMP	ERX
;
IMFA:	DB	cr,'Waiting for record $'
IMFB:	DB	cr,'Invalid preamble received: $'
IMFC:	DB	cr,'SOH not received: $'
IMFD:	DB	cr,'Record number error: $'
IMFE:	DB	cr,lf,'Disk is full.$'
IMFF:	DB	cr,lf,'Received record has checksum error. $'
IMFG:	DB	cr,lf,'File received.$'
IMFH:	DB	cr,lf,'Unable to close the file.$'
;
;	DTE - Simulate data terminal equipment.
;
;	Process terminal-to-terminal communication.
;	One system must be brought up as DCE and
;	the other system must be brought up as DTE.
;
DTE:	MVI	C,FCST	;check console keyboard
	CALL	RDOS
	ORA	A
	JZ	DTE1	;If no keyboard data available
;
;	Get the keyboard character.
;
	CALL	CCI	;read console keyboard
	CPI	cntle
	JZ	ERX1	;If control-e, exit to RP/M
;
;	Send the character to the DCE.
;
	CALL	PMC

;
;	Check for incoming data from the DCE.
;
DTE1:	MVI	B,1	;get modem char
	CALL	GMC
	JC	DTE	;If no data available
;
	CALL	CCO	;display the char
	JMP	DTE
;
;	DCE - Simulate data communications equipment.
;
;	Process terminal-to-terminal communication.
;	One system must be brought up as DTE and the
;	other system must be brought up as DCE.
;
DCE:	MVI	B,1	;get modem char
	CALL	GMC
	JNC	DCE1	;If char received
;
;	We have no incoming data.
;
	MVI	C,FCST	;check console keyboard
	CALL	RDOS
	ORA	A
	JZ	DCE	;If no keyboard data
;
;	Read keyboard character.
;
	CALL	CCI	;read console keyboard
	CPI	cntle
	JZ	ERX1	;If control-e, exit to RP/M
;
	CALL	PMC	;send char to DTE
	JMP	DCE
;
;	Process character received from DTE.
;
DCE1:	CALL	CCO	;display char
	JMP	DCE
;
;	PRS - Preset program.
;
PRS:	CALL	PSD	;preset the USART
	IF	KAYPRO
	MVI	A,07	;set 1200 bps
	OUT	BAUDA
	ENDIF
;
	LXI	D,RBUF	;set dma
	MVI	C,FDMA
	CALL	RDOS
	MVI	A,0	;reset fcb cr
	STA	RFCB+32
;
;	Clear the communication line.
;
	MVI	B,1
	CALL	GMC
	MVI	B,1
	CALL	GMC
;
;	Select send or receive file.
;
	LDA	RFCB+1
	PUSH	PSW
	LXI	D,RFCB	;move the filename
	LXI	H,RFCB+16
	MVI	C,1+8+3
	CALL	MMC
	POP	PSW	;select processor
	CPI	'S'
	JZ	XPF	;If export file
;
	CPI	'R'
	JZ	IMF	;If import file
;
;	Disable the one-second timer in GMC.
;
	LXI	H,0101H
	SHLD	GMCA
;
	CPI	'T'
	JZ	DTE	;If DTE emulation
;
	CPI	'C'
	JZ	DCE	;If DCE emulation
;
	LXI	D,PRSA	;"syntax error"
	JMP	ERX
;
PRSA:	DB	cr,lf,'Syntax is MODEM <S,R,C,T> filename$'
