;============================================================================
;
;File:	Z80EM6.ASM - Z80 Emulator
;Date:  February 25, 1987
;
;============================================================================
;
;						      Location
;   Register Usage:	AX = Z80 A-PSW	(AH=F, AL=A)	FF7CH
;			BX = Z80 H-L	(BH=H, BL=L)	FF76H
;			DI = Z80 B-C			FF7AH
;			DX = Z80 D-E	(DH=D, DL=E)	FF78H
;			BP = Z80 SP			
;			SI = Z80 P	(Program Cntr)
;		      	     Z80 IX			FF70H
;			     Z80 IY			FF72H
;
;========================================================================
;
	ORG	(000H*PG)+EDOP
INBI	PROC	NEAR		;ED 00 (HD64180 only)	IN B,D8 
;				-----------------------------------------
	PUSH	DX		;save DE(DX) on stack
	PUSH	AX		;save PSW(AX) on stack
	LODSB			;Get immediate byte D8 low port byte in A
	MOV	DL,AL		;low port byte into DL
	MOV	DH,BYTE PTR R	;Get high port byte from Refresh register
	IN	AL,DX		;Input byte in AL from port in DX
	MOV	DX,DI		;Put BC(DI) in DX(DE)
	MOV	DH,AL		;Get byte input to D(DH)
	MOV	DI,DX		;result in BC(DI)
	POP	AX		;restore PSW(AX)
	POP	DX		;restore DE(DX)
	LAHF			;load AH from flags
	AND	AH,0EDH		;clear alt carry and subtract flags
	XOR	CL,CL
	NXTI
INBI	ENDP
;
	ORG	(001H*PG)+EDOP
OUTIB	PROC	NEAR		;ED 01 (HD64180 only)	OUTO D8,B 
;				-----------------------------------------
	PUSH	DX		;save DE(DX) on stack
	PUSH	AX		;save PSW(AX) on stack
	LODSB			;Get immediate byte D8 low port byte in A
	MOV	DL,AL		;low port byte into DL
	MOV	DH,BYTE PTR R	;Get high port byte from Refresh register
	MOV	DX,DI		;Put BC(DI) in DX(DE)
	MOV	AL,DH		;Output byte from B(DH) via AL
	OUT	DX,AL		;Output byte from AL to port in DX
	POP	AX		;restore PSW(AX)
	POP	DX		;restore DE(DX)
	XOR	CL,CL
	NXTI
OUTIB	ENDP
;
	ORG	(004H*PG)+EDOP
HTSTB	PROC	NEAR		;ED 04 (HD64180 only)	TST B
;				-----------------------------------------
	XCHG	CX,DI		;get BC(DI) in CX
	TEST	AL,CH		;nondestructive AND A(AL) with B(CH)
	XCHG	CX,DI		;restore BC(DI) from CX
	LAHF			;load AH from flags
	AND	AH,0FCH		;clear subtract and carry flags
	OR	AH,010H		;set aux carry flag
	XOR	CL,CL
	NXTI
HTSTB	ENDP
;
	ORG	(008H*PG)+EDOP
INCI	PROC	NEAR		;ED 08 (HD64180 only)	IN C,D8 
;				-----------------------------------------
	PUSH	DX		;save DE(DX) on stack
	PUSH	AX		;save PSW(AX) on stack
	LODSB			;Get immediate byte D8 low port byte in A
	MOV	DL,AL		;low port byte into DL
	MOV	DH,BYTE PTR R	;Get high port byte from Refresh register
	IN	AL,DX		;Input byte in AL from port in DX
	MOV	DX,DI		;Put BC(DI) in DX(DE)
	MOV	DL,AL		;Get byte input to E(DL)
	MOV	DI,DX		;result in BC(DI)
	POP	AX		;restore PSW(AX)
	POP	DX		;restore DE(DX)
	LAHF			;load AH from flags
	AND	AH,0EDH		;clear alt carry and subtract flags
	XOR	CL,CL
	NXTI
INCI	ENDP
;
	ORG	(009H*PG)+EDOP
OUTIC	PROC	NEAR		;ED 09 (HD64180 only)	OUTO D8,C 
;				-----------------------------------------
	PUSH	DX		;save DE(DX) on stack
	PUSH	AX		;save PSW(AX) on stack
	LODSB			;Get immediate byte D8 low port byte in A
	MOV	DL,AL		;low port byte into DL
	MOV	DH,BYTE PTR R	;Get high port byte from Refresh register
	MOV	DX,DI		;Put BC(DI) in DX(DE)
	MOV	AL,DL		;Output byte from C(DL) via AL
	OUT	DX,AL		;Output byte from AL to port in DX
	POP	AX		;restore PSW(AX)
	POP	DX		;restore DE(DX)
	XOR	CL,CL
	NXTI
OUTIC	ENDP
;
	ORG	(00CH*PG)+EDOP
HTSTC	PROC	NEAR		;ED 0C (HD64180 only)	TST C
;				-----------------------------------------
	XCHG	CX,DI		;get BC(DI) in CX
	TEST	AL,CL		;nondestructive AND A(AL) with C(CL)
	XCHG	CX,DI		;restore BC(DI) from CX
	LAHF			;load AH from flags
	AND	AH,0FCH		;clear subtract and carry flags
	OR	AH,010H		;set aux carry flag
	XOR	CL,CL
	NXTI
HTSTC	ENDP
;
	ORG	(010H*PG)+EDOP
INDI	PROC	NEAR		;ED 10 (HD64180 only)	IN D,D8 
;				-----------------------------------------
	PUSH	AX		;save PSW(AX) on stack
	PUSH	DX		;save DE(DX) on stack
	LODSB			;Get immediate byte D8 low port byte in A
	MOV	DL,AL		;low port byte into DL
	MOV	DH,BYTE PTR R	;Get high port byte from Refresh register
	IN	AL,DX		;Input byte in AL from port in DX
	POP	DX		;restore DE(DX) from stack
	MOV	DH,AL		;Get byte input to D(DH)
	POP	AX		;restore PSW(AX)
	LAHF			;load AH from flags
	AND	AH,0EDH		;clear alt carry and subtract flags
	XOR	CL,CL
	NXTI
INDI	ENDP
;
	ORG	(011H*PG)+EDOP
OUTID	PROC	NEAR		;ED 11 (HD64180 only)	OUTO D8,D 
;				-----------------------------------------
	PUSH	DX		;save DE(DX) on stack
	PUSH	AX		;save PSW(AX) on stack
	XCHG	DX,CX		;put DE(DX) in CX
	LODSB			;Get immediate byte D8 low port byte in A
	MOV	DL,AL		;low port byte into DL
	MOV	DH,BYTE PTR R	;Get high port byte from Refresh register
	MOV	AL,CH		;Output byte from D(CH) via AL
	OUT	DX,AL		;Output byte from AL to port in DX
	POP	AX		;restore PSW(AX)
	POP	DX		;restore DE(DX)
	XOR	CL,CL
	NXTI
OUTID	ENDP
;
	ORG	(014H*PG)+EDOP
HTSTD	PROC	NEAR		;ED 14 (HD64180 only)	TST D
;				-----------------------------------------
	TEST	AL,DH		;nondestructive AND A(AL) with D(DH)
	LAHF			;load AH from flags
	AND	AH,0FCH		;clear subtract and carry flags
	OR	AH,010H		;set aux carry flag
	XOR	CL,CL
	NXTI
HTSTD	ENDP
;
	ORG	(018H*PG)+EDOP
INEI	PROC	NEAR		;ED 18 (HD64180 only)	IN E,D8 
;				-----------------------------------------
	PUSH	AX		;save PSW(AX) on stack
	PUSH	DX		;save DE(DX) on stack
	LODSB			;Get immediate byte D8 low port byte in A
	MOV	DL,AL		;low port byte into DL
	MOV	DH,BYTE PTR R	;Get high port byte from Refresh register
	IN	AL,DX		;Input byte in AL from port in DX
	POP	DX		;restore DE(DX) from stack
	MOV	DL,AL		;Get byte input to E(DL)
	POP	AX		;restore PSW(AX)
	LAHF			;load AH from flags
	AND	AH,0EDH		;clear alt carry and subtract flags
	XOR	CL,CL
	NXTI
INEI	ENDP
;
	ORG	(019H*PG)+EDOP
OUTIE	PROC	NEAR		;ED 19 (HD64180 only)	OUTO D8,E 
;				-----------------------------------------
	PUSH	DX		;save DE(DX) on stack
	PUSH	AX		;save PSW(AX) on stack
	XCHG	DX,CX		;put DE(DX) in CX
	LODSB			;Get immediate byte D8 low port byte in A
	MOV	DL,AL		;low port byte into DL
	MOV	DH,BYTE PTR R	;Get high port byte from Refresh register
	MOV	AL,CL		;Output byte from E(CL) via AL
	OUT	DX,AL		;Output byte from AL to port in DX
	POP	AX		;restore PSW(AX)
	POP	DX		;restore DE(DX)
	XOR	CL,CL
	NXTI
OUTIE	ENDP
;
	ORG	(01CH*PG)+EDOP
HTSTE	PROC	NEAR		;ED 1C (HD64180 only)	TST E
;				-----------------------------------------
	TEST	AL,DL		;nondestructive AND A(AL) with E(DL)
	LAHF			;load AH from flags
	AND	AH,0FCH		;clear subtract and carry flags
	OR	AH,010H		;set aux carry flag
	XOR	CL,CL
	NXTI
HTSTE	ENDP
;
	ORG	(020H*PG)+EDOP
INHI	PROC	NEAR		;ED 20 (HD64180 only)	IN H,D8 
;				-----------------------------------------
	PUSH	AX		;save PSW(AX) on stack
	PUSH	BX		;save HL(BX) on stack
	PUSH	DX		;save DE(DX) on stack
	LODSB			;Get immediate byte D8 low port byte in A
	MOV	DL,AL		;low port byte into DL
	MOV	DH,BYTE PTR R	;Get high port byte from Refresh register
	IN	AL,DX		;Input byte in AL from port in DX
	POP	DX		;restore DE(DX) from stack
	POP	BX		;restore HL(BX) from stack
	MOV	BH,AL		;Get byte input to H(BH)
	POP	AX		;restore PSW(AX)
	LAHF			;load AH from flags
	AND	AH,0EDH		;clear alt carry and subtract flags
	XOR	CL,CL
	NXTI
INHI	ENDP
;
	ORG	(021H*PG)+EDOP
OUTIH	PROC	NEAR		;ED 21 (HD64180 only)	OUTO D8,H 
;				-----------------------------------------
	PUSH	DX		;save DE(DX) on stack
	PUSH	AX		;save PSW(AX) on stack
	XCHG	DX,CX		;put DE(DX) in CX
	LODSB			;Get immediate byte D8 low port byte in A
	MOV	DL,AL		;low port byte into DL
	MOV	DH,BYTE PTR R	;Get high port byte from Refresh register
	MOV	AL,BH		;Output byte from H(BH) via AL
	OUT	DX,AL		;Output byte from AL to port in DX
	POP	AX		;restore PSW(AX)
	POP	DX		;restore DE(DX)
	XOR	CL,CL
	NXTI
OUTIH	ENDP
;
	ORG	(024H*PG)+EDOP
HTSTH	PROC	NEAR		;ED 24 (HD64180 only)	TST H
;				-----------------------------------------
	TEST	AL,BH		;nondestructive AND A(AL) with H(BH)
	LAHF			;load AH from flags
	AND	AH,0FCH		;clear subtract and carry flags
	OR	AH,010H		;set aux carry flag
	XOR	CL,CL
	NXTI
HTSTH	ENDP
;
	ORG	(028H*PG)+EDOP
INLI	PROC	NEAR		;ED 28 (HD64180 only)	IN L,D8 
;				-----------------------------------------
	PUSH	AX		;save PSW(AX) on stack
	PUSH	BX		;save HL(BX) on stack
	PUSH	DX		;save DE(DX) on stack
	LODSB			;Get immediate byte D8 low port byte in A
	MOV	DL,AL		;low port byte into DL
	MOV	DH,BYTE PTR R	;Get high port byte from Refresh register
	IN	AL,DX		;Input byte in AL from port in DX
	POP	DX		;restore DE(DX) from stack
	POP	BX		;restore HL(BX) from stack
	MOV	BL,AL		;Get byte input to L(BL)
	POP	AX		;restore PSW(AX)
	LAHF			;load AH from flags
	AND	AH,0EDH		;clear alt carry and subtract flags
	XOR	CL,CL
	NXTI
INLI	ENDP
;
	ORG	(029H*PG)+EDOP
OUTIL	PROC	NEAR		;ED 29 (HD64180 only)	OUTO D8,L 
;				-----------------------------------------
	PUSH	DX		;save DE(DX) on stack
	PUSH	AX		;save PSW(AX) on stack
	XCHG	DX,CX		;put DE(DX) in CX
	LODSB			;Get immediate byte D8 low port byte in A
	MOV	DL,AL		;low port byte into DL
	MOV	DH,BYTE PTR R	;Get high port byte from Refresh register
	MOV	AL,BL		;Output byte from L(BL) via AL
	OUT	DX,AL		;Output byte from AL to port in DX
	POP	AX		;restore PSW(AX)
	POP	DX		;restore DE(DX)
	XOR	CL,CL
	NXTI
OUTIL	ENDP
;
	ORG	(02CH*PG)+EDOP
HTSTL	PROC	NEAR		;ED 2C (HD64180 only)	TST L
;				-----------------------------------------
	TEST	AL,BL		;nondestructive AND A(AL) with L(BL)
	LAHF			;load AH from flags
	AND	AH,0FCH		;clear subtract and carry flags
	OR	AH,010H		;set aux carry flag
	XOR	CL,CL
	NXTI
HTSTL	ENDP
;
	ORG	(034H*PG)+EDOP
HTSTHL	PROC	NEAR		;ED 34 (HD64180 only)	TST (HL)
;				-----------------------------------------
	TEST	AL,[BX]		;nondestructive AND A(AL) w/memory via HL(BX)
	LAHF			;load AH from flags
	AND	AH,0FCH		;clear subtract and carry flags
	OR	AH,010H		;set aux carry flag
	XOR	CL,CL
	NXTI
HTSTHL	ENDP
;
	ORG	(038H*PG)+EDOP
INAI	PROC	NEAR		;ED 38 (HD64180 only)	IN A,D8 
;				-----------------------------------------
	PUSH	DX		;save DE(DX) on stack
	LODSB			;Get immediate byte D8 low port byte in A
	MOV	DL,AL		;low port byte into DL
	MOV	DH,BYTE PTR R	;Get high port byte from Refresh register
	IN	AL,DX		;Input byte in a(AL) from port in DX
	POP	DX		;restore DE(DX) from stack
	LAHF			;load AH from flags
	AND	AH,0EDH		;clear alt carry and subtract flags
	XOR	CL,CL
	NXTI
INAI	ENDP
;
	ORG	(039H*PG)+EDOP
OUTIA	PROC	NEAR		;ED 39 (HD64180 only)	OUTO D8,A 
;				-----------------------------------------
	PUSH	DX		;save DE(DX) on stack
	PUSH	AX		;save PSW(AX) on stack
	XCHG	AX,CX		;put PSW(AX) in CX
	LODSB			;Get immediate byte D8 low port byte in A
	MOV	DL,AL		;low port byte into DL
	MOV	DH,BYTE PTR R	;Get high port byte from Refresh register
	MOV	AL,CL		;Output byte from A(CL) via AL
	OUT	DX,AL		;Output byte from AL to port in DX
	POP	AX		;restore PSW(AX)
	POP	DX		;restore DE(DX)
	XOR	CL,CL
	NXTI
OUTIA	ENDP
;
	ORG	(03CH*PG)+EDOP
HTSTA	PROC	NEAR		;ED 3C (HD64180 only)	TST A
;				-----------------------------------------
	TEST	AL,AL		;nondestructive AND A(AL) with A(AL)
	LAHF			;load AH from flags
	AND	AH,0FCH		;clear subtract and carry flags
	OR	AH,010H		;set aux carry flag
	XOR	CL,CL
	NXTI
HTSTA	ENDP
;
	ORG	(040H*PG)+EDOP
INBC	PROC	NEAR		;ED 40			IN B,(C)
;				-----------------------------------------
	PUSH	DX		;save DE(DX) on stack
	PUSH	AX		;save PSW(AX) on stack
	MOV	DX,DI		;Put BC(DI) in DX(DE)
	MOV	DH,BYTE PTR R	;Get high port byte from Refresh register
	IN	AL,DX		;Input byte in AL from port in DX
	MOV	DX,DI		;Put BC(DI) in DX(DE)
	MOV	DH,AL		;Get byte input to D(DH)
	MOV	DI,DX		;result in BC(DI)
	POP	AX		;restore PSW(AX)
	POP	DX		;restore DE(DX)
	LAHF			;load AH from flags
	AND	AH,0EDH		;clear alt carry and subtract flags
	XOR	CL,CL
	NXTI
INBC	ENDP
;
	ORG	(041H*PG)+EDOP
OUTCB	PROC	NEAR		;ED 41			OUT (C),B
;				-----------------------------------------
	PUSH	DX		;save DE(DX) on stack
	PUSH	AX		;save PSW(AX) on stack
	MOV	DX,DI		;Put BC(DI) in DX(DE)
	MOV	AL,DH		;Get byte from B(DH) in A(AL)
	MOV	DH,BYTE PTR R	;Get high port byte from Refresh register
	OUT	DX,AL		;Output byte from A(AL)to port in DX
	MOV	DX,DI		;Put BC(DI) in DX(DE)
	POP	AX		;restore PSW(AX)
	POP	DX		;restore DE(DX)
	XOR	CL,CL
	NXTI
OUTCB	ENDP
;
	ORG	(042H*PG)+EDOP
SBHLBC	PROC	NEAR		;ED 42            	SBC HL,BC
;				-----------------------------------------
	SAHF			;save AH in flags
	SBB	BX,DI		;subtract with carry BC(DI) from HL(BX)
	LAHF			;load AH from flags
	JO	SBHLBC1		;jump on overflow
	AND	AH,0F9H		;clear overflow and subtract flags
	OR	AH,002H		;set subtract flag
	XOR	CL,CL
	NXTI
SBHLBC1	EQU	$
	AND	AH,0F9H		;clear overflow and subtract flags
	OR	AH,006H		;set overflow and subtract flags
	XOR	CL,CL
	NXTI
SBHLBC	ENDP
;
	ORG	(043H*PG)+EDOP
LDMBC	PROC	NEAR		;ED 43			LD (nnnn),BC
;				----------------------------------------
	XCHG	CX,AX		;save PSW(AX) in CX
	LODSW			;get immediate word in AX
	XCHG	DI,AX		;save BC(DI) in AX, immed word to DI
	MOV	[DI],AX		;store BC to address in immed word
	XCHG	DI,AX		;restore BC from AX
	XCHG	CX,AX		;restore PSW(AX) from CX
	XOR	CL,CL
	NXTI
LDMBC	ENDP
;
	ORG	(044H*PG)+EDOP
NEG	PROC	NEAR		;ED 44			NEG
;				;---------------------------------------
	NEG	AL		;Negate (reverse bits) of A(AL)
	LAHF			;Load AH from flags.
	JO	NEG1		;jump on overflow
	AND	AH,0F9H		;clear overflow and subtract flags
	OR	AH,002H		;set subtract flag
	XOR	CL,CL
	NXTI
NEG1	EQU	$
	OR	AH,006H		;set overflow and subtract flags
	XOR	CL,CL
	NXTI
NEG	ENDP
;
	ORG	(045H*PG)+EDOP
RETN	PROC	NEAR		;ED 45			RETN
;				----------------------------------------
	MOV	SI,DS:[BP+00H]	;pop stack word into PC(SI)
	INC	BP		;pop stack
	INC	BP
	MOV	CH,BYTE PTR IS	;interrupt status
	TEST	CH,02H
	JNB	RETN1
	OR	CH,01H		;set
	MOV	BYTE PTR IS,CH
RETN1	EQU	$
	XOR	CL,CL
	NXTI
RETN	ENDP
;
	ORG	(046H*PG)+EDOP
IM0	PROC	NEAR		;ED 46			IM 0
;				---------------------------------------
	MOV	BYTE PTR IM,00H	;set Interrupt Mode 0
	XOR	CL,CL
	NXTI
IM0	ENDP
;
	ORG	(047H*PG)+EDOP
LDIA	PROC	NEAR		;ED 47			LD I,A
;				-----------------------------------------
	MOV	BYTE PTR I,AL	;Put A(AL) in I(Interrupt register)
	XOR	CL,CL
	NXTI
LDIA	ENDP
;
	ORG	(048H*PG)+EDOP
INCC	PROC	NEAR		;ED 48			IN C,(C)
;				-----------------------------------------
	PUSH	DX		;save DE(DX) on stack
	PUSH	AX		;save PSW(AX) on stack
	MOV	DX,DI		;Put BC(DI) in DX(DE)
	MOV	DH,BYTE PTR R	;Get high port byte from Refresh register
	IN	AL,DX		;Input byte in AL from port in DX
	MOV	DX,DI		;Put BC(DI) in DX(DE)
	MOV	DL,AL		;Get byte input to E(DL)
	MOV	DI,DX		;result in BC(DI)
	POP	AX		;restore PSW(AX)
	POP	DX		;restore DE(DX)
	LAHF			;load AH from flags
	AND	AH,0EDH		;clear alt carry and subtract flags
	XOR	CL,CL
	NXTI
INCC	ENDP
;
	ORG	(049H*PG)+EDOP
OUTCC	PROC	NEAR		;ED 49			OUT (C),C
;				-----------------------------------------
	PUSH	DX		;save DE(DX) on stack
	PUSH	AX		;save PSW(AX) on stack
	MOV	DX,DI		;Put BC(DI) in DX(DE)
	MOV	AL,DL		;Get byte from C(DL) in A(AL)
	MOV	DH,BYTE PTR R	;Get high port byte from Refresh register
	OUT	DX,AL		;Output byte from A(AL)to port in DX
	MOV	DX,DI		;Put BC(DI) in DX(DE)
	POP	AX		;restore PSW(AX)
	POP	DX		;restore DE(DX)
	XOR	CL,CL
	NXTI
OUTCC	ENDP
;
	ORG	(04AH*PG)+EDOP
ADHLBC	PROC	NEAR		;ED 4A            	ADC HL,BC
;				-----------------------------------------
	SAHF			;save AH in flags
	ADC	BX,DI		;add with carry BC(DI) to HL(BX)
	LAHF			;load AH from flags
	JO	ADHLBC1		;jump on overflow
	AND	AH,0F9H		;clear overflow and subtract flags
	XOR	CL,CL
	NXTI
ADHLBC1	EQU	$
	AND	AH,0F9H		;clear overflow and subtract flags
	OR	AH,004H		;set overflow flag
	XOR	CL,CL
	NXTI
ADHLBC	ENDP
;
	ORG	(04BH*PG)+EDOP
LDBCM	PROC	NEAR		;ED 4B			LD BC,(nnnn)
;				----------------------------------------
	XCHG	CX,AX		;save PSW(AX) in CX
	LODSW			;get immediate word in AX
	XCHG	DI,AX		;save BC(DI) in AX, immed word to DI
	MOV	AX,[DI]		;put word ptd to by immed word in AX
	XCHG	DI,AX		;get word in BC(DI) from AX
	XCHG	CX,AX		;restore PSW(AX) from CX
	XOR	CL,CL
	NXTI
LDBCM	ENDP
;
	ORG	(04CH*PG)+EDOP
HMLTBC	PROC	NEAR		;ED 4C (HD64180 only)	MLT BC
;				------------------------------------
	PUSH	AX		;save PSW(AX)
	XCHG	DI,AX		;get BC(DI) in AX
	MUL	AH		;multiply AH X AL, result in AX
	XCHG	DI,AX		;put result in BC(DI)
	POP	AX		;restore PSW(AX)
	XOR	CL,CL
	NXTI
HMLTBC	ENDP
;
	ORG	(04DH*PG)+EDOP
RETI	PROC	NEAR		;ED 4D			RETI
;				-------------------------------------
	MOV	SI,DS:[BP+00H]	;Pop stack word into PC(BP)
	INC	BP		;pop stack
	INC	BP
	XOR	CL,CL
	NXTI
RETI	ENDP
;
	ORG	(04FH*PG)+EDOP
LDRA	PROC	NEAR		;ED 4F			LD R,A
;				-----------------------------------------
	MOV	BYTE PTR R,AL	;Put A(AL) in R(Refresh register)
	XOR	CL,CL
	NXTI
LDRA	ENDP
;
	ORG	(050H*PG)+EDOP
INDC	PROC	NEAR		;ED 50			IN D,(C)
;				-----------------------------------------
	PUSH	AX		;save PSW(AX) on stack
	PUSH	DX		;save DE(DX) on stack
	MOV	DX,DI		;Put BC(DI) in DX(DE)
	MOV	DH,BYTE PTR R	;Get high port byte from Refresh register
	IN	AL,DX		;Input byte in AL from port in DX
	POP	DX		;Restore DE(DX) from stack
	MOV	DH,AL		;Get byte input to D(DH)
	POP	AX		;restore PSW(AX)
	LAHF			;load AH from flags
	AND	AH,0EDH		;clear alt carry and subtract flags
	XOR	CL,CL
	NXTI
INDC	ENDP
;
	ORG	(051H*PG)+EDOP
OUTCD	PROC	NEAR		;ED 51			OUT (C),D
;				-----------------------------------------
	PUSH	DX		;save DE(DX) on stack
	PUSH	AX		;save PSW(AX) on stack
	MOV	AL,DH		;Get byte from D(DH) in A(AL)
	MOV	DH,BYTE PTR R	;Get high port byte from Refresh register
	OUT	DX,AL		;Output byte from A(AL)to port in DX
	POP	AX		;restore PSW(AX)
	POP	DX		;restore DE(DX)
	XOR	CL,CL
	NXTI
OUTCD	ENDP
;
	ORG	(052H*PG)+EDOP
SBHLDE	PROC	NEAR		;ED 52            	SBC HL,DE
;				-----------------------------------------
	SAHF			;save AH in flags
	SBB	BX,DX		;subtract with carry DE(DX) from HL(BX)
	LAHF			;load AH from flags
	JO	SBHLDE1		;jump on overflow
	AND	AH,0F9H		;clear overflow and subtract flags
	OR	AH,002H		;set subtract flag
	XOR	CL,CL
	NXTI
SBHLDE1	EQU	$
	AND	AH,0F9H		;clear overflow and subtract flags
	OR	AH,006H		;set overflow and subtract flags
	XOR	CL,CL
	NXTI
SBHLDE	ENDP
;
	ORG	(053H*PG)+EDOP
LDMDE	PROC	NEAR		;ED 53			LD (nnnn),DE
;				----------------------------------------
	XCHG	CX,AX		;save PSW(AX) in CX
	LODSW			;get immediate word in AX
	XCHG	DI,AX		;save BC(DI) in AX, immed word to DI
	MOV	[DI],DX		;store DE(DX) to address in immed word
	XCHG	DI,AX		;restore BC from AX
	XCHG	CX,AX		;restore PSW(AX) from CX
	XOR	CL,CL
	NXTI
LDMDE	ENDP
;
	ORG	(056H*PG)+EDOP
IM1	PROC	NEAR		;ED 56			IM 1
;				---------------------------------------
	MOV	BYTE PTR IM,01H	;set Interrupt Mode 1
	XOR	CL,CL
	NXTI
IM1	ENDP
;
	ORG	(057H*PG)+EDOP
LDAI	PROC	NEAR		;ED 57			LD A,I
;				-----------------------------------------
	MOV	AL,BYTE PTR I	;Get I(Interrupt register) in A(AL)
	SAHF			;save AH in flags
	INC	AL
	DEC	AL		
	LAHF			;load AH from flags
	AND	AH,0E9H		;clear aux carry, overflow, subtract flags
	TEST	BYTE PTR IS,01H
	JZ	LDAI1		;not set
	OR	AH,04H		;set overflow flag
LDAI1	EQU	$
	XOR	CL,CL
	NXTI
LDAI	ENDP
;
	ORG	(058H*PG)+EDOP
INEC	PROC	NEAR		;ED 58			IN E,(C)
;				-----------------------------------------
	PUSH	AX		;save PSW(AX) on stack
	PUSH	DX		;save DE(DX) on stack
	MOV	DX,DI		;Put BC(DI) in DX(DE)
	MOV	DH,BYTE PTR R	;Get high port byte from Refresh register
	IN	AL,DX		;Input byte in AL from port in DX
	POP	DX		;Restore DE(DX) from stack
	MOV	DL,AL		;Get byte input to E(DL)
	POP	AX		;restore PSW(AX)
	LAHF			;load AH from flags
	AND	AH,0EDH		;clear alt carry and subtract flags
	XOR	CL,CL
	NXTI
INEC	ENDP
;
	ORG	(059H*PG)+EDOP
OUTCE	PROC	NEAR		;ED 59			OUT (C),E
;				-----------------------------------------
	PUSH	DX		;save DE(DX) on stack
	PUSH	AX		;save PSW(AX) on stack
	MOV	AL,DL		;Get byte from E(DL) in A(AL)
	MOV	DH,BYTE PTR R	;Get high port byte from Refresh register
	OUT	DX,AL		;Output byte from A(AL)to port in DX
	POP	AX		;restore PSW(AX)
	POP	DX		;restore DE(DX)
	XOR	CL,CL
	NXTI
OUTCE	ENDP
;
	ORG	(05AH*PG)+EDOP
ADHLDE	PROC	NEAR		;ED 5A            	ADC HL,DE
;				-----------------------------------------
	SAHF			;save AH in flags
	ADC	BX,DX		;add with carry DE(DX) to HL(BX)
	LAHF			;load AH from flags
	JO	ADHLDE1		;jump on overflow
	AND	AH,0F9H		;clear overflow and subtract flags
	XOR	CL,CL
	NXTI
ADHLDE1	EQU	$
	AND	AH,0F9H		;clear overflow and subtract flags
	OR	AH,004H		;set overflow flag
	XOR	CL,CL
	NXTI
ADHLDE	ENDP
;
	ORG	(05BH*PG)+EDOP
LDDEM	PROC	NEAR		;ED 5B			LD DE,(nnnn)
;				----------------------------------------
	XCHG	CX,AX		;save PSW(AX) in CX
	LODSW			;get immediate word in AX
	XCHG	DI,AX		;save BC(DI) in AX, immed word to DI
	MOV	DX,[DI]		;Put word from immed adr in DE (DX)   
	XCHG	DI,AX		;restore BC from AX
	XCHG	CX,AX		;restore PSW(AX) from CX
	XOR	CL,CL
	NXTI
LDDEM	ENDP
;
	ORG	(05CH*PG)+EDOP
HMLTDE	PROC	NEAR		;ED 5C (HD64180 only)	MLT DE
;				------------------------------------
	PUSH	AX		;save PSW(AX)
	XCHG	DX,AX		;get DE(DX) in AX
	MUL	AH		;multiply AH X AL, result in AX
	XCHG	DX,AX		;put result in DE(DX)
	POP	AX		;restore PSW(AX)
	XOR	CL,CL
	NXTI
HMLTDE	ENDP
;
	ORG	(05EH*PG)+EDOP
IM2	PROC	NEAR		;ED 5E			IM 2
;				---------------------------------------
	MOV	BYTE PTR IM,02H	;set Interrupt Mode 2
	XOR	CL,CL
	NXTI
IM2	ENDP
;
	ORG	(05FH*PG)+EDOP
LDAR	PROC	NEAR		;ED 5F			LD A,R
;				-----------------------------------------
	MOV	AL,BYTE PTR R	;Get R(Refresh register) in A(AL)
	SAHF			;save AH in flags
	INC	AL
	DEC	AL		
	LAHF			;load AH from flags
	AND	AH,0E9H		;clear aux carry, overflow, subtract flags
	TEST	BYTE PTR IS,01H
	JZ	LDAR1		;not set
	OR	AH,04H		;set overflow flag
LDAR1	EQU	$
	XOR	CL,CL
	NXTI
LDAR	ENDP
;
	ORG	(060H*PG)+EDOP
INHC	PROC	NEAR		;ED 60			IN H,(C)
;				-----------------------------------------
	PUSH	AX		;save PSW(AX) on stack
	PUSH	DX		;save DE(DX) on stack
	MOV	DX,DI		;Put BC(DI) in DX(DE)
	MOV	DH,BYTE PTR R	;Get high port byte from Refresh register
	IN	AL,DX		;Input byte in AL from port in DX
	POP	DX		;Restore DE(DX) from stack
	MOV	BH,AL		;Get byte input to H(BH)
	POP	AX		;restore PSW(AX)
	LAHF			;load AH from flags
	AND	AH,0EDH		;clear alt carry and subtract flags
	XOR	CL,CL
	NXTI
INHC	ENDP
;
	ORG	(061H*PG)+EDOP
OUTCH	PROC	NEAR		;ED 61			OUT (C),H
;				-----------------------------------------
	PUSH	DX		;save DE(DX) on stack
	PUSH	AX		;save PSW(AX) on stack
	MOV	AL,BH		;Get byte from H(BH) in A(AL)
	MOV	DH,BYTE PTR R	;Get high port byte from Refresh register
	OUT	DX,AL		;Output byte from A(AL)to port in DX
	POP	AX		;restore PSW(AX)
	POP	DX		;restore DE(DX)
	XOR	CL,CL
	NXTI
OUTCH	ENDP
;
	ORG	(062H*PG)+EDOP
SBHLHL	PROC	NEAR		;ED 62            	SBC HL,HL
;				-----------------------------------------
	SAHF			;save AH in flags
	SBB	BX,BX		;subtract with carry HL(BX) from HL(BX)
	LAHF			;load AH from flags
	JO	SBHLHL1		;jump on overflow
	AND	AH,0F9H		;clear overflow and subtract flags
	OR	AH,002H		;set subtract flag
	XOR	CL,CL
	NXTI
SBHLHL1	EQU	$
	AND	AH,0F9H		;clear overflow and subtract flags
	OR	AH,006H		;set overflow and subtract flags
	XOR	CL,CL
	NXTI
SBHLHL	ENDP
;
	ORG	(064H*PG)+EDOP
HTSTI	PROC	NEAR		;ED 64 (HD64180 only)	TST D8
;				-----------------------------------------
	XCHG	CX,AX		;Save PSW(AX) in CX
	LODSB			;get immediate data byte in A(AL)
	TEST	AL,CL		;nondestructive AND A(AL) with D8(CL)
	XCHG	CX,AX		;Restore PSW(AX) from CX
	LAHF			;load AH from flags
	AND	AH,0FCH		;clear subtract and carry flags
	OR	AH,010H		;set aux carry flag
	XOR	CL,CL
	NXTI
HTSTI	ENDP
;
	ORG	(067H*PG)+EDOP
RRD4	PROC	NEAR		;ED 67			RRD
;				-----------------------------------------
	RCR	AL,1		;rotate right thru carry A(AL) 1 bit right
	RCR	BYTE PTR [BX],1 ;same with byte ptd by HL(BX)
	RCR	AL,1		;this code rotates 4 bits thru 12 bits
	RCR	BYTE PTR [BX],1	;of A(AL) and memory byte
	RCR	AL,1
	RCR	BYTE PTR [BX],1
	RCR	AL,1
	RCR	BYTE PTR [BX],1
	MOV	CL,05H
	RCR	AL,CL
	SAHF			;save AH in flags
	INC	AL
	DEC	AL
	LAHF			;load AH from flags
	AND	AH,0EDH		;clear alt carry and subtract flags
	XOR	CL,CL
	NXTI
RRD4	ENDP
;
	ORG	(068H*PG)+EDOP
INLC	PROC	NEAR		;ED 68			IN L,(C)
;				-----------------------------------------
	PUSH	AX		;save PSW(AX) on stack
	PUSH	DX		;save DE(DX) on stack
	MOV	DX,DI		;Put BC(DI) in DX(DE)
	MOV	DH,BYTE PTR R	;Get high port byte from Refresh register
	IN	AL,DX		;Input byte in AL from port in DX
	POP	DX		;Restore DE(DX) from stack
	MOV	BL,AL		;Get byte input to L(BL)
	POP	AX		;restore PSW(AX)
	LAHF			;load AH from flags
	AND	AH,0EDH		;clear alt carry and subtract flags
	XOR	CL,CL
	NXTI
INLC	ENDP
;
	ORG	(069H*PG)+EDOP
OUTCL	PROC	NEAR		;ED 69			OUT (C),L
;				-----------------------------------------
	PUSH	DX		;save DE(DX) on stack
	PUSH	AX		;save PSW(AX) on stack
	MOV	AL,BL		;Get byte from L(BL) in A(AL)
	MOV	DH,BYTE PTR R	;Get high port byte from Refresh register
	OUT	DX,AL		;Output byte from A(AL)to port in DX
	POP	AX		;restore PSW(AX)
	POP	DX		;restore DE(DX)
	XOR	CL,CL
	NXTI
OUTCL	ENDP
;
	ORG	(06AH*PG)+EDOP
ADHLHL	PROC	NEAR		;ED 6A            	ADC HL,HL
;				-----------------------------------------
	SAHF			;save AH in flags
	ADC	BX,BX		;add with carry HL(BX) to HL(BX)
	LAHF			;load AH from flags
	JO	ADHLHL1		;jump on overflow
	AND	AH,0F9H		;clear overflow and subtract flags
	XOR	CL,CL
	NXTI
ADHLHL1	EQU	$
	AND	AH,0F9H		;clear overflow and subtract flags
	OR	AH,004H		;set overflow flag
	XOR	CL,CL
	NXTI
ADHLHL	ENDP
;
	ORG	(06CH*PG)+EDOP
HMLTHL	PROC	NEAR		;ED 6C (HD64180 only)	MLT HL
;				------------------------------------
	PUSH	AX		;save PSW(AX)
	XCHG	BX,AX		;get HL(BX) in AX
	MUL	AH		;multiply AH X AL, result in AX
	XCHG	BX,AX		;put result in HL(BX)
	POP	AX		;restore PSW(AX)
	XOR	CL,CL
	NXTI
HMLTHL	ENDP
;
	ORG	(06FH*PG)+EDOP
RLD4	PROC	NEAR		;ED 6F			RLD
;				-----------------------------------------
	MOV	CL,4		;rotate 4 bits
	ROL	AL,CL		;left in A(AL)
	RCL	AL,1		;rotate left with carry 1 bit A(AL)
	RCL	BYTE PTR [BX],1	;same with byte ptd to by HL(BX)
	RCL	AL,1		;4 bits worth (thru 12 bits A/memory)
	RCL	BYTE PTR [BX],1
	RCL	AL,1
	RCL	BYTE PTR [BX],1
	RCL	AL,1
	RCL	BYTE PTR [BX],1
	MOV	CL,05H
	RCL	AL,CL
	MOV	CL,04H
	ROL	AL,CL
	SAHF			;save AH in flags
	INC	AL
	DEC	AL
	LAHF			;load AH from flags
	AND	AH,0EDH		;clear alt carry and subtract flags
	XOR	CL,CL
	NXTI
RLD4	ENDP
;
	ORG	(072H*PG)+EDOP
SBHLSP	PROC	NEAR		;ED 72            	SBC HL,SP
;				-----------------------------------------
	SAHF			;save AH in flags
	SBB	BX,BP		;subtract with carry SP(BP) from HL(BX)
	LAHF			;load AH from flags
	JO	SBHLSP1		;jump on overflow
	AND	AH,0F9H		;clear overflow and subtract flags
	OR	AH,002H		;set subtract flag
	XOR	CL,CL
	NXTI
SBHLSP1	EQU	$
	AND	AH,0F9H		;clear overflow and subtract flags
	OR	AH,006H		;set overflow and subtract flags
	XOR	CL,CL
	NXTI
SBHLSP	ENDP
;
	ORG	(073H*PG)+EDOP
LDMSP	PROC	NEAR		;ED 73			LD (nnnn),SP
;				----------------------------------------
	XCHG	CX,AX		;save PSW(AX) in CX
	LODSW			;get immediate word in AX
	XCHG	DI,AX		;save BC(DI) in AX, immed word to DI
	MOV	[DI],BP		;store SP(BP) to address in immed word
	XCHG	DI,AX		;restore BC from AX
	XCHG	CX,AX		;restore PSW(AX) from CX
	XOR	CL,CL
	NXTI
LDMSP	ENDP
;
	ORG	(074H*PG)+EDOP
TSTIO	PROC	NEAR		;ED 74 (HD64180 only)	TSTIO   
;				-----------------------------------------
	PUSH	DX		;save DE(DX) on stack
	XCHG	AX,CX		;save PSW(AX) in CX
	LODSB			;Get immediate byte D8 low port byte in A
	MOV	DL,AL		;low port byte into DL
	MOV	DH,BYTE PTR R	;Get high port byte from Refresh register
	IN	AL,DX		;Input byte in a(AL) from port in DX
	TEST	AL,AL		;nondestructive AND A(AL) with A(AL)
	LAHF			;load AH from flags
	AND	AH,0FCH		;clear subtract and carry flags
	OR	AH,010H		;set aux carry flag
	MOV	AL,CL		;restore A(AL) from CL
	POP	DX		;restore DE(DX) from stack
	XOR	CL,CL
	NXTI
TSTIO	ENDP
;
	ORG	(078H*PG)+EDOP
INAC	PROC	NEAR		;ED 78			IN A,(C)
;				-----------------------------------------
	PUSH	DX		;save DE(DX) on stack
	MOV	DX,DI		;Put BC(DI) in DX(DE)
	MOV	DH,BYTE PTR R	;Get high port byte from Refresh register
	IN	AL,DX		;Input byte in A(AL) from port in DX
	POP	DX		;Restore DE(DX) from stack
	LAHF			;load AH from flags
	AND	AH,0EDH		;clear alt carry and subtract flags
	XOR	CL,CL
	NXTI
INAC	ENDP
;
	ORG	(07AH*PG)+EDOP
ADHLSP	PROC	NEAR		;ED 7A            	ADC HL,SP
;				-----------------------------------------
	SAHF			;save AH in flags
	ADC	BX,BP		;add with carry SP(BP) to HL(BX)
	LAHF			;load AH from flags
	JO	ADHLSP1		;jump on overflow
	AND	AH,0F9H		;clear overflow and subtract flags
	XOR	CL,CL
	NXTI
ADHLSP1	EQU	$
	AND	AH,0F9H		;clear overflow and subtract flags
	OR	AH,004H		;set overflow flag
	XOR	CL,CL
	NXTI
ADHLSP	ENDP
;
	ORG	(07BH*PG)+EDOP
LDSPM	PROC	NEAR		;ED 7B			LD DE,(nnnn)
;				----------------------------------------
	XCHG	CX,AX		;save PSW(AX) in CX
	LODSW			;get immediate word in AX
	XCHG	DI,AX		;save BC(DI) in AX, immed word to DI
	MOV	BP,[DI]		;Get word ptd to be immed addrs in SP(BP)
	XCHG	DI,AX		;restore BC from AX
	XCHG	CX,AX		;restore PSW(AX) from CX
	XOR	CL,CL
	NXTI
LDSPM	ENDP
;
	ORG	(07CH*PG)+EDOP
HMLTSP	PROC	NEAR		;ED 7C (HD64180 only)	MLT SP
;				------------------------------------
	PUSH	AX		;save PSW(AX)
	XCHG	BP,AX		;get SP(BP) in AX
	MUL	AH		;multiply AH X AL, result in AX
	XCHG	BP,AX		;put result in SP(BP)
	POP	AX		;restore PSW(AX)
	XOR	CL,CL
	NXTI
HMLTSP	ENDP
;
	ORG	(083H*PG)+EDOP
OTIM	PROC	NEAR		;ED 83 (HD64180 only)	OTIM
;				-----------------------------------------
	PUSH	DX		;save DE(DX) on stack
	MOV	DX,DI		;Put BC(DI) in DX(DE)
	MOV	DH,BYTE PTR R	;Get high port byte from Refresh register
	MOV	AL,[BX]		;Get output byte from memory via HL(BX)
	OUT	DX,AL		;Output byte in A(AL) to port in DX
	INC	BX		;Increment HL(BX)
	XCHG	DX,DI		;BC(DI) to DE(DX)
	INC	DL		;Increment C(DL)
	DEC	DH		;Decrement B(DH) 
	XCHG	DX,DI		;restore BC(DI) and DX(DE)
	LAHF			;Load AH from flags
	PUSH	BX		;save HL(BX) on stack
	MOV	CL,7		;position MSB in H
	SHR	BH,CL
	SHL	BH,1		;position bit as subtract flag
	OR	AH,BH		;save HL MSB in subtract flag
	POP	BX		;restore HL(BX) from stack
	POP	DX		;Restore DE(DX) from stack
	XOR	CL,CL
	NXTI
OTIM 	ENDP
;
	ORG	(08BH*PG)+EDOP
OTDM	PROC	NEAR		;ED 8B (HD64180 only)	OTDM
;				-----------------------------------------
	PUSH	DX		;save DE(DX) on stack
	MOV	DX,DI		;Put BC(DI) in DX(DE)
	MOV	DH,BYTE PTR R	;Get high port byte from Refresh register
	MOV	AL,[BX]		;Get output byte from memory via HL(BX)
	OUT	DX,AL		;Output byte in A(AL) to port in DX
	DEC	BX		;Decrement HL(BX)
	XCHG	DX,DI		;BC(DI) to DE(DX)
	DEC	DL		;Decrement C(DL)
	DEC	DH		;Decrement B(DH) 
	XCHG	DX,DI		;restore BC(DI)
	LAHF			;Load AH from flags
	PUSH	BX		;save HL(BX) on stack
	MOV	CL,7		;position MSB in H
	SHR	BH,CL
	SHL	BH,1		;position bit as subtract flag
	OR	AH,BH		;save HL MSB in subtract flag
	POP	BX		;restore HL(BX) from stack
	POP	DX		;Restore DE(DX) from stack
	XOR	CL,CL
	NXTI
OTDM 	ENDP
;
	ORG	(093H*PG)+EDOP
OTIMR	PROC	NEAR		;ED 93 (HD64180 only)	OTIMR
;				-----------------------------------------
	PUSH	DX		;save DE(DX) on stack
OTIMR1	EQU	$
	MOV	DX,DI		;Put BC(DI) in DX(DE)
	MOV	DH,BYTE PTR R	;Get high port byte from Refresh register
	MOV	AL,[BX]		;Get output byte from memory via HL(BX)
	OUT	DX,AL		;Output byte in A(AL) to port in DX
	INC	BX		;Increment HL(BX)
	XCHG	DX,DI		;BC(DI) to DE(DX)
	INC	DL		;Increment C(DL)
	DEC	DH		;Decrement B(DH) 
	XCHG	DX,DI		;restore BC(DI) and DX(DE)
	JNZ	OTIMR1		;loop until B(DH) is zero
	LAHF			;Load AH from flags
	PUSH	BX		;save HL(BX) on stack
	MOV	CL,7		;position MSB in H
	SHR	BH,CL
	SHL	BH,1		;position bit as subtract flag
	OR	AH,BH		;save HL MSB in subtract flag
	POP	BX		;restore HL(BX) from stack
	POP	DX		;Restore DE(DX) from stack
	XOR	CL,CL
	NXTI
OTIMR 	ENDP
;
	ORG	(09BH*PG)+EDOP
OTDMR	PROC	NEAR		;ED 9B (HD64180 only)	OTDMR
;				-----------------------------------------
	PUSH	DX		;save DE(DX) on stack
OTDMR1	EQU	$
	MOV	DX,DI		;Put BC(DI) in DX(DE)
	MOV	DH,BYTE PTR R	;Get high port byte from Refresh register
	MOV	AL,[BX]		;Get output byte from memory via HL(BX)
	OUT	DX,AL		;Output byte in A(AL) to port in DX
	DEC	BX		;Decrement HL(BX)
	XCHG	DX,DI		;BC(DI) to DE(DX)
	DEC	DL		;Decrement C(DL)
	DEC	DH		;Decrement B(DH) 
	XCHG	DX,DI		;restore BC(DI) and DX(DE)
	JNZ	OTDMR1		;loop until B(DH) is zero
	LAHF			;Load AH from flags
	PUSH	BX		;save HL(BX) on stack
	MOV	CL,7		;position MSB in H
	SHR	BH,CL
	SHL	BH,1		;position bit as subtract flag
	OR	AH,BH		;save HL MSB in subtract flag
	POP	BX		;restore HL(BX) from stack
	POP	DX		;Restore DE(DX) from stack
	XOR	CL,CL
	NXTI
OTDMR 	ENDP
;
	ORG	(0A0H*PG)+EDOP
LDI	PROC	NEAR		;ED A0			LDI
;				-----------------------------------------
	MOV	CH,[BX]		;Get byte ref by HL(BX)
	XCHG	BX,DX		;Exchange HL(BX) and DE(DX)
	MOV	[BX],CH		;Store byte pointed to by DE
	XCHG	BX,DX		;Exchange HL(BX) and DE(DX)
	INC	BX		;Increment HL(BX)
	INC 	DX		;Increment DE(DX)
	DEC	DI		;Decrement BC(DI)
	JZ	LDI1		;if zero
	AND	AH,0E9H		;clear alt carry, overflow and subtract flags
	OR	AH,004H		;set overflow flag
	XOR	CL,CL
	NXTI
LDI1	EQU	$
	AND	AH,0E9H		;clear alt carry, overflow and subtract flags
	XOR	CL,CL
	NXTI
LDI	ENDP
;
	ORG	(0A1H*PG)+EDOP
CPIZ	PROC	NEAR		;ED A1			CPI
;				-------------------------------------------
	SAHF			;save AH in flags
	PUSHF			;push flags
	CMP	AL,[BX]		;compare memory(HL) byte to A(AL)
	LAHF			;load AH from flags
	AND	AH,0FAH		;clear overflow and carry flags
	POPF			;pop flags
	JNB	CPIZ1		;jump no carry
	OR	AH,001H		;set carry flag
CPIZ1	EQU	$
	DEC	DI		;decrement BC(DI)
	JZ	CPIZ2		;jump if BC(DI) zero
	OR	AH,004H		;set overflow flag
CPIZ2	EQU	$
	OR	AH,002H		;set subtract flag
	INC	BX		;increment HL(BX)
	XOR	CL,CL
	NXTI
CPIZ	ENDP
;
	ORG	(0A2H*PG)+EDOP
INI 	PROC	NEAR		;ED A2			INI
;				-----------------------------------------
	PUSH	DX		;save DE(DX) on stack
	MOV	DX,DI		;Put BC(DI) in DX(DE)
	MOV	DH,BYTE PTR R	;Get high port byte from Refresh register
	IN	AL,DX		;Input byte in A(AL) from port in DX
	MOV	[BX],AL		;Move input byte to memory via HL(BX)
	INC	BX		;Increment HL(BX)
	XCHG	DX,DI		;BC(DI) to DE(DX)
	DEC	DH		;Decrement B(DH) 
	LAHF			;Load AH from flags
	OR	AH,002H		;Set subtract flag
	XCHG	DX,DI		;restore BC(DI) and DE(DX)	
	POP	DX		;Restore DE(DX) from stack
	XOR	CL,CL
	NXTI
INI 	ENDP
;
	ORG	(0A3H*PG)+EDOP
OUTI 	PROC	NEAR		;ED A3			OUTI
;				-----------------------------------------
	PUSH	DX		;save DE(DX) on stack
	MOV	DX,DI		;Put BC(DI) in DX(DE)
	MOV	DH,BYTE PTR R	;Get high port byte from Refresh register
	MOV	AL,[BX]		;Get output byte from memory via HL(BX)
	OUT	DX,AL		;Output byte in A(AL) to port in DX
	INC	BX		;Increment HL(BX)
	XCHG	DX,DI		;BC(DI) to DE(DX)
	DEC	DH		;Decrement B(DH) 
	LAHF			;Load AH from flags
	OR	AH,002H		;Set subtract flag
	XCHG	DX,DI		;restore BC(DI) and DE(DX)	
	POP	DX		;Restore DE(DX) from stack
	XOR	CL,CL
	NXTI
OUTI 	ENDP
;
	ORG	(0A8H*PG)+EDOP
LDD	PROC	NEAR		;ED A8			LDD
;				-----------------------------------------
	MOV	CH,[BX]		;Get byte ref by HL(BX)
	XCHG	BX,DX		;Exchange HL(BX) and DE(DX)
	MOV	[BX],CH		;Store byte pointed to by DE
	XCHG	BX,DX		;Exchange HL(BX) and DE(DX)
	DEC	BX		;Decrement HL(BX)
	DEC 	DX		;Decrement DE(DX)
	DEC	DI		;Decrement BC(DI)
	JZ	LDD1		;if zero
	AND	AH,0E9H		;clear alt carry, overflow and subtract flags
	OR	AH,004H		;set overflow flag
	XOR	CL,CL
	NXTI
LDD1	EQU	$
	AND	AH,0E9H		;clear alt carry, overflow and subtract flags
	XOR	CL,CL
	NXTI
LDD	ENDP
;
	ORG	(0A9H*PG)+EDOP
CPD	PROC	NEAR		;ED A9			CPD
;				-------------------------------------------
	SAHF			;save AH in flags
	PUSHF			;push flags
	CMP	AL,[BX]		;compare memory(HL) byte to A(AL)
	LAHF			;load AH from flags
	AND	AH,0FAH		;clear overflow and carry flags
	POPF			;pop flags
	JNB	CPD1		;jump no carry
	OR	AH,001H		;set carry flag
CPD1	EQU	$
	DEC	DI		;decrement BC(DI)
	JZ	CPD2		;jump if BC(DI) zero
	OR	AH,004H		;set overflow flag
CPD2	EQU	$
	OR	AH,002H		;set subtract flag
	DEC	BX		;increment HL(BX)
	XOR	CL,CL
	NXTI
CPD	ENDP
;
	ORG	(0AAH*PG)+EDOP
IND 	PROC	NEAR		;ED AA			IND
;				-----------------------------------------
	PUSH	DX		;save DE(DX) on stack
	MOV	DX,DI		;Put BC(DI) in DX(DE)
	MOV	DH,BYTE PTR R	;Get high port byte from Refresh register
	IN	AL,DX		;Input byte in A(AL) from port in DX
	MOV	[BX],AL		;Move input byte to memory via HL(BX)
	DEC	BX		;Decrement HL(BX)
	XCHG	DX,DI		;BC(DI) to DE(DX)
	DEC	DH		;Decrement B(DH) 
	LAHF			;Load AH from flags
	OR	AH,002H		;Set subtract flag
	XCHG	DX,DI		;restore BC(DI) and DE(DX)	
	POP	DX		;Restore DE(DX) from stack
	XOR	CL,CL
	NXTI
IND 	ENDP
;
	ORG	(0ABH*PG)+EDOP
OUTD 	PROC	NEAR		;ED AB			OUTD
;				-----------------------------------------
	PUSH	DX		;save DE(DX) on stack
	MOV	DX,DI		;Put BC(DI) in DX(DE)
	MOV	DH,BYTE PTR R	;Get high port byte from Refresh register
	MOV	AL,[BX]		;Get output byte from memory via HL(BX)
	OUT	DX,AL		;Output byte in A(AL) to port in DX
	DEC	BX		;Decrement HL(BX)
	XCHG	DX,DI		;BC(DI) to DE(DX)
	DEC	DH		;Decrement B(DH) 
	LAHF			;Load AH from flags
	OR	AH,002H		;Set subtract flag
	XCHG	DX,DI		;restore BC(DI) and DE(DX)	
	POP	DX		;Restore DE(DX) from stack
	XOR	CL,CL
	NXTI
OUTD 	ENDP
;
	ORG	(0B0H*PG)+EDOP
LDIR	PROC	NEAR		;ED B0			LDIR
;				------------------------------------------
	PUSH	ES		;save ES on stack
	MOV	WORD PTR PC,SI	;save PC(SI)
	PUSH	AX		;save PSW(AX) on stack
	CLD			;clear direction flag (increment SI,DI)
	MOV	AX,DS
	MOV	ES,AX		;set ES same as DS
	MOV	CX,DI		;put BC(DI) in CX
	MOV	SI,BX		;put HL(BX) in PC(SI)
	MOV	DI,DX		;put DE(DX) in DI
	REPZ	MOVSB		;move bytes from (HL) to (DE) until BC zero
	MOV	BX,SI		;return HL(BX) value
	MOV	DX,DI		;return DE(DX) value 
	MOV	DI,CX		;return BC(DI) value
	POP	AX		;restore PSW(AX) from stack
	MOV	SI,WORD PTR PC	;restore PC(SI) from save word
	POP	ES		;restore ES from stack
	AND	AH,0E9H		;clear aux carry, overflow and subtract flags
	XOR	CL,CL
	NXTI
LDIR	ENDP
;
	ORG	(0B1H*PG)+EDOP
CPIR	PROC	NEAR		;ED B1			CPIR
;				-------------------------------------------
	PUSHF			;push flags
CPIR1	EQU	$
	CMP	AL,[BX]		;compare memory(HL) byte to A(AL)
	LAHF			;load AH from flags
	JZ	CPIR2		;if zero
	INC	BX		;increment HL(BX)
	DEC	DI		;decrement BC(DI)
	JNZ	CPIR1		;if non-zero
	JMP	CPIR3		;if zero
CPIR2	EQU	$
	INC	BX		;increment HL(BX)
	DEC	DI		;decrement BC(DI)
CPIR3	EQU	$
	AND	AH,0F8H		;clear overflow, subtract and carry flags
	OR	AH,002H		;set subtract flag
	POPF			;pop flags
	JNB	CPIR4		;jump no carry
	OR	AH,001H		;set carry flag
CPIR4	EQU	$
	OR	DI,DI
	JZ	CPIR5		;jump if BC zero
	OR	AH,004H		;set overflow flag
CPIR5	EQU	$
	XOR	CL,CL
	NXTI
CPIR	ENDP
;
	ORG	(0B2H*PG)+EDOP
INIR 	PROC	NEAR		;ED B2			INIR
;				-----------------------------------------
	PUSH	DX		;save DE(DX) on stack
INIR1	EQU	$
	MOV	DX,DI		;Put BC(DI) in DX(DE)
	MOV	DH,BYTE PTR R	;Get high port byte from Refresh register
	IN	AL,DX		;Input byte in A(AL) from port in DX
	MOV	[BX],AL		;Move input byte to memory via HL(BX)
	INC	BX		;Increment HL(BX)
	XCHG	DX,DI		;BC(DI) to DE(DX)
	DEC	DH		;Decrement B(DH) 
	JNZ	INIR1		;Loop until B(DH) zero
	LAHF			;load AH from flags
	OR	AH,002H		;Set subtract flag
	XCHG	DX,DI		;restore BC(DI) and DE(DX)	
	POP	DX		;Restore DE(DX) from stack
	XOR	CL,CL
	NXTI
INIR 	ENDP
;
	ORG	(0B3H*PG)+EDOP
OUTIR 	PROC	NEAR		;ED B3			OUTIR
;				-----------------------------------------
	PUSH	DX		;save DE(DX) on stack
OUTIR1	EQU	$
	MOV	DX,DI		;Put BC(DI) in DX(DE)
	MOV	DH,BYTE PTR R	;Get high port byte from Refresh register
	MOV	AL,[BX]		;Get output byte from memory via HL(BX)
	OUT	DX,AL		;Output byte in A(AL) to port in DX
	INC	BX		;Increment HL(BX)
	XCHG	DX,DI		;BC(DI) to DE(DX)
	DEC	DH		;Decrement B(DH) 
	JNZ	OUTIR1		;Loop until B(DH) count zero
	LAHF			;Load AH from flags
	OR	AH,002H		;Set subtract flag
	XCHG	DX,DI		;restore BC(DI) and DE(DX)	
	POP	DX		;Restore DE(DX) from stack
	XOR	CL,CL
	NXTI
OUTIR 	ENDP
;
	ORG	(0B8H*PG)+EDOP
LDDR	PROC	NEAR		;ED B8			LDDR
;				------------------------------------------
	PUSH	ES		;save ES on stack
	MOV	WORD PTR PC,SI	;save PC(SI)
	PUSH	AX		;save PSW(AX) on stack
	STD			;set direction flag (decrement SI, DI)
	MOV	AX,DS
	MOV	ES,AX		;set ES same as DS
	MOV	CX,DI		;put BC(DI) in CX
	MOV	SI,BX		;put HL(BX) in PC(SI)
	MOV	DI,DX		;put DE(DX) in DI
	REPZ	MOVSB		;move bytes from (HL) to (DE) until BC zero
	MOV	BX,SI		;return HL(BX) value
	MOV	DX,DI		;return DE(DX) value 
	MOV	DI,CX		;return BC(DI) value
	POP	AX		;restore PSW(AX) from stack
	MOV	SI,WORD PTR PC	;restore PC(SI) from save word
	POP	ES		;restore ES from stack
	AND	AH,0E9H		;clear aux carry, overflow and subtract flags
	CLD			;clear direction flag
	XOR	CL,CL
	NXTI
LDDR	ENDP
;
	ORG	(0B9H*PG)+EDOP
CPDR	PROC	NEAR		;ED B9			CPDR
;				-------------------------------------------
	PUSHF			;push flags
CPDR1	EQU	$
	CMP	AL,[BX]		;compare memory(HL) byte to A(AL)
	LAHF			;load AH from flags
	JZ	CPDR2		;if zero
	DEC	BX		;decrement HL(BX)
	DEC	DI		;decrement BC(DI)
	JNZ	CPDR1		;if non-zero
	JMP	CPDR3		;if zero
CPDR2	EQU	$
	DEC	BX		;decrement HL(BX)
	DEC	DI		;decrement BC(DI)
CPDR3	EQU	$
	AND	AH,0F8H		;clear overflow, subtract and carry flags
	OR	AH,002H		;set subtract flag
	POPF			;pop flags
	JNB	CPDR4		;jump no carry
	OR	AH,001H		;set carry flag
CPDR4	EQU	$
	OR	DI,DI
	JZ	CPDR5		;jump if BC zero
	OR	AH,004H		;set overflow flag
CPDR5	EQU	$
	XOR	CL,CL
	NXTI
CPDR	ENDP
;
	ORG	(0BAH*PG)+EDOP
INDR 	PROC	NEAR		;ED BA			INDR
;				-----------------------------------------
	PUSH	DX		;save DE(DX) on stack
INDR1	EQU	$
	MOV	DX,DI		;Put BC(DI) in DX(DE)
	MOV	DH,BYTE PTR R	;Get high port byte from Refresh register
	IN	AL,DX		;Input byte in A(AL) from port in DX
	MOV	[BX],AL		;Move input byte to memory via HL(BX)
	DEC	BX		;Decrement HL(BX)
	XCHG	DX,DI		;BC(DI) to DE(DX)
	DEC	DH		;Decrement B(DH) 
	JNZ	INDR1		;Loop until B(DH) zero
	LAHF			;load AH from flags
	OR	AH,002H		;Set subtract flag
	XCHG	DX,DI		;restore BC(DI) and DE(DX)	
	POP	DX		;Restore DE(DX) from stack
	XOR	CL,CL
	NXTI
INDR 	ENDP
;
	ORG	(0BBH*PG)+EDOP
OUTDR 	PROC	NEAR		;ED BB			OUTDR
;				-----------------------------------------
	PUSH	DX		;save DE(DX) on stack
OUTDR1	EQU	$
	MOV	DX,DI		;Put BC(DI) in DX(DE)
	MOV	DH,BYTE PTR R	;Get high port byte from Refresh register
	MOV	AL,[BX]		;Get output byte from memory via HL(BX)
	OUT	DX,AL		;Output byte in A(AL) to port in DX
	DEC	BX		;Decrement HL(BX)
	XCHG	DX,DI		;BC(DI) to DE(DX)
	DEC	DH		;Decrement B(DH) 
	JNZ	OUTDR1		;Loop until B(DH) count zero
	LAHF			;Load AH from flags
	OR	AH,002H		;Set subtract flag
	XCHG	DX,DI		;restore BC(DI) and DE(DX)	
	POP	DX		;Restore DE(DX) from stack
	XOR	CL,CL
	NXTI
OUTDR 	ENDP
;
;========================================================================
;
	ORG	(0EDH*PG)+EDOP
CALLN	PROC	NEAR		;ED ED nn - CALLN
;				-----------------------------------------
	JMP	CALLN1
CALLN2	EQU	$
	PUSHF			;push flags
	PUSH	SI		;push P(SI)
	MOV	CX,DI		;save BC(DI) in CX
	INT	081H		;do the CALLN interrupt
INTNO	EQU	$-1
	POP	SI		;restore P(SI)
	POPF			;restore flags
	XOR	CL,CL
	NXTI
CALLN1	EQU	$
	MOV	CH,[SI]		;Get interrupt number byte
	INC	SI		;Bump P(SI) over int number byte
	DB	088H,02EH	;MOV BYTE PTR INTNO,CH
	DW	0EDB8H
	JMP	CALLN2
CALLN	ENDP
;
	ORG	(0FDH*PG)+EDOP
BRKEM	PROC	NEAR		;ED FD - BRKEM
;				------------------------------------------
	IRET			;return from interrupt
BRKEM	ENDP
;
;========================================================================
;
PROG	ENDS
CODES	ENDS
	END

	