/*
** seerel -- show REL items
*/
#include <stdio.h>
#include "rel.h"
int lc, width;
/*
** display REL item
** on call:
**    item = item code
**    type = type of field
**   field = value of field
**  symbol = symbol name
*/ 
seerel() {
  char str[6]; int tmp;
  switch(item) {
    case    ABS: see8(field, ' '); lc += 1; newlin(NO); return;
    case   PREL: 
    case   DREL: 
    case   CREL: see16(); lc += 2; newlin(NO); return;
    case  XMOFF:
    case  XPOFF: tmp = type; type = item; see16();
                 type = tmp; newlin(NO); return;

    case  ENAME: seenam("     entry: ", NO); goto eol;
    case  CNAME: seenam("    common: ", NO); goto eol;
    case  PNAME: fputc('\n', stdout); 
                 seenam("-  program: ", NO);
                 lc = 0;
                 goto eol;
    case  LNAME: seenam("   library: ", NO); goto eol;
    case    EXT: fputs("extension link item\n", stdout); return;

    case  CSIZE: seenam(" common sz: ", YES); goto eol;
    case XCHAIN: seenam(" ext chain: ", YES); goto eol;
    case EPOINT: seenam("  entry pt: ", YES); goto eol;

    case  DSIZE:  fputs(" data size: ", stdout); goto fld;
    case  SETLC:  fputs("   load at: ", stdout); lc = field; goto fld;
    case  CHAIN:  fputs(" ld chn at: ", stdout); goto fld;
    case  PSIZE:  fputs(" prog size: ", stdout); goto fld;

    case  EPROG:  fputs("- end prog: ", stdout); goto fld;
    case  EFILE:  fputs("- end file", stdout);   goto eol;

            fld: see16();
            eol: newlin(YES);
                 return;
    }
  itou(item, str, 6); fputs(str,  stdout);
  fputs(" is an Unknown Item Code\n", stdout);
  }

see8(value, suff) int value, suff; {	/* display 8-bits */
  char str[5];
  if(width == 0 && item < CREL) {	/* need loc ctr pref */
    itox(lc, str, 5);
    outz(str);				/* output loc ctr */
    fputc(' ', stdout);			/* output spacer */
    }
  itox(value & 255, str, 3);		/* convert to hex string */
  outz(str);				/* output hex byte */
  if(suff) fputc(suff, stdout);		/* output suffix? */
  ++width;				/* bump line width */
  }

see16() {				/* display field */
  see8(field >> 8, 0);			/* display high byte  */
  see8(field, xtype());			/* display low byte & type */
  fputc(' ', stdout);			/* output spacer */
  }

seenam(pref, val) char *pref; int val; {/* display symbol */
  newlin(YES);
  width = 1;				/* avoid address prefix */
  fputs(pref,    stdout);
  if(val) see16();			/* output a value */
  fputs(symbol,  stdout);
  }

xtype() {
  switch(type) {
    case   ABS: return(' ');
    case  PREL: return('\'');
    case  DREL: return('\"');
    case  CREL: return('~');
    case XPOFF: return('+');
    case XMOFF: return('-');
    }
  return('?');
  }

newlin(nl) int nl; {			/* decide about new line */
  if(width > 15 || (nl && width)) {
    fputc('\n', stdout);
    width = 0;
    }
  }

outz(str) char *str; {			/* zero fill and output str */
  char *cp;
  cp = str;
  while(*cp == ' ') *cp++ = '0';	/* supply leading zeroes */
  fputs(str,  stdout);
  }
