;File:	RDOS2.ASM
;Edit date:	85/11/20.
;
;	Process function 34.
;	Write random record.
;
RFWRR	EQU	$
	CALL	PDS	;select disk
;
;	WRR - Write random record.
;
WRR:	MVI	C,0	;write
	CALL	PRA	;set record from r2,r1,r0
	CZ	WSR1	;If record is accessible
	RET
;
;	ARA - Assemble record address.
;	Parse s2,ex,cr into r2,r1,r0.
;	Entry	HL = fcb fwa
;		DE = ord of byte containing cr or rc
;	Exit	ABC = record ord for this ext and cr
;		DE = fcb fwa
;
ARA:	XCHG		;HL=ord, DE=dir fwa
	DAD	D
	MOV	C,M	;BC=record count
	MVI	B,0
	LXI	H,12	;assemble eccc cccc
	DAD	D
	MOV	A,M	;ex
	RRC
	ANI	80H
	ADD	C
	MOV	C,A	;eccc cccc = r0
;
	MVI	A,0	;get any carry into B
	ADC	B
	MOV	B,A
;
	MOV	A,M	;ex
	RRC
	ANI	7FH
	ADD	B	;add any carry from r0
	MOV	B,A
;
	LXI	H,14	;position s2 bits
	DAD	D
	MOV	A,M	;s2
	RRC
	ANI	80H
	ADD	B
	MOV	B,A	;seee eeee = r1
;
	PUSH	PSW	;save carry
	MOV	A,M	;s2
	RRC
	ANI	3FH
	MOV	L,A
	POP	PSW
	MVI	A,0
	ADC	L	;00ss ssss = r2
	RET
;
;	Process function 35.
;	Compute file size.
;
RFCFS	EQU	$
	CALL	PDS	;select disk
;
;	CFS - Calculate file size.
;
CFS:	MVI	C,12	;compare FNTs through t3
	CALL	SFF	;find first occurence
	LHLD	EARGDE	;fcb fwa
	LXI	D,33	;set HL=location of r0
	DAD	D
	PUSH	H	;save loc of r0
;
	MOV M,D ! INX H	;clear r0,r1,r2
	MOV M,D ! INX H
	MOV M,D
;
CFS1:	CALL	CAI	;check advanced index
	JZ	CFS3	;If end of directory
;
;	Find end record address, this physical extent.
;
	CALL	ADE	;HL=dir entry fwa
	LXI	D,15	;rc
	CALL	ARA	;ABC=record address from s2,ex,rc
;
	POP H ! PUSH H	;HL=loc of r0
	MOV	E,A	;r2
;
;	Compare this last record ordinal with
;	last record ordinal of previous physical extent.
;
	MOV A,C ! SUB M ! INX H
	MOV A,B ! SBB M ! INX H
	MOV A,E ! SUB M
	JC	CFS2	;If previous end rec greater
;
;	The end record ordinal of this physical extent
;	is greater.  Save this record ordinal as file size.
;
	MOV M,E ! DCX H	;r2
	MOV M,B ! DCX H	;r1
	MOV M,C		;r0
;
;	Find next occurence.
;
CFS2:	CALL	SFN
	JMP	CFS1
;
CFS3:	POP	H	;clear stack
	RET
;
;	Process function 36.
;	Set random record.
;	Entry	DE = fcb fwa
;
RFSRR	EQU	$
	XCHG		;HL=fcb fwa
	LXI	D,32	;cr
	CALL	ARA	;ABC=record address from s2,ex,cr
	LXI	H,33	;point to r0
	DAD	D
	MOV M,C ! INX H	;r0
	MOV M,B ! INX H	;r1
	MOV M,A		;r2
	RET
;
;	PDS - Process disk select.
;
PDS:	MVI	A,0FFH	;mark PDS called
	STA	PDSCF
	LHLD	EARGDE	;fcb fwa
	MOV	A,M	;fcb(0)
	ANI	1FH
	DCR	A
	STA	EARGE
	CPI	1EH
	JNC	PDS1	;If no autoselect
;
	LDA	CDISK	;save current disk
	STA	ASEL
	MOV	A,M	;save original fcb(0)
	STA	FCBZ
	ANI	0E0H	;clear user number bits
	MOV	M,A
	CALL	SEL	;set CDISK=EARGE and select it
;
;	Put user number into fcb(0).
;
PDS1:	LDA	CUSER	;current user
	LHLD	EARGDE
	ORA	M
	MOV 	M,A
	RET
;
;	Process function 12.
;	Get system version number.
;	Exit	 H = 00
;		 L = RDOS version "2.2"
;
RFGVN	EQU	$
	LXI	H,00 SHL 8 OR 22H	;8/00, 8/"2.2"
	JMP	RWV
;
;	Process function 13.
;	Disk system reset.
;
RFRRT	EQU	$
	LHLD	HDVEC	;clear log-in & r/o vectors
	CALL	CDV
;
	XRA	A	;select disk "A"
	STA	CDISK
	LXI	H,RBUF	;set default buffer
	SHLD	USRDMA
	CALL	RUA	;set DMA
	JMP	LDC	;go log in CDISK
;
;	Process function 15.
;	Open file.
;
RFOPN	EQU	$
	CALL	CS2	;clear fcb byte s2
	CALL	PDS	;select disk
	JMP	OPN	;go process open
;
;	Process function 16.
;	Close file.
;
RFCLO	EQU	$
	CALL	PDS	;select disk
	JMP	CLO	;go process close
;
;	SCL - Set compare length.
;	Exit	 C = FNT compare length
;		 Z = true, if ambiguous extent
;
SCL:	CALL	AEX	;HL=.fcb ex
	MOV	A,M
	CPI	3FH
	MVI	C,1+8+3+3	;compare FNTs through s2
	RNZ			;If not ambiguous extent
;
;	Process ambiguous extent.
;
	MVI	C,1+8+3		;compare FNTs through t3
	RET
;
;	Process function 17.
;	Search for first occurence.
;
RFSFF	EQU	$
	LDAX	D	;fcb(0)
	SUI	'?'
	CZ	WPD1	;If full search required
;
;	Note: WPD1 sets logical dir end = physical end.
;	User should log out the disk to restore logical
;	dir end = end of active entries.
;
;	Also, the return every entry mode does not
;	provide autoselect; only the current disk
;	can be accessed.
;
	MOV	C,A	;force a hit on every entry
	JZ	RFSFF1	;If return every entry
;
;	Process normal directory scan.
;
	CALL	PDS	;select disk
	CALL	SCL	;C=compare length
	CNZ	CS2	;If not ambiguous ext, clear s2
;
RFSFF1	EQU	$
	CALL	SFF	;find first occurence
	JMP	MDB	;go move dirbuf to user buf
;
;	Process function 18.
;	Search for next occurence.
;
RFSFN	EQU	$
	LHLD	FSFCB	;restore fcb fwa
	SHLD	EARGDE
	CALL	PDS	;select disk
	CALL	SFN	;find next occurence
	JMP	MDB	;go move dirbuf to user buf
;
;	Process function 19.
;	Delete file.
;
RFDEL	EQU	$
	CALL	PDS	;select disk
	CALL	DEL	;mark entries inactive
	JMP	RFF	;return with file-found flag
;
;	Process function 20.
;	Read sequential.
;
RFRSR	EQU	$
	CALL	PDS	;select disk
	JMP	RSR	;read sequential record
;
;	Process function 21.
;	Write sequential.
;
RFWSR	EQU	$
	CALL	PDS	;select disk
	JMP	WSR	;write sequential record
;
;	Process function 22.
;	Create new file.
;
RFCNF	EQU	$
	CALL	CS2	;clear fcb byte s2
	CALL	PDS	;select disk
	JMP	CNF	;create file
;
;	Process function 24.
;	Return log-in vector.
;
RFRLV	EQU	$
	LHLD	LGVEC
	JMP	RWV	;return word value
;
;	Process function 25.
;	Return current disk.
;
RFRCD	EQU	$
	LDA	CDISK
	JMP	RBV	;return byte value
;
;	Process function 26.
;	Set DMA.
;	Entry	DE = .buffer
;	Returns	HL = previous DMA
;
RFDMA	EQU	$
	LHLD	USRDMA
	SHLD	RARGHL
	XCHG
	SHLD	USRDMA
	JMP	RUA	;set DMA
;
;	Process function 27.
;	Return RBR address.
;
RFGRA	EQU	$
	LHLD	RBRLOC
	JMP	RWV	;return word value
;
;	Process function 29.
;	Return read-only vector.
;	Returns	HL = read-only vector
;		DE = .dirord
;
RFGRO	EQU	$
	LXI	D,DIRORD
	LHLD	ROVEC
	JMP	RWV	;return word value
;
;	Process function 30.
;	Set file attributes.
;
RFSAT	EQU	$
	CALL	PDS	;select disk
	CALL	SAT	;set attributes
	JMP	RFF	;return file-found flag
;
;	Process function 31.
;	Return disk parameter block address.
;	Returns	HL = .DPB
;		DE = ..directory buffer
;
RFDPB	EQU	$
	LXI	D,DIRLOC
	LHLD	DPBLOC
;
;	RWV - Return word value.
;
RWV:	SHLD	RARGA
	RET
;
;	RBV - Return byte value.
;
RBV1:	MVI	A,1	;return A=1
RBV:	STA	RARGA
;
;	Process undefined function.
;
RFUND	EQU	$
	RET
;
;	Process function 32.
;	Set or get user number.
;
RFPUN	EQU	$
	MOV	A,C
	CPI	0FFH
	JNZ	RFPUN1	;If set user
;
;	Get user number.
;
	LDA	CUSER	;current user number
	JMP	RBV	;return byte value
;
;	Set user number.
;
RFPUN1:	ANI	1FH	;save 5 bits
	STA	CUSER
	RET
;
;	Process function 37.
;	Log out disk drive.
;	Entry	DE = drives vector
;
RFCLV	EQU	$
	XCHG		;HL=vec w/bits to clear
;
;	CDV - Clear drive vectors.
;	Entry	HL = mask w/bits set to clear
;
CDV:	MOV A,L ! CMA ! MOV E,A	;form clear mask in AE
	MOV A,H ! CMA
	LHLD	LGVEC
	ANA H ! MOV D,A
	MOV A,L ! ANA E ! MOV E,A
;
;	Now clear corresponding bits of
;	the read-only vector.
;
	LHLD	ROVEC
	XCHG
	SHLD	LGVEC
	MOV A,L ! ANA E ! MOV L,A
	MOV A,H ! ANA D ! MOV H,A
	SHLD	ROVEC
	RET
;
;	Process function 38.
;	Set display page size.
;
RFPAG	EQU	$
	MOV	D,E	;set line count=page size
	XCHG
	SHLD	LINEC
	RET
;
;	Process function 40.
;	Write random with zero fill.
;
RFWRZ	EQU	$
	CALL	PDS	;select disk
	MVI	A,2	;indicate zero fill
	STA	ACFLAG
	MVI	C,0	;write flag
	CALL	PRA1	;process random address
	CZ	WSR1	;If record accessible
	RET
;
;	Return to calling user program.
;
RTC:	LDA	PDSCF	;check disk operation done
	ORA	A
	JZ	RTC1	;If no disk select performed
;
;	A disk operation was performed.
;
	XRA	A
	STA	DIRAC	;deselect directory access
	IF	USRCOM
	STA	CSFNA	;restore cross-user access
	ENDIF
;
;	Check autoselect.
;
	LHLD	EARGDE	;clear fcb(0)
	MOV	M,A
	LDA	FCBZ	;original fcb(0)
	ORA	A
	JZ	RTC1	;If no autoselect
;
;	An auto select operation was processed.
;	Go back to original current disk.
;
	MOV	M,A	;restore original fcb(0)
	LDA	ASEL	;reselect original CDISK
	STA	EARGE
	CALL	SEL
;
;	Return to the user's program.
;
RTC1:	LHLD	OLDSP	;restore user's stack
	SPHL
	LHLD	RARGA	;return byte or word value
	MOV	A,L
	MOV	B,H
	RET
;
;
;	RDOS data space.
;
EMPTY:	DB	0E5H	;empty directory image
ROVEC:	DW	0	;read-only vector
LGVEC:	DW	0	;log-in vector
USRDMA:	DW	RBUF	;user's DMA
;
DTMP1:	DW	0	;logical end of directory
DIRLOC:	DW	0	;directory buffer fwa
DPBLOC:	DW	0	;disk parameter block fwa
CSVLOC:	DW	0	;checksum vector fwa
RBRLOC:	DW	0	;record blk reservation table fwa
;
;	Following values filled from DPB for current disk.
;
DPBFWA	EQU	$
DPBSPT:	DW	0	;sectors per track
DPBBSH:	DB	0	;block shift
DPBBLM:	DB	0	;block mask
DPBEXM:	DB	0	;extent mask
DPBDSM:	DW	0	;disk size=max blk number
DPBDRM:	DW	0	;directory size=max dir ord
DPBALB:	DW	0	;directory blks res bits
DPBCKS:	DW	0	;checksize=dir records checksummed
DPBOFF:	DW	0	;offset=number of system tracks
XLTAB:	DW	0	;sector skew table fwa
;
ENEXM:	DB	0	;enable ext mask (see AFX)
RDSEQ:	DB	0	;00=read seq  FF=write seq
ACFLAG:	DB	0	;access flag 0=ran 1=seq 2=zerofill
;
EARGE:	DB	0	;save entry argument, register E
RBTORD:	DB	0	;RBT ord within dir entry
FSLEN:	DB	0	;number of FNT char compared
FFFLAG:	DB	0	;FF=file not found
FSFCB:	DW	0	;save fcb fwa
;
RBTBF:	DB	0	;00=RBT words  FF=RBT bytes
PDSCF:	DB	0	;PDS called flag
FCBZ:	DB	0	;save fcb(0) during autoselect
ASEL:	DB	0	;save CDISK during autoselect
;
FCBRC:	DB	0	;record count=fcb(15)
LEXT:	DB	0	;logical ext=ext.and.ext mask
FCBCR:	DB	0	;current record=fcb(33)
;
RBTENT:	DW	0	;RBT entry, also record ordinal
DRORD:	DB	0,0,0	;disk record ordinal
DBINDX:	DB	0	;0,1,2, or 3 *32=ord in dir buf
RECORD:	DW	0	;record ordinal
;
;	Force an assembly error if RDOS larger than stated.
;
BIOTST	EQU	(($-1) AND 0FF00H) + 100H
SIZERR	EQU	BIOFWA-BIOTST
	IF	SIZERR
	RDOS size is other than stated.
	ENDIF
