/* mpeg2dec.c, main(), initialization, option processing                    */

/* Copyright (C) 1994, MPEG Software Simulation Group. All Rights Reserved. */

/*
 * Disclaimer of Warranty
 *
 * These software programs are available to the user without any license fee or
 * royalty on an "as is" basis.  The MPEG Software Simulation Group disclaims
 * any and all warranties, whether express, implied, or statuary, including any
 * implied warranties or merchantability or of fitness for a particular
 * purpose.  In no event shall the copyright-holder be liable for any
 * incidental, punitive, or consequential damages of any kind whatsoever
 * arising from the use of these programs.
 *
 * This disclaimer of warranty extends to the user of these programs and user's
 * customers, employees, agents, transferees, successors, and assigns.
 *
 * The MPEG Software Simulation Group does not represent or warrant that the
 * programs furnished hereunder are free of infringement of any third-party
 * patents.
 *
 * Commercial implementations of MPEG-1 and MPEG-2 video, including shareware,
 * are subject to royalty fees to patent holders.  Many of these patents are
 * general enough such that they are unavoidable regardless of implementation
 * design.
 *
 */

// MS Windows includes
#include <windows.h>
#include <commdlg.h>
#include <assert.h>
#include <io.h>
#include "gui.h"
#define APPNAME            "Mpeg2Play"    /* The name of this application */
#define BASEWINDOWTITLE    "MPEG2 Software Simulation" /* The title bar text */
#define MAXFILENAME        256           /* maximum length of file pathname      */
#define MAXCUSTFILTER      40            /* maximum size of custom filter buffer */
// display related variables
#define		START	    0
#define		READY	    1
#define   PLAYING   2
#define   PAUSED    3
#define   FINISH    4
#define		STOP	    5


#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <fcntl.h>

#define GLOBAL
#include "config.h"
#include "global.h"

// MS Windows related variables
LRESULT CALLBACK WndProc(HWND   hWnd,       // window handle
                         UINT   message,    // type of message
                         WPARAM uParam,     // additional information
                         LPARAM lParam);    // additional information
static HINSTANCE   hInst;          // current instance
static HWND        ghWnd   =NULL;  // handle to main window
static char       *image   =NULL;
static char        szFileName[MAXFILENAME]="";
static unsigned short gusState = START;
static int         nDitherType;
static HDC         hDC;
static HPALETTE    hpal,
                   hPalPrev=NULL;
static PBITMAPINFO pbmi    =NULL;

static void play_movie(void);
extern int         __argc;
extern char      **__argv;

/* private prototypes */
static void initdecoder _ANSI_ARGS_((void));
static void options _ANSI_ARGS_((int *argcp, char **argvp[]));
static int getval _ANSI_ARGS_((char *argv[]));


// MS Windows related functions
/////////////////////////////////////////////////////////////////////////////
/*
 *********************************************************************************
 *
 * WinMain:
 *
 *********************************************************************************
*/

//
// yield function to simulate multitasking on MS Windows
//
static void myYield(void)
{
    MSG		msg;

    if (PeekMessage(&msg, NULL, 0, 0, PM_REMOVE))
    {
	    TranslateMessage(&msg);// Translates virtual key codes
	    DispatchMessage(&msg); // Dispatches message to window
	}
}

//
// initializations
//
static BOOL InitApplication(HINSTANCE hInstance)
{
   WNDCLASS  wc;

   // Fill in window class structure with parameters that describe the
   // main window.

   wc.style         = CS_OWNDC | CS_HREDRAW | CS_VREDRAW;// Class style(s).
   wc.lpfnWndProc   = (WNDPROC)WndProc;           // Window Procedure
   wc.cbClsExtra    = 0;                          // No per-class extra data.
   wc.cbWndExtra    = 0;                          // No per-window extra data.
   wc.hInstance     = hInstance;                  // Owner of this class
   wc.hIcon         = LoadIcon (hInstance, APPNAME); // Icon name from .RC
   wc.hCursor       = LoadCursor(NULL, IDC_ARROW);// Cursor
   wc.hbrBackground = (HBRUSH)(COLOR_WINDOW+1);   // Default color
   wc.lpszMenuName  = APPNAME;                    // Menu name from .RC
   wc.lpszClassName = APPNAME;                    // Name to register as

   // Register the window class and return success/failure code.
   return (RegisterClass(&wc));
}

static BOOL InitInstance(HINSTANCE hInstance,int       nCmdShow)
{

    // Save the instance handle in static variable, which will be used in
    // many subsequence calls from this application to Windows.

    hInst = hInstance; // Store instance handle in our global variable

    // Create a main window for this application instance.

    ghWnd = CreateWindow(APPNAME,            // See RegisterClass() call.
                         BASEWINDOWTITLE,    // Text for window title bar.
                         WS_OVERLAPPEDWINDOW &
                         ~WS_THICKFRAME &
                         ~WS_MAXIMIZEBOX,    // Window style.
                         CW_USEDEFAULT,
                         0,
                         CW_USEDEFAULT,
                         0,                  // Use default positioning
                         NULL,               // Overlapped windows have no parent.
                         NULL,               // Use the window class menu.
                         hInstance,          // This instance owns this window.
                         NULL                // We don't use any data in our WM_CREATE
        );

    // If window could not be created, return "failure"
    if (!ghWnd)
       return (FALSE);

    // Make the window visible; update its client area; and return "success"
    ShowWindow(ghWnd, nCmdShow); // Show the window
    UpdateWindow(ghWnd);         // Sends WM_PAINT message

    return (TRUE);              // We succeeded...

}

//
// prompts the user for the efile name
//
static BOOL AskUserFileName(char szFileName[],char szFileTitle[])
{
   /* new variables for common dialogs */
   static char         szFilterSpec[]="MPEG2 Video Files\0*.M2V\0MPEG1 Video Files\0*.M1V\0MPEG Files\0*.MPG\0All Files (*.*)\0*.*\0";
   static char         szInitialDirectory[MAXFILENAME]="";
          OPENFILENAME ofn;

   memset(&ofn,0,sizeof(ofn));

   /* fill in non-variant fields of OPENFILENAME struct. */
   ofn.lStructSize       = sizeof(OPENFILENAME);
   ofn.hwndOwner         = ghWnd;
   ofn.lpstrFilter       = szFilterSpec;
   ofn.lpstrCustomFilter = NULL;
   ofn.nMaxCustFilter    = 0;
   ofn.nFilterIndex      = 0;
   ofn.lpstrFile         = szFileName;
   ofn.nMaxFile          = MAXFILENAME;
   if (!szInitialDirectory[0])
      GetModuleFileName(hInst, szInitialDirectory, MAXFILENAME);

   // strip the file name
   *(LPSTR)strrchr(szInitialDirectory,'\\')=0;

   ofn.lpstrInitialDir     = szInitialDirectory;
   ofn.lpstrFileTitle      = szFileTitle;
   ofn.nMaxFileTitle       = MAXFILENAME;
   ofn.lpstrTitle          = NULL;
   ofn.lpstrDefExt         = "MPG";
   ofn.Flags               = 0;

   if (!GetOpenFileName ((LPOPENFILENAME)&ofn))
      return FALSE;

   // save the current directory
   lstrcpy(szInitialDirectory,szFileName);
   return TRUE;
}


/*********************************************************************************
 *
 * About box
 *
*********************************************************************************
*/

BOOL CALLBACK About(HWND   hDlg,         // window handle of the dialog box
                    UINT   message,      // type of message
                    WPARAM uParam,       // message-specific information
                    LPARAM lParam)
{
   switch (message)
   {
      case WM_COMMAND:                     // message: received a command
         if (LOWORD(uParam) == IDOK || LOWORD(uParam) == IDCANCEL)
         {
            EndDialog(hDlg, TRUE);        // Exit the dialog
            return (TRUE);
         }
         break;
   }
   return (FALSE); // Didn't process the message

   lParam; // This will prevent 'unused formal parameter' warnings
}

//
// Main window procedure
//
LRESULT CALLBACK WndProc(HWND   hWnd,       // window handle
                         UINT   message,    // type of message
                         WPARAM uParam,     // additional information
                         LPARAM lParam)     // additional information
{
   switch (message)
   {
      case WM_CLOSE:
	    gusState = STOP;
	    myYield();
      return (DefWindowProc(hWnd, message, uParam, lParam));
	    break;


      case WM_DESTROY:  // message: window being destroyed
	    gusState = STOP;
	    myYield();
      PostQuitMessage(0);
      break;

      case WM_COMMAND:  // message: command from application menu
      {
        int wmId, wmEvent;

        wmId    = LOWORD(uParam);
        wmEvent = HIWORD(uParam);

        switch (wmId)
        {
           case IDM_OPEN:
           {
              char szWindowTitle[80];
              char szFileTitle[MAXFILENAME];

               // if something was playing, give a chance to stop.
              if (gusState > READY)
              {
                 gusState = STOP;
                 myYield();
              }

              EnableMenuItem(GetMenu(hWnd), IDM_PLAY, MF_GRAYED | MF_DISABLED);

              szFileName[0]=0;
              if (!AskUserFileName (szFileName,szFileTitle))
                 return FALSE;

              lstrcpy(szWindowTitle, BASEWINDOWTITLE);
              lstrcat(szWindowTitle, " - ");
              lstrcat(szWindowTitle, szFileTitle);
              SetWindowText(hWnd, szFileTitle);

              // enable play menu
              EnableMenuItem(GetMenu(hWnd), IDM_PLAY, MF_ENABLED);

              gusState = READY;
              break;
           }

           case IDM_PLAY:
              // disable play menu while playing
              EnableMenuItem(GetMenu(hWnd), IDM_STOP, MF_ENABLED);
              EnableMenuItem(GetMenu(hWnd), IDM_PLAY, MF_GRAYED | MF_DISABLED);

              // play the movie. It returns after the playing ended
              play_movie();

              // disable stop menu
              EnableMenuItem(GetMenu(hWnd), IDM_STOP, MF_GRAYED | MF_DISABLED);
              EnableMenuItem(GetMenu(hWnd), IDM_PLAY, MF_ENABLED);
              SetWindowText(hWnd, BASEWINDOWTITLE);
              break;

           case IDM_STOP:
              gusState=STOP;
              // force a task switch to allow the decoder to see the stop command
              myYield();
              break;

           case IDM_EXIT:
              SendMessage(hWnd, WM_CLOSE, 0, 0l);
              break;

           case IDM_ABOUT:
           {
              FARPROC lpProcAbout;  // pointer to the "About" function

              lpProcAbout = MakeProcInstance((FARPROC)About, hInst);
              DialogBox(hInst,                 // current instance
                        "AboutBox",            // dlg resource to use
                        hWnd,                  // parent handle
                        (DLGPROC)lpProcAbout); // About() instance address

              FreeProcInstance(lpProcAbout);
              break;
           }

           case IDM_YUV_FILE:
           case IDM_Y_U_V_FILE:
           case IDM_TGA_FILE:
           case IDM_DISPLAY8:
           case IDM_DISPLAY24:
              // reset the display.
              // It will be reinitialized the first time it will be called
              switch (outtype)
              {
                 case T_YUV:
                   CheckMenuItem(GetMenu(hWnd), IDM_YUV_FILE, MF_UNCHECKED);
                   break;

                 case T_SIF:
                   CheckMenuItem(GetMenu(hWnd), IDM_Y_U_V_FILE, MF_UNCHECKED);
                   break;

                 case T_TGA:
                   CheckMenuItem(GetMenu(hWnd), IDM_TGA_FILE, MF_UNCHECKED);
                   break;

#ifdef DISPLAY
                 case T_X11:
                   if (nDitherType==8)
                      CheckMenuItem(GetMenu(hWnd), IDM_DISPLAY8, MF_UNCHECKED);
                   else
                      CheckMenuItem(GetMenu(hWnd), IDM_DISPLAY24, MF_UNCHECKED);
                   break;
#endif
              }
              switch (wmId)
              {
                 case IDM_YUV_FILE:
                    CheckMenuItem(GetMenu(hWnd), IDM_YUV_FILE, MF_CHECKED);
                    outtype=T_YUV;
                    break;

                 case IDM_Y_U_V_FILE:
                    CheckMenuItem(GetMenu(hWnd), IDM_Y_U_V_FILE, MF_CHECKED);
                    outtype=T_SIF;
                    break;

                 case IDM_TGA_FILE:
                    CheckMenuItem(GetMenu(hWnd), IDM_TGA_FILE, MF_CHECKED);
                    outtype=T_TGA;
                    break;

#ifdef DISPLAY
                 case IDM_DISPLAY8:
                    CheckMenuItem(GetMenu(hWnd), IDM_DISPLAY8, MF_CHECKED);
                    outtype=T_X11;
                    nDitherType=8;
                    break;

                 case IDM_DISPLAY24:
                    CheckMenuItem(GetMenu(hWnd), IDM_DISPLAY24, MF_CHECKED);
                    outtype=T_X11;
                    nDitherType=24;
                    break;
#endif
              }
        }
        break;
      }

      default:          // Passes it on if unproccessed
        return (DefWindowProc(hWnd, message, uParam, lParam));
   }
   return (0);
}

//
// program entry point
//
int APIENTRY WinMain(HINSTANCE   hInstance,
                     HINSTANCE   hPrevInstance,
                     LPSTR       lpCmdLine,
                     int         nCmdShow)
{
    MSG msg;

    if (!hPrevInstance)
       // Other instances of app running?
        if (!InitApplication(hInstance))
           // Initialize shared things
           return (FALSE);     // Exits if unable to initialize

    /* Perform initializations that apply to a specific instance */
    if (!InitInstance(hInstance, nCmdShow))
       return (FALSE);


    // start-up initialization
    verbose = 0;
#ifdef DISPLAY
    outtype = T_X11;
    hDC     = GetDC(ghWnd);
    if (GetDeviceCaps(hDC,BITSPIXEL)>=24)
    {
       CheckMenuItem(GetMenu(ghWnd), IDM_DISPLAY24, MF_CHECKED);
       nDitherType=24;
    }
    else
    {
       CheckMenuItem(GetMenu(ghWnd), IDM_DISPLAY8, MF_CHECKED);
       nDitherType=8;
    }
#else
    outtype=T_YUV;
    CheckMenuItem(GetMenu(ghWnd), IDM_YUV_FILE, MF_CHECKED);
#endif
    framestoreflag = 1;
    sflag = 0;
    refidct = 0;
    ld = &base; /* select base layer context */

    options(&__argc,&__argv);

#ifdef DISPLAY
    if (outtype==T_X11)
       outputname = "";
    else
#endif
       outputname="rec%d";

    /* Acquire and dispatch messages until a WM_QUIT message is received. */
    while (GetMessage(&msg, // message structure
                      NULL,   // handle of window receiving the message
                      0,      // lowest message to examine
                      0))     // highest message to examine
    {
        TranslateMessage(&msg);// Translates virtual key codes
        DispatchMessage(&msg); // Dispatches message to window
    }

    return (msg.wParam); // Returns the value from PostQuitMessage

    lpCmdLine; // This will prevent 'unused formal parameter' warnings
}

#ifdef DISPLAY
//
// display initialization
//
extern int convmat[8][4]; // defined in display.c

static void init_display(void)
{
  pbmi    = (PBITMAPINFO)malloc(sizeof(BITMAPINFOHEADER) + 240 * sizeof(RGBQUAD));
  pbmi->bmiHeader.biSize = (LONG)sizeof(BITMAPINFOHEADER);
  pbmi->bmiHeader.biPlanes = 1;
  pbmi->bmiHeader.biCompression = 0l;
  pbmi->bmiHeader.biSizeImage = 0l;
  pbmi->bmiHeader.biXPelsPerMeter = 0l;
  pbmi->bmiHeader.biYPelsPerMeter = 0l;
  pbmi->bmiHeader.biClrUsed = 240;
  pbmi->bmiHeader.biClrImportant = 240;
  pbmi->bmiHeader.biBitCount = nDitherType;
  pbmi->bmiHeader.biWidth = coded_picture_width ;
  pbmi->bmiHeader.biHeight= coded_picture_height;
  if ( pbmi->bmiHeader.biBitCount==8 )
  {
     // for 8 BPP, build the color palette

     LOGPALETTE *plgpl;
     short      *pPalIndex;
     int         crv, cbu, cgu, cgv;
     int         y, u, v;
     int         i;

     plgpl = (LOGPALETTE*) malloc(sizeof(LOGPALETTE) + 240 * sizeof(PALETTEENTRY));
     plgpl->palNumEntries = 240;
     plgpl->palVersion = 0x300;
     pPalIndex=(short *)pbmi->bmiColors;

     /* matrix coefficients */
     crv = convmat[matrix_coefficients][0];
     cbu = convmat[matrix_coefficients][1];
     cgu = convmat[matrix_coefficients][2];
     cgv = convmat[matrix_coefficients][3];

     for (i=16; i<240; i++)
     {
       /* color space conversion */
       y = 16*((i>>4)&15) + 8;
       u = 32*((i>>2)&3)  - 48;
       v = 32*(i&3)       - 48;

       y = 76309 * (y - 16); /* (255/219)*65536 */

       plgpl->palPalEntry[i].peRed   = clp[(y + crv*v + 32768)>>16];
       plgpl->palPalEntry[i].peGreen = clp[(y - cgu*u -cgv*v + 32768)>>16];
       plgpl->palPalEntry[i].peBlue  = clp[(y + cbu*u + 32786)>>16];
       pPalIndex[i]=i;
     }
     hpal = CreatePalette(plgpl);
     free(plgpl);
     hPalPrev=SelectPalette(hDC,hpal,FALSE);
     RealizePalette(hDC);
  }
}

//
// display clean-up
//
static void exit_display()
{
   if (pbmi)
   {
      free(pbmi);
      pbmi=NULL;
   }
   if (hPalPrev)
   {
       SelectPalette(hDC,hPalPrev,FALSE);
       DeleteObject(hpal);
       hPalPrev=NULL;
   }
}

//
// display the image on the MS Windows screen
//
void display_image(dithered_image)
unsigned char *dithered_image;
{
  /* display dithered image */
  SetDIBitsToDevice(hDC,0,0,coded_picture_width,coded_picture_height,
                     0,0,0,coded_picture_height,dithered_image,pbmi,DIB_PAL_COLORS);
}
#endif


//
// decode a file and store and/or display it
//
static void play_movie(void)
{
  int framenum;

  /* open MPEG input file(s) */
  if ((base.infile=open(szFileName,O_RDONLY|O_BINARY))<0)
  {
    sprintf(errortext,"Input file %s not found\n",szFileName);
    error(errortext);
  }

  initbits();

  if (getheader())
  {
    RECT wr,cr;
    int  d;

    // size window to film size
    SetRect(&cr,0,0,horizontal_size,vertical_size);
    wr=cr;
    AdjustWindowRect(&wr,GetWindowLong(ghWnd,GWL_STYLE),TRUE);
    OffsetRect(&wr,-wr.left,-wr.top);
    SetWindowPos(ghWnd,HWND_TOP,0,0,wr.right,wr.bottom,SWP_NOMOVE);

    // for QSIF movies the menu will wrap around so we need
    // to increase the height of the window
    GetClientRect(ghWnd, &wr);
    d=cr.bottom-(wr.bottom-wr.top);
    if (d>0)
    {
       GetWindowRect(ghWnd, &wr);
       SetWindowPos(ghWnd,HWND_TOP,0,0,wr.right-wr.left,wr.bottom-wr.top+d,SWP_NOMOVE);
    }

    initdecoder();

    if (outtype==T_X11)
    {
      init_dither(nDitherType);
      init_display();
    }

    framenum = 0;

    do
    {
      getpicture(framenum);

      if (!secondfield)
         framenum++;

      // give the user a chance to perform something
      myYield();
      if (gusState==STOP)
         break;
    }
    while (getheader());

    if (framenum!=0)
    {
      /* put last frame */
      putlast(framenum);
    }

    if (outtype==T_X11)
      exit_display();
  }

  close(base.infile);
}

/////////////////////////////////////////////////////////////////////
//
// MPEG related functions
//
// (portable)
//
static void initdecoder()
{
  int i, cc, size;
  static int blk_cnt_tab[3] = {6,8,12};

  /* check scalability mode of enhancement layer */
  if (twostreams && enhan.scalable_mode!=SC_SNR &&
     !(base.scalable_mode==SC_DP && base.scalable_mode==SC_DP))
    error("unsupported scalability mode\n");

  /* clip table */
  if (!(clp=(unsigned char *)malloc(1024)))
    error("malloc failed\n");

  clp += 384;

  for (i=-384; i<640; i++)
    clp[i] = (i<0) ? 0 : ((i>255) ? 255 : i);

  /* force MPEG-1 parameters */
  if (!base.mpeg2)
  {
    prog_seq = 1;
    prog_frame = 1;
    pict_struct = FRAME_PICTURE;
    frame_pred_dct = 1;
    chroma_format = CHROMA420;
    matrix_coefficients = 5;
  }

  /* round to nearest multiple of coded macroblocks */
  mb_width = (horizontal_size+15)/16;
  mb_height = (base.mpeg2 && !prog_seq) ? 2*((vertical_size+31)/32)
                                        : (vertical_size+15)/16;
  coded_picture_width = 16*mb_width;
  coded_picture_height = 16*mb_height;

  chrom_width = (chroma_format==CHROMA444) ? coded_picture_width
                                           : coded_picture_width>>1;
  chrom_height = (chroma_format!=CHROMA420) ? coded_picture_height
                                            : coded_picture_height>>1;
  blk_cnt = blk_cnt_tab[chroma_format-1];

  for (cc=0; cc<3; cc++)
  {
    if (cc==0)
      size = coded_picture_width*coded_picture_height;
    else
      size = chrom_width*chrom_height;

    if (!(refframe[cc] = (unsigned char *)malloc(size)))
      error("malloc failed\n");

    if (!(oldrefframe[cc] = (unsigned char *)malloc(size)))
      error("malloc failed\n");

    if (!(auxframe[cc] = (unsigned char *)malloc(size)))
      error("malloc failed\n");

    if (base.scalable_mode==SC_SPAT)
    {
      /* this assumes lower layer is 4:2:0 */
      if (!(llframe0[cc] = (unsigned char *)malloc((llw*llh)/(cc?4:1))))
        error("malloc failed\n");
      if (!(llframe1[cc] = (unsigned char *)malloc((llw*llh)/(cc?4:1))))
        error("malloc failed\n");
    }
  }

  if (base.scalable_mode==SC_SPAT)
  {
    if (!(lltmp = (short *)malloc(llw*((llh*vn)/vm)*sizeof(short))))
      error("malloc failed\n");
  }

  /* IDCT */
  if (refidct)
    init_idctref();
  else
    init_idct();
}

void error(text)
char *text;
{
  fprintf(stderr,text);
  exit(1);
}

/* compliance warning messages to user, but don't exit() */
void warning(text)
char *text;
{
  if (!quiet)
  {
    fprintf(stderr,"%s\n",text);
  }
}

/* trace output */
void printbits(code,bits,len)
int code,bits,len;
{
  int i;
  for (i=0; i<len; i++)
    printf("%d",(code>>(bits-1-i))&1);
}

/* option processing */
static void options(argcp,argvp)
int *argcp;
char **argvp[];
{
  while (*argcp>1 && (*argvp)[1][0]=='-')
  {
    while ((*argvp)[1][1])
    {
      switch (toupper((*argvp)[1][1]))
      {
      case 'V':
        verbose = getval(*argvp);
        break;
      case 'O':
        outtype = getval(*argvp);
#ifdef DISPLAY
        if (outtype==T_X11HIQ)
        {
          hiQdither = 1;
          outtype=T_X11;
        }
#endif
        break;
      case 'F':
        framestoreflag = 1;
        break;
      case 'S':
        sflag = 1;
        break;
      case 'R':
        refidct = 1;
        break;
      case 'T':
        trace = 1;
        break;
      case 'Q':
        quiet = 1;
        break;
      default:
        fprintf(stderr,"undefined option -%c ignored\n",(*argvp)[1][1]);
      }

      (*argvp)[1]++;
    }

    (*argvp)++;
    (*argcp)--;
  }

  if (sflag)
  {
    /* input file for spatial prediction */
    llinputname = (*argvp)[1];
    (*argvp)++;
    (*argcp)--;
  }

#ifdef DISPLAY
  if (outtype==T_X11)
  {
    framestoreflag = 1; /* two avoid calling dither() twice */
    (*argcp)++; /* fake outfile parameter */
  }
#endif

#if 0
  if (*argcp!=3 && *argcp!=4)
  {
    printf("\n%s, %s\n",version,author);
    printf("Usage:   mpeg2decode {options} input.m2v {upper.m2v} {outfile}\n\
Options: -vn  verbose output (n: level)\n\
         -on  output format (0: YUV, 1: SIF, 2: TGA, 3:PPM, 4:X11, 5:X11 HiQ)\n\
         -f   store interlaced video in frame format\n\
         -q   disable warnings to stderr\n\
         -r   use double precision reference IDCT\n\
         -s infile  spatial scalable sequence\n\
         -t   enable low level tracing\n");
    exit(0);
  }
#endif
}

static int getval(argv)
char *argv[];
{
  int val;

  if (sscanf(argv[1]+2,"%d",&val)!=1)
    return 0;

  while (isdigit(argv[1][2]))
    argv[1]++;

  return val;
}

