		PAGE	58,132
		TITLE	BOOT_HD
;****************************************************************
;*
;*	BOOT_HD
;*
;****************************************************************

DSKIO		EQU	1DH
CONFIG_PAR	EQU	1FE0H
IPL_PAR		EQU	1FA0H
SYS_SEL		EQU	517H
DISK_BOOT	EQU	402H

BOOT		SEGMENT	PARA PUBLIC 'CODE'
		ASSUME	CS:BOOT
BOOT_HD		PROC	FAR
;
;		JMP	NEAR PTR BOOT_START
;
		DB	0E9H
		DW	(OFFSET BOOT_START) - ($+2)
;
;	DATA AREA
;
SS_BOOT		DW	0
SP_BOOT		DW	0
AX_BOOT		DW	0

RTRY		DB	0

IPL		DW	0
		DW	IPL_PAR

;
;	CODE AREA
;
BOOT_START:
;
;	SAVE REGISTER
;
		MOV	CS:SS_BOOT,SS
		MOV	CS:SP_BOOT,SP
		MOV	CS:AX_BOOT,AX
		MOV	AX,CS
		MOV	SS,AX
		MOV	SP,512
		PUSH	CS:AX_BOOT
		PUSH	BX
		PUSH	CX
		PUSH	DX
		PUSH	SI
		PUSH	DI
		PUSH	BP
		PUSH	DS
		PUSH	ES
		XOR	AX,AX		; CS,SS = CS
		MOV	DS,AX		; DS = 0
;
;	READ VOLUME INFORMATION
;
		MOV	AX,CONFIG_PAR
		MOV	ES,AX
		MOV	BX,512
		MOV	BP,0
		MOV	CX,1
		MOV	DX,0
		CALL	READ_HD
		JNC	BT1
		ADD	CX,17
		CALL	READ_HD
		JC	RETURN
BT1:
;
;	SELECT VOLUME
;
		MOV	AL,DS:SYS_SEL
		AND	AL,AL
		JZ	BT3
		CMP	AL,13
		JNC	RETURN
;
;	UPDATE VOLUME INFORMATION
;
		MOV	ES:[BP+1],AL
		MOV	CX,1
		CALL	WRITE_HD
		ADD	CX,17
		CALL	WRITE_HD
		MOV	AL,DS:SYS_SEL
		JMP	SHORT BT2
;
BT3:
		MOV	AL,ES:[BP+1]
		AND	AL,AL
		JZ	RETURN
BT2:
		MOV	AH,32
		MUL	AH
		MOV	SI,AX
		CMP	BYTE PTR ES:[BP+SI+0],1		; ACTIVE ?
		JNZ	RETURN
		MOV	CX,ES:[BP+SI+4]
		MOV	DX,ES:[BP+SI+6]
		MOV	AX,IPL_PAR
		MOV	ES,AX
		CALL	READ_HD
		JC	RETURN
		CMP	ES:[BP+512-2],55AAH
		JNZ	RETURN
		CALL	DWORD PTR CS:IPL
;
;	ERROR RETURN
;
RETURN:
		POP	ES
		POP	DS
		POP	BP
		POP	DI
		POP	SI
		POP	DX
		POP	CX
		POP	BX
		POP	AX
		MOV	SS,CS:SS_BOOT
		MOV	SP,CS:SP_BOOT
		RET
BOOT_HD		ENDP

;
;	SUBROUTINE
;
READ_HD		PROC
		MOV	AL,DS:DISK_BOOT
		OR	AL,10010000B
		MOV	CS:RTRY,3
READ_HD1:
		MOV	AH,0D6H		; READ COMMAND
		INT	DSKIO
		JNC	READ_HD_OK
		DEC	CS:RTRY
		JZ	READ_HD_ERROR
		MOV	AH,0D7H		; RECALIBRATE COMMAND
		INT	DSKIO
		JMP	SHORT READ_HD1
READ_HD_ERROR:
		STC
READ_HD_OK:
		RET
READ_HD		ENDP

WRITE_HD	PROC
		MOV	AL,DS:DISK_BOOT
		OR	AL,10010000B
		MOV	CS:RTRY,3
WRITE_HD1:
		MOV	AH,0D5H		; WRITE COMMAND
		INT	DSKIO
		JNC	WRITE_HD_OK
		DEC	CS:RTRY
		JZ	WRITE_HD_ERROR
		MOV	AH,0D7H		; RECALIBRATE COMMAND
		INT	DSKIO
		JMP	SHORT WRITE_HD1
WRITE_HD_ERROR:
		STC
WRITE_HD_OK:
		RET
WRITE_HD	ENDP

		ORG	512 - 4
		DB	0
		DB	0
		DW	55AAH

BOOT		ENDS

		END
