;
;*****************************************************************
;
;ASSEMBLY NOTES FOR PROM.ASM
;
;THIS PROGRAM HAS BEEN SET UP TO RELOCATE ITSELF TO 4200H.
;THE FOLLOWING PROCEDURE IS RECOMMENDED IN ORDER TO
;"LOAD" PROM.ASM :
;
;
;	A>ASM PROM.XXX
;	A>DDT 
;	-F100,6000,00
;	-IPROM.HEX
;	-R
;	-M4200,48FF,200
;	- <CTRL-C>
;	A>SAVE 8 PROM.COM
;
;
;PROGRAM OPERATION NOTES
;
;THESE ROUTINES ARE USED TO LOAD THE 16K BLOCK OF RAM STARTING AT
;0100H. WHEN USED WITH THIS PROM PROGRAMMER PROGRAM THE FOLLOWING
;ENTRY IS MADE: " A>PROM FILENAME.TYP "
;IF THE FILE FITS IN A SINGLE EXTENT ON DISK (UP TO 16K BYTES), IT
;WILL ALL BE LOADED AT THIS TIME.  IF THE FILE TO BE PROGRAMMED IS
;LARGER THAN 16K, ONE EXTENT AT A TIME MAY BE LOADED INTO RAM BY
;TYPING THE COMMAND "A>PROM FILENAME.TYP N"  WHERE 'N' IS THE 
;NUMBER OF THE EXTENT. I.E., N=0 IS THE FIRST 16K BLOCK, N=1
;IS THE SECOND 16K BLOCK, AND SO ON.
;THE DEFAULT FOR 'N' IS 0(ZERO) AND DOES NOT NEED TO BE ENTERED
;IF THE FILE TO BE PROGRAMMED DOES NOT EXCEED 16K BYTES.
;
;
;AFTER THE "FILENAME.TYP" IS LOADED THE PROGRAM ASKS WHICH 1K OR 2K
;SEGMENT OF THE LOADED 16K (OR LESS) BLOCK IS TO BE TRANSFERRED
;FROM RAM TO THE PROM.
;
;REMEMBER:  2708 PROMS= 1K OR 16 PROMS PER EXTENT; ROM NUMBER = 0-F
;           2716 PROMS= 2K OR  8 PROMS PER EXTENT; ROM NUMBER = 0-7
;
;
;*****************************************************************
;
;
;
;THIS PROGRAM INTERFACES CP/M WITH THE SOLID STATE MUSIC..PB1,
;2708/2716 EPROM PROGRAMMER BOARD.
;
;PROGRAMMING ROUTINES COPYRIGHT, 1978, BY:
;     
;	SSM, INC.
;	2116 WALSH AVE.
;	SANTA CLARA, CA   95050
;
;	TELEPHONE: 408-246-2707
;
;CP/M INTERFACE ROUTINES ADAPTED BY:
;
;	JIM LOOFBOURROW
;	1324 WEST LIME AVENUE
;	LOMPOC, CALIFORNIA 93436
;
;	TELEPHONE: 805-736-2581 (5-10 PM PST)
;---------------------------------------------------------
;	Modified 10-13-81 to change 'CPORT' to C0 hex(EWB)
;	Modified 12-19-81 to change 'PROM' to F000 hex(EWB)
;---------------------------------------------------------
;	CONTROL PORT:  01 = 2708 EPROM
;                      02 = 2716 EPROM
;
;       PROGRAMMING CYCLES:     256 FOR 2708 EPROM
;				1   FOR 2716 EPROM
;
;	PROGRAMMING INSTRUCTIONS
;
;	1.  ENSURE PROGRAMMING SOCKETS ARE EMPTY.
;	2.  SW1 OFF (SWITCH LEVER TO THE RIGHT)
;	3.  ENSURE RED LED IS OFF
;	4.  WHEN INSTRUCTED BY THE PROGRAM INSERT EPROM 
;	5.  2708 IN LEFT............2716 IN RIGHT
;	6.  WHEN INSTRUCTED BY THE PROGRAM TURN SW1 ON.
;	7.  PROGRAM THE EPROM
;	8.  LED SHOULD ILLUMINATE DURING PROGRAMMING CYCLES.
;	9.  TURN OFF SW-1 WHEN PROGRAMMING FINISHED.
;      10.  RETURN TO CP/M WITH CONTROL C.
;
;
;
BDOS	EQU	0005H	;DOS ENTRY POINT
OPENF	EQU	15	;FILE OPEN
READF	EQU	20	;READ FUNCTION
CONS	EQU	1	;READ CONSOLE
BRKF	EQU	11	;BREAK KEY FUNCTION
TYPEF	EQU	2	;TYPE FUNCTION
FCB	EQU	5CH	;FILE CONTROL BLOCK ADDRESS
LF	EQU	0AH	;LINE FEED
CR	EQU	0DH	;CARRAIGE RETURN
SPC	EQU	20H	;SPACE
PBUF	EQU	09H	;PRINT BUFFER
BUFF	EQU	80H	;INPUT DISK BUFFER ADDRESS
DMAF	EQU	26	;DMA FUNCTION
;
;
;  FILE CONTROL BLOCK DEFINITIONS
FCBDN	EQU	FCB+0	;DISK NAME
FCBFN	EQU	FCB+1	;FILE NAME
FCBFT	EQU	FCB+9	;DISK FILE TYPE (3 CHAR'S)
FCBRL	EQU	FCB+12	;FILE'S CURRENT REEL NUMBER
FCBRC	EQU	FCB+15	;FILE'S RECORD COUNT (0 TO 128)
FCBCR	EQU	FCB+32	;CURRENT (NEXT) RECORD NUMBER (0 TO 127)
FCBLN	EQU	FCB+33	;FCB LENGTH
;
;
;
;
;REGISTER USAGE:
;REG A....PASS DATA FROM MEMORY TO THE PROGRAMMER
;REG B....REPEATED PROGRAMMING CYCLES
;REG C....SIZE.  SIZE=256(REG C + 1)
;REG DE...PROM CARD ADDRESS
;REG HL...DATA ADDRESS TO BE COPIED
;
;
CPM	EQU	0000H	;RE-ENTRY POINT OF DOS
PROM	EQU	0F000H	;PROGRAMMING SOCKET
CPORT	EQU	0C0H	;PB1 CONTROL PORT-C0 HEX(192 DEC)
;
;
;
;
;START OF PROGRAM
;
BEGIN:	ORG	100H
MOVE:	LXI	H,200H
	LXI	D,4200H
	LXI	B,700H
;
MOVE1:  MOV	  A,M
	INX	H
	STAX    D
	INX	D
	DCX	B
	MOV	A,B
	ORA	C
	JNZ	MOVE1
	JMP	XFER	;LOAD DISK FILE TO 16K BUFFER
;
	ORG	4200H
;
;**************************************************************
;
;THE FOLLOWING ROUTINES BEGINNING WITH "XFER:" HAVE BEEN EDITED
;AND ADAPTED FROM A PROGRAM IN THE CP/M USER'S GROUP LIBRARY.
;THE AUTHOR OF XFER.COM IS AS FOLLOWS:
;
;	LAWRENCE E. HUGHES
;	8080 SOFTWARE DEVELOPMENT CENTER
;	TALLAHASSEE, FLORIDA   32303
;
;**************************************************************
;
;
 RCFC     EQU    01                  ;READ CONSOLE
 WCFC     EQU    02                  ;WRITE CONSOLE
 OFFC     EQU    15                  ;OPEN FILE
 RRFC     EQU    20                  ;READ RECORD
 SAFC     EQU    26                  ;SET (DMA) ADDRESS
 FN       EQU    01                  ;FILE NAME
 FT       EQU    09                  ;FILE TYPE
 EX       EQU    12		     ;EXTENT
 NR       EQU    32                  ;NEXT RECORD
;
;
 XFER:    LXI    SP,STACK+64
          XRA    A              ;DEFAULT TO EXTENT ZERO
          STA    FCB+EX
          LDA    FCB+17         ;CHECK FOR SECOND PARAMETER
          CPI    ' '            ;JUMP IF NOT PRESENT
          JZ     XFER0
          SUI    '0'            ;DECODE IT
          JC     XFER9          ;JUMP IF NOT LEGAL DECIMAL DIGIT
          CPI    10
          JNC    XFER9
          STA    FCB+EX
 XFER0:   LXI    H,0100H        ;SET START OF BUFFER
          SHLD   ADDR
          XRA    A              ;CLEAR SECTOR COUNT
          STA    SCNT
          LXI    D,FCB          ;OPEN USER'S FILE
          CALL   OPEN
          INR    A              ;JUMP IF OK
          JNZ    XFER1
          LXI    H,STR2         ;ELSE PRINT 'FILE NOT FOUND'
          CALL   WASC
          JMP    XFERX          ;AND EXIT
 XFER1:   XRA    A              ;REWIND FILE
          STA    FCB+NR
 XFER2:   LHLD   ADDR           ;DE = CURRENT BUFFER ADDRESS
          MOV    D,H
          MOV    E,L
          CALL   SETDMA         ;SET DMA ADDRESS
          LXI    D,FCB
          CALL   READ           ;READ NEXT SECTOR INTO BUFFER
          DCR    A              ;JUMP IF EOF
          JZ     INIT
          LHLD   ADDR           ;INCREMENT LOAD ADDRESS
          LXI    D,80H
          DAD    D
          SHLD   ADDR
          LDA    SCNT           ;INCREMENT SECTOR COUNT
          INR    A
          STA    SCNT
          CPI    128            ;LOOP IF STILL ROOM IN BUFFER
          JC     XFER2
	  CALL   WEOLC
          LXI    H,STR3         ;PRINT BUFFER FULL MSG
          CALL   WASC
	  JMP    INIT
 XFER9:   CALL   WEOLC
          LXI    H,STR6
          CALL   WASC
 XFERX:   JMP    CPM          
 
 WASC:    MOV    A,M
          ORA    A
          RZ
          CALL   WACC
          INX    H
          JMP    WASC
 
 OPEN:    MVI    C,OFFC
          JMP    BDOS
      
 SETDMA:  MVI    C,SAFC
          JMP    BDOS
 
 READ:    MVI    C,RRFC
          JMP    BDOS
 
 RACC:    MVI    C,RCFC
          JMP    BDOS
 
 WACC:    PUSH   H
          PUSH   D
          PUSH   B
          MVI    C,WCFC
          MOV    E,A
          CALL   BDOS
          POP    B
          POP    D
          POP    H
          RET
 
 WEOLC:   MVI    A,CR
          CALL   WACC
          MVI    A,LF
          JMP    WACC
 
 WDB:     PUSH   PSW
          PUSH   B
          MVI    C,0
 WDB1:    CPI    100
          JC     WDB2
          INR    C
          SUI    100
          JMP    WDB1
 WDB2:    CALL   WDD
          MVI    C,0
 WDB3:    CPI    10
          JC     WDB4
          INR    C
          SUI    10
          JMP    WDB3
 WDB4:    CALL   WDD
          MOV    C,A
          CALL   WDD
          POP    B
          POP    PSW
          RET
 
 WDD:     PUSH   PSW
          MOV    A,C
          ADI    '0'
          CALL   WACC
          POP    PSW
          RET
 
;         DATA AREA
 
 STR2:    DB     'FILE NOT FOUND',CR,LF,0
 STR3:    DB     'BUFFER FULL, FURTHER PASSES REQUIRED',CR,LF,0
 STR6:    DB     'ILLEGAL EXTENT NUMBER',CR,LF,0
;
;**************************************************************
;
INIT:	LXI	SP,STACK+64	;LOAD STACK POINTER
MSG0:	LXI	D,SIGNON
	MVI	C,PBUF
	CALL	BDOS		
	JMP     MSG1
;
SIGNON: DB	CR,LF,LF
	DB	'PROGRAMMING ROUTINE FOR 2708/2716 EPROMS'
	DB	CR,LF
	DB	'SSM, INC., PB1 PROGRAMMER',CR,LF,LF
	DB	'BY JIM LOOFBOURROW',CR,LF,LF
	DB	'$'
;
MSG1:	LXI	D,TYPE1
	MVI	C,PBUF
	CALL	BDOS
	JMP	IN0
;
TYPE1:	DB	CR,LF,'EPROM TYPE:',CR,LF
	DB	'2708 ? (Y,N)',SPC,'$'
;
IN0:	MVI	C,CONS	;LOOK AT KEYBOARD
	CALL	BDOS	;GET RESPONSE
	CPI	''	;IS IT CONTROL C
	JZ	CPM
	CPI	'Y'	;IS IT 2708?
	JZ	FUNC0
	CPI	'N'	;CHECK TO VERIFY "NO"
	JNZ	MSG1	;GO BACK IF SOME OTHER
			;CHARACTER TYPED
MSG2:	LXI	D,TYPE2
	MVI	C,PBUF
	CALL    BDOS
	JMP	IN1
;
TYPE2:	DB	CR,LF,'2716 ? (Y,N)',SPC,'$'
;
IN1:	MVI	C,CONS
	CALL	BDOS
	CPI	''	;IS IT CONTROL C
	JZ	CPM
	CPI	'Y'
	JZ	FUNC1
	JMP	MSG1
;
;
FUNC0:	MVI	A,03H	;2708 = 03FF H
	STA	FLAG+1
	JMP	MSG4
;
FUNC1:	MVI	A,07H	;2716 = 07FF H
	STA	FLAG+1
MSG4:	LXI	D,TYPE4
	MVI	C,PBUF
	CALL	BDOS
	JMP	IN3
;
TYPE4:	DB	CR,LF,LF
	DB	'ENTER EPROM NUMBER',CR,LF
	DB	'RAM BUFFER 16K MAXIMUM',CR,LF
	DB	'(0-F FOR 2708)',CR,LF
	DB	'(0-7 FOR 2716)',CR,LF
	DB	'(CR) <NO CHANGE>',CR,LF
	DB	'(CONTL C) <TO EXIT>',CR,LF,LF
	DB	'?',SPC,'$'

IN3:	MVI	C,CONS
	CALL	BDOS
	CPI	''
	JZ	CPM
	CPI	0DH	;IS IT A CR
	JZ	MSG3
	CALL	ASCBIN
	STA	ROMNO
;
MSG5:	LXI	D,TYPE5
	MVI	C,PBUF
	CALL	BDOS
	JMP	IN4
;
TYPE5:  DB	CR,LF,LF
	DB	'NUMBER OK ?',SPC,'$'
;
IN4:	MVI	C,CONS
	CALL	BDOS
	CPI	''
	JZ	CPM
	CPI	'N'
	JZ	INIT
	CPI	'Y'
	JZ	BLOCK
	JMP	INIT
;
ASCBIN: ANI	07FH	;STRIP MSB
	CPI	41H
	JP	ABCDEF	;JUMP IF GREATER THAN 9
	ANI	0FH
	RET
ABCDEF: ANI	0FH
	ADI	09H
	RET
;
BLOCK:	LXI	H,RAM
	INX	H
	XRA	A	;ZERO ACCUM
	MOV	B,A	;ZERO B
	STA	RAM
	INR	A
;
BLOCK1:	STA	RAM+1
	LDA	ROMNO
	CMP	B
	JZ	MSG3
	INR	B
	LDA	FLAG+1
	INR	A
	ADD	M
	JMP	BLOCK1
;
MSG3:	LXI	D,TYPE3
	MVI	C,PBUF
	CALL	BDOS
	JMP	IN2
;
TYPE3:	DB	CR,LF,LF
	DB	'ENTER FUNCTION:',CR,LF
	DB	'CHECK EPROM IS ERASED........(E)',CR,LF
	DB	'COMPARE EPROM WITH DATA......(C)',CR,LF
	DB	'PROGRAM EPROM................(P)',CR,LF,LF
	DB	'?',SPC,'$'
;
IN2:	MVI	C,CONS
	CALL	BDOS
	CPI	''
	JZ	CPM
	CPI	'E'
	JZ	ERASED
	CPI	'C'
	JZ	COMPARE
	CPI	'P'
	JZ	INSTR
	JMP	MSG3
ERASED:	LXI	H,FLAG+1
	MOV	A,M
	CPI	07H
	JZ	E2716
	JMP	E2708
;
COMPARE:LXI	H,FLAG+1
	MOV	A,M
	CPI	07H
	JZ	V2716
	JMP	V2708
;
;
; PROGRAM THE EPROM
;
;
INSTR:	;GET READY TO BURN EPROM AND
	;GIVE INSTRUCTIONS
MSG6:	LXI	D,TYPE6
	MVI	C,PBUF
	CALL	BDOS
	JMP	IN5
;
TYPE6:	DB	CR,LF,LF
	DB	'1.  ENSURE SW-1 OFF.',CR,LF
	DB	'2.  INSERT EPROM:',CR,LF
	DB	'      2708 (LEFT)',CR,LF
	DB	'      2716 (RIGHT)',CR,LF
	DB	'3.  TURN SW-1 ON.',CR,LF
	DB	'4.  ENTER:(CR) $'
;
IN5:	MVI	C,CONS
	CALL	BDOS
	CPI	''
	JZ	CPM
	CPI	0DH	;ASCII FOR CARRIAGE RETURN
	JNZ	INIT
	LXI	H,FLAG+1
	MOV	A,M
	CPI	07H
	JZ	P2716
;
P2708:	MVI	A,01
	OUT	CPORT		;PRESET PB1 BOARD
;
;SET UP PARAMETERS
;
;NUMBER OF PROGRAMMING CYCLES
;
	MVI	B,0FFH		;256 CYCLES FOR 2708 EPROM
;
;NUMBER OF BYTES = 256(C+1)
;
	MVI	C,03		;03=2708 EPROM
	JMP	PROG1	;GO PROGRAM 2708
;
;
P2716:	MVI	A,02
	OUT     CPORT		;PRESET PB1 BOARD
;
;SET UP PARAMETERS
;
;NUMBER OF PROGRAMMING CYCLES
;
	MVI	B,01		;1 CYCLE FOR 2716 EPROMS
;
;NUMBER OF BYTES = 256(C+1)
;
	MVI	C,07		;07=2716 EPROMS
;
;
;SET UP ADDRESSES FOR TRANSFER
;
PROG1:	LXI	D,PROM		
	LHLD	RAM
;
;PROGRAM THE EPROM
;
PROG2:	MOV	A,M
	STAX	D
	INX	D
	INX	H
	MOV	A,D
	ANA	C
	ORA	E
	JNZ	PROG2
	DCR	B
	JNZ	PROG1
	DCX	D
	LDAX	D		;RESET PB1 BOARD
	LXI	D,TYPE11	;PROGRAMMING FINISHED
	MVI	C,PBUF
	CALL	BDOS
	JMP	MSG3		;GO BACK TO START
;
TYPE11:	DB	CR,LF,07H	;RING BELL
	DB	'5.  TURN SW-1 OFF'
	DB	CR,LF,LF,'$'
;
;
;ROUTINES FOR CHECKING IF THE EPROM IS ERASED.  
;
;
;
;
E2708:	MVI	C,03		;03=2708
	JMP	ERASE
;
E2716:	MVI	C,07		;07=2716
;
;
ERASE:	LXI	D,PROM		;PROGRAMMING SOCKET ADDR.
;
;
ER1:	LDAX	D		;READ EPROM
	INX	D
	CPI	0FFH		;TEST FOR ERASE
	JNZ	MSG7
	MOV	A,D
	ANA	C
	ORA	E		;DONE YET?
	JNZ	ER1
	JMP	MSG8
	RET
;ROUTINES FOR VERIFYING THE ORGINAL SOURCE
;DATA IN MEMORY AGAINST THE EPROM COPY.
;
;
V2708:	MVI	C,03
	JMP	VERF
;
;
V2716:	MVI	C,07
;
;
VERF:	LXI	D,PROM		;PROGRAMMING SOCKET ADDR.
	LHLD	RAM		;POINT TO RAM SOURCE
;
;
VERF1:	MOV	B,M		;GET ORIGINAL DATA
	LDAX	D		;GET EPROM COPY
	INX	D
	INX	H
	CMP	B		;DATA THE SAME?
	JNZ	MSG9
	MOV	A,D
	ANA	C
	ORA	E
	JNZ	VERF1		;DO NEXT BYTE
	JMP	MSG10
MSG7:	LXI	D,TYPE7
	MVI	C,PBUF
	CALL	BDOS
	JMP	MSG3
;
TYPE7:	DB	CR,LF
	DB	'NOT ERASED $'
;
MSG8:	LXI	D,TYPE8
	MVI	C,PBUF
	CALL	BDOS
	JMP	MSG3
;
TYPE8:	DB	CR,LF,'ERASED $'
;
MSG9:	LXI	D,TYPE9
	MVI	C,PBUF
	CALL	BDOS
	JMP	MSG4
;
TYPE9:	DB	CR,LF,'FAIL COMPARE $'
;
MSG10:	LXI	D,TYPE10
	MVI	C,PBUF
	CALL	BDOS
	JMP	MSG4
;
TYPE10:	DB	CR,LF,'COMPARE OK $'
;
;   DATA
;
RAM:	DW	0000H	;LOCATION OF RAM SOURCE DATA
ROMNO:	DS	1	;0-F=2708....0-7=2716
FLAG:	DW	03FFH	;=2708....07FFH=2716
ADDR:	DS	2	;
SCNT:	DS	1	;
STACK:	DS	64	;
;
;
	END
;
;
