		PAGE	58,132
		TITLE	AUX2RAM		2ND. AND 3RD. SERIAL INTERFACE DRIVER
;************************************************************************
;*									*
;*	MODULE NAME	AUX2RAM						*
;*									*
;*	FUNCTION	INPUT/OUTPUT 2ND. AND 3RD. SERIAL INTERFACE	*
;*			SYSTEM... MSD-A1				*
;*			OS NAME... MS_DOS 2.0 (FOR A1)			*
;*			THIS PROGRAM IS LOADED WHEN START UP BY	 	*
;*			"SYSINIT". (SET FILE NAME IN "CONFIG.SYS" FILE.)*
;*									*
;*	DATE		JLY/27/84					*
;*									*
;************************************************************************
;	AUG/10/84	FIXED BUG
;	AUG/21/84	IF AUX2/AUX3 NONE, RETURN ERROR.
;	OCT/03/84	CHANGE 8251 INITIALIZE
		PAGE
;****************************************
;*	EXTERNAL LABEL AND SYMBOL	*
;****************************************
		EXTRN	EXTRS_INT:FAR	; ENTRY POINT FOR HARD INTERRUPT OF AUX2 AND AUX3
		EXTRN	OPTRS232C_IO:FAR; ENTRY POINT OF AUX ROM DRIVER
		EXTRN	EXTRS_END:FAR


		EXTRN	S1_M_INT:FAR
		EXTRN	S1_S_INT:FAR
		EXTRN	S2_M_INT:FAR
		EXTRN	S2_S_INT:FAR
;****************************************
;*	EQUATE TABLE			*
;****************************************
EXT_INT0	EQU	0BH		; EXTRA INTERRUPT 0
EXT_INT1	EQU	0DH		; EXTRA INTERRUPT 1
EXT_INT2	EQU	0EH		; EXTRA INTERRUPT 2
EXT_INT3	EQU	11H		; EXTRA INTERRUPT 3
EXT_INT4	EQU	13H		; EXTRA INTERRUPT 4
EXT_INT5	EQU	14H		; EXTRA INTERRUPT 5
EXT_INT6	EQU	15H		; EXTRA INTERRUPT 6
AUX2_ROM	EQU	1EH		; INTERRUPT VECTOR OF AUX I/O

AUX_FNC_INIT1	EQU	0		; INITIALIZE 1 (XON/XOFF DISABLE)
AUX_FNC_INIT2	EQU	1		; INITIALIZE 2 (XON/XOFF ENABLE)
AUX_FNC_GETDL	EQU	2		; GET RECEIVE DATA LENGTH
AUX_FNC_SEND	EQU	3		; SEND   A CHARACTER
AUX_FNC_RECV	EQU	4		; RECEIVE A CHARACTER
AUX_FNC_CMDO	EQU	5		; RS232C COMMAND OUTPUT
AUX_FNC_STAT	EQU	6		; READ RS232C STATUS

XON		EQU	13H
XOFF		EQU	11H

RS_BUF_SIZE	EQU	256 * 2
;****************************************
;*		STRUCTURE BLOCK	 	*
;****************************************
IODAT		STRUC			; PACKET TABLE
CMDLEN		DB	?		;	LENGTH OF COMMAND
UNIT		DB	?		;	SUB UNIT SPECIFIER
CMD		DB	?		;	COMMAND CODE
STATUS		DW	?		;	STATUS
		DB	8 DUP(?)
MEDIA		DB	?		;	MEDIA DESCRIPTOR
TRANS		DD	?		;	TRANSFER ADDRESS
COUNT		DW	?		;	COUNT OF BLOCKS OR CHARACTERS
START		DW	?		;	FIRST BLOCK TO TRANSFER
IODAT		ENDS

WORK_TBL	STRUC
		DB	?,?		; DUMMY
RSB_FLAG	DB	?		; FLAG
					;	BIT7 = INITIALIZED
					;	6 = OVERFLOW
					;	5 = BUFFER FULL
					;	4 = XON/XOFF ENABLE
					;	3 = XON SEND
					;	2 = XON RECEIVE
					;	1 = NONE
					;	0 = NONE
RSB_CMDS	DB	?		; RS232C COMMAND (UPD825)
RSB_STIM	DB	?		; TIME OUT OF SEND ( 1 SEC)
RSB_RTIM	DB	?		; TIME OUT OF RECEIVE (30SEC)
RSB_XON		DW	?		; DATA COUNT WHEN XON SEND
RSB_XOFF	DW	?		; DATA COUNT WHEN XOFF SEND
RSB_HEAD	DW	?		; BUFFER HEAD ADDRESS
RSB_TALE	DW	?		; BUUFFER TALE ADDRESS
RSB_CNT		DW	?		; DATA COUNT OF QUING BUFFER
RSB_PUTP	DW	?		; RECEIVE DATA PUT ADDRESS
RSB_GETP	DW	?		; RECEIVE DATA GET ADDRESS
;
RSB_BUF		DB	RS_BUF_SIZE DUP (?)
WORK_TBL	ENDS

CONF_STR	STRUC
BUF_OFST	DW	?
BUF_SEG		DW	?
BUF_SIZE	DW	?
STIM_DEF	DB	?
RTIM_DEF	DB	?
BAUD_DEF	DB	?
CMD_DEF		DB	?
		DB	6 DUP (?)
CONF_STR	ENDS
		PAGE
;********************************************************
;*							*
;*	SYSTEM PROGRAM SEGMENT AREA			*
;*							*
;********************************************************
INT_VECTOR	SEGMENT AT 0000H	; INTERRUPT VECTOR
;
		ORG	EXT_INT0 * 4
L0_VECTOR	LABEL	DWORD
		ORG	EXT_INT1 * 4
L1_VECTOR	LABEL	DWORD
		ORG	EXT_INT2 * 4
L2_VECTOR	LABEL	DWORD
		ORG	EXT_INT3 * 4
L3_VECTOR	LABEL	DWORD
		ORG	EXT_INT4 * 4
L4_VECTOR	LABEL	DWORD
		ORG	EXT_INT5 * 4
L5_VECTOR	LABEL	DWORD
		ORG	EXT_INT6 * 4
L6_VECTOR	LABEL	DWORD
		ORG	AUX2_ROM * 4
AUXIO_VECTOR	LABEL	DWORD		; AUX ROM DRIVER ENTRY POINT

INT_VECTOR	ENDS
;********************************
;*	SYSTEM COMMON AREA	*
;********************************
COMMON_SEG	SEGMENT	AT 40H
		ORG	0
BIOS_FLAG	DW	?
COMMON_SEG	ENDS
;********************************
;*	IO.SYS SEGMENT		*
;********************************
USER		SEGMENT	AT 60H
		ORG	08H
MEM_SW1		DB	?
MEM_SW2		DB	?
MEM_SW3		DB	?
MEM_SW4		DB	?
		ORG	10H+4
AUX_POINTER	LABEL	DWORD
		ORG	0E0H
PTRSAVE		DD	?
USER		ENDS
		PAGE
;****************************************************************
;*								*
;*	"DOS" AND "BIOS" INTERFACE MODULES.			*
;*								*
;****************************************************************
CODE		SEGMENT	WORD PUBLIC 'CODES'
	ASSUME	CS:CODE
		ORG	0
START_PROGRAM	LABEL	NEAR
;********************************************************
;*							*
;*	TABLE BLOCKS (READ ONLY)			*
;*							*
;********************************************************
;
;****************************************
;*	DEVICE TABLE			*
;****************************************
AUX2_DEV	LABEL	WORD
		DD	AUX3_DEV	; NEXT TABLE POINTER
		DW	8000H		; STATUS
					;	(CHARACTER DEVICE)
		DW	STRATEGY	; STRATEGY ENTRY POINT
		DW	AUX2_INT	; INTERRUPT ENTRY POINT
		DB	'AUX2    '	; DEVICE NAME
;
AUX3_DEV	LABEL	WORD
		DD	-1		; NEXT TABLE POINTER
		DW	8000H		; STATUS
					;	(CHARACTER DEVICE)
		DW	STRATEGY	; STRATEGY ENTRY POINT
		DW	AUX3_INT	; INTERRUPT ENTRY POINT
		DB	'AUX3    '	; DEVICE NAME
;
;****************************************
;*	DESPATCH TABLE FOR DEVICES	*
;****************************************
AUX2_TBL	LABEL	WORD
		DW	AUX2_INIT	; 0 - INIT
		DW	CMDERR_EXIT	; 1 - MEDIA CHECK (NOT USED)
		DW	CMDERR_EXIT	; 2 - GET BPB (NOT USED)
		DW	CMDERR_EXIT	; 3 - IO CTRL INPUT
		DW	AUX2_READ	; 4 - DESTRUCTIVE READ
		DW	AUX2_RDND	; 5 - NON-DESTRUCTIVE READ
		DW	NORMAL_EXIT	; 6 - INPUT STATUS
		DW	AUX2_FLUSH	; 7 - FLUSH INPUT BUFFER
		DW	AUX2_WRITE	; 8 - WRITE
		DW	AUX2_WRITE	; 9 - WRITE & VERIFY
		DW	NORMAL_EXIT	;10 - WRITE STATUS
		DW	NORMAL_EXIT	;11 - OUTPUT STATUS
		DW	CMDERR_EXIT	;12 - IOCTL OUTPUT

SAVES		LABEL	DWORD
		DW	PTRSAVE
		DW	USER
	PAGE
;************************************************
;*						*
;*	WORK AREA (RAM)				*
;*						*
;*		RS232C BUFFER			*
;*						*
;************************************************
;****************************************
;*	FOR AUX2			*
;****************************************
AUX2_WORK	LABEL	BYTE
		DB	0,0		; DUMMY
		DB	10H		; FLAG
		DB	37H		; RS232C COMMAND (UPD825)
		DB	02H		; TIME OUT OF SEND ( 1 SEC)
		DB	3CH		; TIME OUT OF RECEIVE (30SEC)
		DW	RS_BUF_SIZE/8	; DATA COUNT WHEN XON SEND
		DW	RS_BUF_SIZE/8*3	; DATA COUNT WHEN XOFF SEND
		DW	RS232C_BUFFER	; BUFFER HEAD ADDRESS
		DW	RS232C_BUFFER+RS_BUF_SIZE
					; BUFFER TALE ADDRESS
		DW	0		; DATA COUNT OF QUING BUFFER
		DW	RS232C_BUFFER	; RECEIVE DATA PUT ADDRESS
		DW	RS232C_BUFFER	; RECEIVE DATA GET ADDRESS
;
RS232C_BUFFER	DB	RS_BUF_SIZE DUP (0)
;****************************************
;*	FOR AUX3			*
;****************************************
AUX3_WORK	LABEL	BYTE
		DB	0,0		; DUMMY
		DB	10H		; FLAG
		DB	37H		; RS232C COMMAND (UPD825)
		DB	02H		; TIME OUT OF SEND ( 1 SEC)
		DB	3CH		; TIME OUT OF RECEIVE (30SEC)
		DW	RS_BUF_SIZE/8	; DATA COUNT WHEN XON SEND
		DW	RS_BUF_SIZE/8*3	; DATA COUNT WHEN XOFF SEND
		DW	RS232C_BUFFER2	; BUFFER HEAD ADDRESS
		DW	RS232C_BUFFER2+RS_BUF_SIZE
					; BUFFER TALE ADDRESS
		DW	0		; DATA COUNT OF QUING BUFFER
		DW	RS232C_BUFFER2	; RECEIVE DATA PUT ADDRESS
		DW	RS232C_BUFFER2	; RECEIVE DATA GET ADDRESS
;
RS232C_BUFFER2	DB	RS_BUF_SIZE DUP (0)
;****************************************
;*	WORK AREA 1			*
;****************************************
RDND_CHAR	DB	0		; READ CHAR. BEFORE
RDND_FLAG	DB	0		; FLLAG OF RDND NONE

WORK_PNT	DW	?		; WORK AREA POINTER
AUX_ROM_FLAG	DW	?		; FLAG USED WHEN CALL AUX ROM DRIVER
;
		PAGE
;********************************************************
;*							*
;*	MODULE NAME	STRATEGY			*
;*							*
;*	FUNCTION	GET CONSOL REQUEST PARAMETER	*
;*							*
;*	INPUT		ES:BX	PACKET TABLE		*
;*							*
;*	OUTPUT		NONE				*
;*							*
;********************************************************
STRATEGY	PROC	FAR
		PUSH	SI
		PUSH	DS
		LDS	SI,[SAVES]
		MOV	[SI+0],BX
		MOV	[SI+2],ES
		POP	DS
		POP	SI
		RET
STRATEGY	ENDP
		PAGE
;********************************************************
;*							*
;*	MODULE NAME	AUX2_INT			*
;*							*
;*	FUNCTION	2ND. AUX I/O CONTROL		*
;*							*
;*	INPUT/OUTPUT	NONE				*
;*							*
;********************************************************
AUX2_INT	LABEL	FAR
		MOV	[AUX_ROM_FLAG],01H	;-------AUG/10/84----
		MOV	[WORK_PNT],OFFSET AUX2_WORK
		JMP	SHORT	AUX_INT
;********************************************************
;*							*
;*	MODULE NAME	AUX3_INT			*
;*							*
;*	FUNCTION	3RD. AUX I/O CONTROL		*
;*							*
;*	INPUT/OUTPUT	NONE				*
;*							*
;********************************************************
AUX3_INT	LABEL	FAR
		MOV	[AUX_ROM_FLAG],02H	;--------AUG/10/84-
		MOV	[WORK_PNT],OFFSET AUX3_WORK
AUX_INT		PROC	FAR
		PUSH	SI		; ALL REGISTER SAVE
		PUSH	AX
		PUSH	CX
		PUSH	DX
		PUSH	DI
		PUSH	BP
		PUSH	DS
		PUSH	ES
		PUSH	BX
;
		LDS	SI,[SAVES]	; GET PACKET ADDRESS
		LDS	BX,[SI]
		MOV	CX,[BX.COUNT]	; CX = NUMBER OF CHARACTERS
		MOV	AL,[BX.CMD]	; AL = COMMAND #
		CBW
		MOV	SI,OFFSET AUX2_TBL
		ADD	SI,AX		; GET BRANCH MODULE FROM DESPATCH TABLE
		ADD	SI,AX		;
		CMP	AL,12
		JA	CMDERR_EXIT
		LES	DI,[BX.TRANS]	; ES:DI = DATA ADDRESS
		PUSH	CS
		POP	DS
		JMP	[SI]
;****************************************
;*	EXIT POINT			*
;****************************************
BUSY_EXIT:
		MOV	AH,03H		; STATUS = BUSY
		JMP	SHORT COMMON_EXIT
;
CMDERR_EXIT:
		MOV	AL,3		; STATUS = COMMAND ERROR
ERROR_EXIT:
		MOV	AH,81H		;
		JMP	SHORT COMMON_EXIT
;
NORMAL_EXIT:
		MOV	AH,1
;*
COMMON_EXIT:
		LDS	SI,[SAVES]	; SET STATUS
		LDS	BX,[SI]
		MOV	[BX.STATUS],AX
;
		POP	BX		; ALL REGISTER RESTORE
		POP	ES
		POP	DS
		POP	BP
		POP	DI
		POP	DX
		POP	CX
		POP	AX
		POP	SI
		RET
AUX_INT		ENDP
		PAGE
	ASSUME	CS:CODE,DS:CODE
;********************************************************
;*							*
;*	MODULE NAME	AUX2_READ			*
;*							*
;*	FUNCTION	RECEIVE MULTI CHARACTER		*
;*			ON RS232C			*
;*							*
;*	INPUT		ES:DI	DATA STORE ADDRESS	*
;*			CX	DATA LENGTH		*
;*	OUTPUT		NONE				*
;*							*
;********************************************************
AUX2_READ	PROC	NEAR
		JCXZ	AUX2_READ_RET	; CHARACTER NONE ?
AUX2_READ10:
		PUSH	CX
		CALL	S1IN		; AUX READ
		POP	CX
		CMP	AH,4		; BUSY ?
		JZ	AUX2_READ80
		CMP	AH,0		; ERROR ?
		JNZ	AUX2_READ90
		STOSB
		LOOP	AUX2_READ10
AUX2_READ_RET:
		JMP	NORMAL_EXIT
AUX2_READ80:
		JMP	BUSY_EXIT
AUX2_READ90:
		MOV	AL,2		; DEVICE NOT READY
		JMP	ERROR_EXIT
AUX2_READ	ENDP
		PAGE
;********************************************************
;*							*
;*	MODULE NAME	AUX2_RDND			*
;*							*
;*	FUNCTION	NON-DESTRUCTIVE READ		*
;*							*
;*	INPUT		NONE				*
;*							*
;*	OUTPUT		NONE				*
;*							*
;********************************************************
AUX2_RDND	PROC	NEAR
		CALL	S1RDND		; SENCE READ ENABLE
		CMP	AH,4
		JZ	AUX2_RDND80
		CMP	AH,0
		JNZ	AUX2_RDND90
		LDS	SI,[SAVES]
		LDS	BX,[SI]
		MOV	[BX.MEDIA],AL	; SET READ CHARACTER
AUX2_RDND_RET:
		JMP	NORMAL_EXIT
AUX2_RDND80:
		JMP	BUSY_EXIT
AUX2_RDND90:
		MOV	AL,2
		JMP	ERROR_EXIT
AUX2_RDND	ENDP
		PAGE
;********************************************************
;*							*
;*	MODULE NAME	AUX2_FLUSH			*
;*							*
;*	FUNCTION	AUX INPUT BUFFER CLEAR		*
;*							*
;*	INPUT		NONE				*
;*							*
;*	OUTPUT		NONE				*
;*							*
;********************************************************
AUX2_FLUSH	PROC	NEAR
		CALL	S1FLUSH		; AUX READ BUFFER CLEAR
		JMP	NORMAL_EXIT
;
AUX2_FLUSH	ENDP
		PAGE
;********************************************************
;*							*
;*	MODULE NAME	AUX2_WRITE			*
;*							*
;*	FUNCTION	SEND MULTI CHARACTER ON RS232C	*
;*							*
;*	INPUT		ES:DI	DATA STORE ADDRESS	*
;*			CX	DATA LENGTH		*
;*							*
;*	OUTPUT		NONE				*
;*							*
;********************************************************
AUX2_WRITE	PROC	NEAR
		JCXZ	AUX2_WRIT_RET	; OUTPUT CHARACTER NONE ?
AUX2_WRIT10:
		PUSH	CX
		MOV	AL,ES:[DI]	; GET CHARACTER
		INC	DI
		CALL	S1OUT		; OUTPUT CHARACTER
		POP	CX
		CMP	AH,4
		JZ	AUX2_WRIT80
		TEST	AH,01H
		JNZ	AUX2_WRIT90
		LOOP	AUX2_WRIT10
AUX2_WRIT_RET:
		JMP	NORMAL_EXIT
AUX2_WRIT80:
		JMP	BUSY_EXIT
AUX2_WRIT90:
		MOV	AL,2
		JMP	ERROR_EXIT
AUX2_WRITE	ENDP
		PAGE
;********************************************************
;*							*
;*	MODULE NAME	AUX2_O_STATUS			*
;*							*
;*	FUNCTION	RS232C STATUS READ		*
;*							*
;*	INPUT		NONE				*
;*							*
;*	OUTPUT		NONE				*
;*							*
;********************************************************
AUX2_O_STATUS	PROC	NEAR
		CALL	S1SENCE		; SENCE RS232C
		CMP	AH,4
		JZ	AUX2_O_STS80
		TEST	AH,01H
		JNZ	AUX2_O_STS90
		JMP	NORMAL_EXIT
AUX2_O_STS80:
		JMP	BUSY_EXIT
AUX2_O_STS90:
		MOV	AL,2
		JMP	ERROR_EXIT
AUX2_O_STATUS	ENDP
		PAGE
;****************************************************************
;*								*
;*   AUXILIARY INPUT/OUTPUT					*
;*								*
;****************************************************************
;************************************************
;*						*
;*	DATA SEND				*
;*						*
;*	INPUT	CL=SEND DATA			*
;*						*
;*	OUTPUT	AH=RETURN INFORMATION		*
;*		=0, NORMAL END			*
;*		=1, NOT INTILIZED		*
;*		=2, RECEIVE BUFFER OVERFLOW	*
;*		=3, TIME OUT			*
;*		=4, BUSY			*
;*						*
;*						*
;************************************************
;=====
S1OUT		PROC	NEAR
;=====
		MOV	AH,AUX_FNC_SEND
		MOV	SI,[AUX_ROM_FLAG]	;------------AUG/10/84-
		INT	AUX2_ROM		; SEND A CHARACTER

S1OUT_RET:
		RET
S1OUT		ENDP
		PAGE
;************************************************
;*						*
;*	DATA RECEIVE				*
;*						*
;*	INPUT	NONE				*
;*						*
;*	OUTPUT	AL=RECEIVE DATA			*
;*		AH=RETURN INFORMATION		*
;*		=0, NORMAL END			*
;*		=1, NOT INTILIZED		*
;*		=2, RECEIVE BUFFER OVERFLOW	*
;*		=3, TIME OUT			*
;*		=4, BUSY			*
;*						*
;*						*
;************************************************
;====
S1IN		PROC	NEAR
;====

		MOV	AH,0
		MOV	AL,[RDND_CHAR]
		TEST	[RDND_FLAG],01H
		JNZ	S1IN20
		MOV	AH,AUX_FNC_RECV		; GET RECEIVE DATA
		MOV	SI,[AUX_ROM_FLAG]	;------------AUG/10/84-
		INT	AUX2_ROM
		MOV	AL,CH
S1IN20:
		AND	[RDND_FLAG],NOT 01H
		RET
S1IN		ENDP
		PAGE
;************************************************
;*						*
;*	READ NON-DESTRUCTIVE			*
;*						*
;*	INPUT	NONE				*
;*						*
;*	OUTPUT	ZF	ON=READY, ON=BUSY	*
;*		AH=RETURN INFORMATION		*
;*		=0, NORMAL END			*
;*		=1, NOT INTILIZED		*
;*		=2, RECEIVE BUFFER OVERFLOW	*
;*		=3, TIME OUT			*
;*		=4, BUSY			*
;*						*
;*						*
;*						*
;************************************************
;======
S1RDND		PROC	NEAR
;======
		MOV	AH,0
		MOV	AL,[RDND_CHAR]
		TEST	[RDND_FLAG],01H
		JNZ	S1RDND_RET

		MOV	AH,AUX_FNC_GETDL
		MOV	SI,[AUX_ROM_FLAG]	;------------AUG/10/84-
		INT	AUX2_ROM
		CMP	AH,0
		JNZ	S1RDND_RET
		JCXZ	S1RDND90

		MOV	AH,AUX_FNC_RECV
		MOV	SI,[AUX_ROM_FLAG]	;------------AUG/10/84-
		INT	AUX2_ROM
		MOV	AL,CH
		MOV	[RDND_CHAR],AL
		OR	[RDND_FLAG],01H
S1RDND_RET:
		POP	CX
		AND	AH,AH
		RET
S1RDND90:
		MOV	AH,4
		JMP	S1RDND_RET
S1RDND		ENDP
	PAGE
;************************************************
;*						*
;*	CHECK TRANSFER STATUS			*
;*						*
;*	INPUT	NONE				*
;*	OUTPUT					*
;*		AH=RETURN INFORMATION		*
;*		=0, NORMAL END			*
;*		=1, NOT INTILIZED		*
;*		=2, RECEIVE BUFFER OVERFLOW	*
;*		=3, TIME OUT			*
;*		=4, BUSY			*
;*						*
;*						*
;************************************************
;=====
S1SENCE		PROC	NEAR
;=====
		PUSH	CX
		MOV	AH,AUX_FNC_STAT
		MOV	SI,[AUX_ROM_FLAG]	;------------AUG/10/84-
		INT	AUX2_ROM

		CMP	AH,0
		JNZ	S1SENCE_RET
		TEST	CH,01H		; TXRDY
		JZ	S1SENCE90

S1SENCE_RET:
		POP	CX
		RET
S1SENCE90:
		MOV	AH,4
		JMP	S1SENCE_RET
S1SENCE		ENDP
		PAGE
;************************************************
;*						*
;*	RS232C RECEIVE BUFFER CLEAR		*
;*						*
;*	INPUT	NONE				*
;*						*
;*	OUTPUT	NONE				*
;*						*
;************************************************
;=======
S1FLUSH		PROC	NEAR
;=======
		MOV	AH,AUX_FNC_GETDL
		MOV	SI,[AUX_ROM_FLAG]	;------------AUG/10/84-
		INT	AUX2_ROM
		CMP	AH,0
		JNZ	S1FLUSH_9
		JCXZ	S1FLUSH_9
		MOV	AH,AUX_FNC_RECV
		MOV	SI,[AUX_ROM_FLAG]	;------------AUG/10/84-
		INT	AUX2_ROM
		CMP	AH,0
		JZ	S1FLUSH
S1FLUSH_9:
		AND	[RDND_FLAG],NOT 01H
		RET
S1FLUSH		ENDP
		PAGE
;----------------------------------------------CHANGE AUG/10/84-------
;****************************************
;*	VECTOR TABLE			*
;****************************************
S1_INT_TBL:
		DD	L0_VECTOR,S1_M_INT	; LEVEL 0
		DD	L1_VECTOR,S1_M_INT	; LEVEL 1
		DD	L2_VECTOR,S1_M_INT	; LEVEL 2
		DD	L3_VECTOR,S1_S_INT	; LEVEL 3
S2_INT_TBL:
		DD	L0_VECTOR,S2_M_INT	; LEVEL 0
		DD	L4_VECTOR,S2_S_INT	; LEVEL 4
		DD	L5_VECTOR,S2_S_INT	; LEVEL 5
		DD	L6_VECTOR,S2_S_INT	; LEVEL 5
		PAGE
;********************************************************
;*							*
;*	MODULE NAME	AUX2_INIT			*
;*							*
;*	FUNCTION	INITIARIZE AUX DRIVER		*
;*							*
;*	INPUT		NONE				*
;*							*
;*	OUTPUT		NONE				*
;*							*
;********************************************************
AUX2_INIT	PROC	NEAR

	ASSUME	CS:CODE,DS:CODE,ES:INT_VECTOR
		MOV	AX,INT_VECTOR
		MOV	ES,AX
		MOV	WORD PTR [AUXIO_VECTOR],OFFSET OPTRS232C_IO
		MOV	WORD PTR [AUXIO_VECTOR+2],SEG  OPTRS232C_IO
;----------------------------------------------------INSERT AUG/21/84--
;--------------------------------10/03/1984----------------
		MOV	AL,0			; OUTPUT DUMMY COMMAND
		OUT	0B3H,AL
		PUSH	AX
		POP	AX
		MOV	AL,0
		OUT	0B3H,AL
		PUSH	AX
		POP	AX
		MOV	AL,0
		OUT	0B3H,AL
		PUSH	AX
		POP	AX
;		MOV	AL,02H			; OUTPUT DUMMY
;		OUT	0B3H,AL			;
;----------------------------------------------------------
		MOV	AL,40H			; RESET
		OUT	0B3H,AL
		IN	AL,0B3H
		CMP	AL,0FFH			; NONE ?
		JNZ	AUX2_INIT1
		JMP	AUX2_INIT9
AUX2_INIT1:
;--------------------------------10/03/1984----------------
		MOV	AL,0			; OUTPUT DUMMY COMMAND
		OUT	0BBH,AL
		PUSH	AX
		POP	AX
		MOV	AL,0
		OUT	0BBH,AL
		PUSH	AX
		POP	AX
		MOV	AL,0
		OUT	0BBH,AL
		PUSH	AX
		POP	AX
;		MOV	AL,02H			; OUTPUT DUMMY
;		OUT	0BBH,AL			;
;----------------------------------------------------------
		MOV	AL,40H			; RESET
		OUT	0BBH,AL
		IN	AL,0BBH
		CMP	AL,0FFH			; NONE ?
		JNZ	AUX2_INIT2
		JMP	AUX2_INIT9
AUX2_INIT2:
;----------------------------------------------------------------------
;
		IN	AL,0B0H			; GET INTERRUPT LEVEL
		AND	AL,03H
		CBW
		MOV	CL,3
		SHL	AX,CL
		MOV	SI,OFFSET S1_INT_TBL
		ADD	SI,AX
		LODSW			; ES:DI=INTERRUPT VECTOR ADDRESS
		MOV	DI,AX
		LODSW
		MOV	ES,AX
		MOVSW			; SET INTERRUPT VECTOR
		MOVSW
;
		IN	AL,0B2H			; GET INTERRUPT LEVEL
		AND	AL,03H
		CBW
		MOV	CL,3
		SHL	AX,CL
		MOV	SI,OFFSET S2_INT_TBL
		ADD	SI,AX
		LODSW			; ES:DI=INTERRUPT VECTOR ADDRESS
		MOV	DI,AX
		LODSW
		MOV	ES,AX
		MOVSW			; SET INTERRUPT VECTOR
		MOVSW

	ASSUME	CS:CODE,DS:USER,ES:CODE
		PUSH	CS
		POP	ES
		MOV	AX,USER
		MOV	DS,AX
		MOV	AL,[MEM_SW2]
		MOV	CL,4
		SHR	AL,CL			; AL=BAUD RATE
		MOV	CH,[MEM_SW4]		; CH=MODE INSTRUCTION
		MOV	CL,037H			; CL=COMMAND INSTRUCTION
		MOV	BX,0
		MOV	DX,RS_BUF_SIZE		; DX=BUFFER SIZE
		MOV	DI,OFFSET AUX2_WORK	; ES:DI=BUFFER ADDRESS

		LDS	SI,[AUX_POINTER]	; DS:SI=AUX DCT
		ADD	SI,SIZE CONF_STR	; DS:BX=AUX2 DCT
		MOV	[SI.BUF_OFST],DI
		MOV	[SI.BUF_SEG],ES
		MOV	[SI.BUF_SIZE],DX
		MOV	[SI.STIM_DEF],BL
		MOV	[SI.RTIM_DEF],BH
		MOV	[SI.CMD_DEF],CH
		MOV	[SI.BAUD_DEF],AL

		MOV	SI,1
		MOV	AH,AUX_FNC_INIT2
		INT	AUX2_ROM

		MOV	AX,USER
		MOV	DS,AX
		MOV	AL,[MEM_SW2]
		MOV	CL,4
		SHR	AL,CL			; AL=BAUD RATE
		MOV	CH,[MEM_SW4]		; CH=MODE INSTRUCTION
		MOV	CL,037H			; CL=COMMAND INSTRUCTION
		MOV	BX,0
		MOV	DX,RS_BUF_SIZE		; DX=BUFFER SIZE
		MOV	DI,OFFSET AUX3_WORK	; ES:DI=BUFFER ADDRESS

		LDS	SI,[AUX_POINTER]	; DS:SI=AUX DCT
		ADD	SI,(SIZE CONF_STR)*2	; DS:BX=AUX3 DCT
		MOV	[SI.BUF_OFST],DI
		MOV	[SI.BUF_SEG],ES
		MOV	[SI.BUF_SIZE],DX
		MOV	[SI.STIM_DEF],BL
		MOV	[SI.RTIM_DEF],BH
		MOV	[SI.CMD_DEF],CH
		MOV	[SI.BAUD_DEF],AL

		MOV	SI,2
		MOV	AH,AUX_FNC_INIT2
		INT	AUX2_ROM

;---------------------------------------------------------------------
AUX2_INIT9:
		LDS	SI,[SAVES]
		LDS	BX,[SI]
		MOV	WORD PTR [BX+TRANS+0],OFFSET EXTRS_END
		MOV	WORD PTR [BX+TRANS+2],SEG    EXTRS_END

		JMP	NORMAL_EXIT
AUX2_INIT	ENDP

;****************************************
;*	PROGRAM END			*
;****************************************
CODE		ENDS
		END	START_PROGRAM
