	PAGE	58,132
	TITLE	'RAMDISK'
;-----------------------------------------------------------------------------
;
;	MS-DOS Ram Disk driver for the NEC Personal Computer (A1)
;
;	module name:	RAMDISK
;	MS-DOS version: 2.11
;	module version: 1.0
;
;
;	implementation notes
;
;	This version of the driver requires a system with contiguous memory.
;	There is no provision for using a different memory region at this time.
;
;
;	When MS-DOS installs the driver, the initialization 
;	code in the driver first determines whether a formatted ram disk is 
;	present by looking for a string in the first logical sector. If the
;	message is present, the driver will assume a valid RAMDISK and skip
;	the formating code. If the message is not present, the driver formats
;	the ramdisk by writing E5's to each byte on the volume, then writing
;	the blank FATs and directory areas. The net effect is that the RAMDISK
;	will be formatted only at the first boot after poweron; subsequent
;	reboots will not destroy a RAMDISK volume's data. To force a RAMDISK
;	formatting, use debug (or a simple utility could be used) to overwrite
;	the initialization message at the first logical sector,
;	or power down the system and re-boot.
;
;-----------------------------------------------------------------------------
;	MAR/27/84

;
;  equates
;
nunits		equ	1	; well it's better than none
;
clk_rom		equ	1ch
;
cr		equ	0dh
lf		equ	0ah
;
;	IO data packet structures:
;
iodat	struc
cmdln	db	?		; length of this command
unit	db	?		; sub unit specifier
cmd	db	?		; command code
status	dw	?		; return status
	db	8 dup (?) 	; reserved for q links (future versions)
media	db	?		; media descriptor byte
trans	dd	?		; transfer address
count	dw	?		; count of blocks or characters
start	dw	?		; first block to transfer
iodat	ends

inits	struc			; init function io request packet
	db	13 dup (?)	; 13 byte static header
nounits	db	?		; number of units 	
	dw	?
	dw	?
bpbadr	dw	?		; bpb address return
bpbseg	dw	?		; bpb segment return
inits	ends


bpbb	struc			; get bpb function io request structure
	db	13 dup (?)	; 13 byte static header
bpb_med db	?		; media descriptor return
scrt	dw	?
	dw	?
bpb_adr	dw	?
bpb_seg	dw	?
bpbb	ends

medias	struc			; media check io request structure
	db	13 dup (?)	; 13 byte static header
med_des	db	?		; media descriptor
med_sts	db	?		; media change status
medias	ends

dpb	struc			; disk parameter block structure
bjmp	db	3 dup (?)	; for dpb in sector 1 - unused this implement.
sysid	db	8 dup (?)	; ditto	
secsiz	dw	?		; sector size in bytes
alloc	db	?		; au size in sectors	
ressec	dw	?		; number reserved sectors
fats	db	?		; number of FATs
maxdir	dw	?		; maximum # of drectory entries
sectors	dw	?		; total size in sectors
mediaid	db	?		; meadia descriptor
fatsec	dw	?		; number of FAT sectors
secper	dw	?		; number of sectors per FAT (optional)
dpb	ends

;****************************************
;*	external symbol and label	*
;****************************************

	EXTRN	mem_sw3:byte	; system memory size
;*
;**	ramdisk driver
;*
	extrn	entry:near
	extrn	normal_exit:near
	extrn	busy_exit:near
	extrn	cmderr_exit:near
	extrn	ptrsav:dword
		PAGE
;********************************************************
;*							*
;*	OTHOR SEGMENT MEMORY				*
;*							*
;********************************************************
;************************************************;
;*						*;
;*     INTERRUPT VECTOR AND SYSTEM COMMON AREA	*;
;*						*;
;************************************************;
INT_VEC		SEGMENT	AT 0000H
;*
;*	SYSTEM COMMON AREA AND ROM WORK AREA
;*
	ORG	400H
BIOS_FLAG	DW	?
INT_VEC		ENDS
		PAGE
CODE	SEGMENT	WORD PUBLIC 'CODES'
	ASSUME	CS:CODE,DS:CODE,ES:CODE
;************************************************
;*						*
;*	PUBLIC SYMBOL AND LABEL			*
;*						*
;************************************************

	public	ramdisk_top		; top point of RAMDISK driver
	public	ramdisk_tale		; top point of RAMDISK formatting
	public	init_check		; check formatted
	public	format			; RAMDISK formating
	public	ramdisk_init		; initalize RAMDISK driver

	public	ram_dsk_int		; entry point 
		page
;********************************************************
;*							*
;*	rsmdisk driver					*
;*							*
;*							*
;********************************************************
ramdisk_top	label	near

;************************************************
;*		constant data (read only)	*
;************************************************
;
;	desoatch table
;
ramdisktable:
	dw	initial		; 0 initialize driver
	dw 	mediac		; 1 media check
	dw	get_bpb		; 2 build BPB
	dw	cmderr_exit	; 3 IOCTL input
	dw	read		; 4 input (read)
	dw	busy_exit	; 5 non-destruct input (read)
	dw	normal_exit	; 6 input status
	dw	normal_exit	; 7 input flush
	dw	write		; 8 output (write)
	dw	write_ver	; 9 output (write) with verify
	dw	normal_exit	;10 return output status
	dw	normal_exit	;11 output flush
	dw	normal_exit 	;12 IOCTL output 

;********************************
;*	work area		*
;********************************
ramdpb	dpb <,,128,4,1,2,68,77*26,0ffh,6>

ramdsk_ptr	dw	ramdpb.secsiz
ramdisk_base	dw	?	; base of ram disk paragraph

ramdisk_size	dw	?	; length of ramdisk area. (* 64kb)

disk_change	db	1
	page
;
;  "interrupt" routine entry
;
ram_dsk_int:
	push	si
	mov	si,offset ramdisktable
	jmp	entry

	
;
;
;  mediac
;
;  perform media check operation
;
mediac:
	mov	ah,[disk_change]; ramdisk cannot be removed!
	mov	al,[ramdpb.mediaid]
	lds	bx,[ptrsav]
	mov	[bx.med_des],al
	mov	[bx.med_sts],ah
	;
	jmp	normal_exit	; no error
;
;
;  get_bpb
;
;  return pointer to bios parameter block
;
get_bpb:
	mov	al,[ramdpb.mediaid]
	mov	cx,offset ramdpb.secsiz
	lds	bx,[ptrsav]
	;
	mov	[bx.bpb_med],al
	mov	[bx.bpb_adr],cx
	mov	[bx.bpb_seg],cs
	jmp	normal_exit
;
;  read
;
;  read multiple sectors
; 
;  al is unit code
;  ah is media
;  cx is byte/sector count
;  dx is starting sector
;  es:di is transfer address
;
read:
	push	cx
	jcxz	red_noxfer
	mov	ax,dx
	add	dx,cx
	cmp	dx,[ramdpb.sectors]
	jnc	red_noxfer
	mul	[ramdpb.secsiz]
	ror	dx,1
	ror	dx,1
	ror	dx,1
	ror	dx,1
	;
	add	dx,[ramdisk_base]
	mov	ds,dx
	mov	si,ax		; ds:si=sector address of ramdisk

	call	transfer

red_noxfer:
	lds	bx,cs:[ptrsav]
	pop	cx
	mov	[bx.count],cx	; fill in total number xfered
	jmp	normal_exit

;
;  write
;
;  write multiple sectors
; 
;  al is unit code
;  ah is media
;  cx is byte/sector count
;  dx is starting sector
;  es:di is transfer address
;
write:
write_ver:
	push	cx
	jcxz	wrt_noxfer
	mov	ax,dx
	add	dx,cx
	cmp	dx,[ramdpb.sectors]
	jnc	wrt_noxfer
	mul	[ramdpb.secsiz]
	ror	dx,1
	ror	dx,1
	ror	dx,1
	ror	dx,1
	;
	add	dx,[ramdisk_base]
	push	es
	pop	ds
	mov	si,di
	mov	es,dx
	mov	di,ax		; es:di=sector address of ramdisk

	call	transfer

wrt_noxfer:
	lds	bx,cs:[ptrsav]
	pop	cx
	mov	[bx.count],cx	; fill in total number xfered
	jmp	normal_exit

;
;  transfer routine
;
;  input
;    ds:si 	source
;    es:di      destination
;    cx		sector count
;
;  routine ignores wrap around bytes
;
transfer:
	mov	ax,cs:[ramdpb.secsiz]
	mul	cx
more_trans:
	mov	cx,si		; get remain offset value
	cmp	si,di
	jnc	no_chg1
	mov	cx,di		; change SI and DI
no_chg1:
	jcxz	trans_64kb
	neg	cx
	test	dx,dx		; length > 64kb ?
	jnz	no_chg2
	cmp	ax,cx		; less
	jnc	no_chg2
no_chg15:
	mov	cx,ax
no_chg2:
	sub	ax,cx
	sbb	dx,0
;
	shr	cx,1		; byte length ---> word length
	jcxz	trans_byte	; only 1 byte ?
	jmp	short	trans_go
;
trans_64kb:
	test	dx,dx
	jz	no_chg15
	dec	dx
	mov	cx,8000h	; 32kw
trans_go:
	rep	movsw
	jnc	trans_fine
trans_byte:
	movsb
trans_fine:
	test	si,si		; ds:si segment over ?
	jnz	no_add1
	mov	cx,ds
	add	cx,1000h
	mov	ds,cx
no_add1:
	test	di,di		; es:di segment over ?
	jnz	no_add2
	mov	cx,es
	add	cx,1000h
	mov	es,cx
no_add2:
	test	ax,ax
	jnz	more_trans
	test	dx,dx
	jnz	more_trans
;
	ret
		page

;
;  init
;
;  initialize ram disk device
;
initial:

	mov	cl,nunits		; no units to reserve this dev
	lds	bx,cs:[ptrsav]
	mov	[bx.nounits],cl
	mov	[bx.bpbadr],offset ramdsk_ptr
	mov	[bx.bpbseg],cs
	jmp	normal_exit
ramdisk_tale	label	near
		page
;****************************************
;*	constant data for formating	*
;*	(deleted after formated)	*
;****************************************
;
;  the following string present in the first logical sector of the RAM disk
;  indicates that the disk is probably already formatted. 
; 
init_str	db 'Formatted RAM Disk (probably) present' 
check_len	equ	$ - init_str

;
;  volume name directory entry
;
;  time and date of creation are automated.
;					
ramvol		db 'RAMDISK    '
		db 08h
		db	10 dup (0)
vol_time	dw	?
vol_date	dw	?
		db	6 dup (0)
bpb128		dpb	<,,128,4,1,2,68,1024,0f0h,3>
bpb256		dpb	<,,128,4,1,2,68,2002,0f0h,6>
bpb384		dpb	<,,128,4,1,2,68,3072,0f0h,9>
bpb512		dpb	<,,128,4,1,2,68,4094,0f0h,12>

time_work	label	near
year	db	84h
month	db	70h
day	db	07h
hour	db	0
minute	db	0
second	db	0

		page
;****************************************
;*	RAMDISK work area intialize	*
;****************************************
ramdisk_init:
	mov	ax,int_vec
	mov	ds,ax
	assume	ds:int_vec
	mov	al,byte ptr [bios_flag+1]
	push	cs
	pop	ds
	assume	ds:code
	and	al,07h
	mov	dl,[mem_sw3]
	and	dl,07h
	sub	al,dl
	shl	al,1
	mov	ah,0
	mov	[ramdisk_size],ax
	inc	dl
	mov	cl,13
	shl	dx,cl
	mov	[ramdisk_base],dx
	shr	al,1
	dec	al
	mov	cx,size dpb
	mul	cl
	mov	si,offset bpb128
	add	si,ax
	mov	di,offset ramdpb
	rep	movsb
	ret

;
;  determine whether valid RAM disk already in place
;
;  return with zero flag set if so
;
init_check:
	cld
	push	cs
	pop	ds
	mov	si,offset init_str
	mov 	es,[ramdisk_base]
	mov 	di,0
	mov	cx,check_len 
	repz	cmpsb
	jnz	init_chk_end
	mov	si,offset ramdpb.secsiz
	mov	cx,13
	repe	cmpsb
init_chk_end:
	ret	

;
;  format the ram disk
;
format:
;
;  first put e5s everywhere
;
	cld	
	mov	es,[ramdisk_base]
	mov	di,0
	mov	ax,0e5e5h
	mov	dx,[ramdisk_size]
memory_clr:
	mov	cx,8000h
	rep	stosw
	mov	cx,es
	add	cx,1000h
	mov	es,cx
	dec	dx
	jnz	memory_clr
;
;  init formatted disk id message in reserved sector
;
	mov	es,[ramdisk_base]
	mov	si,offset init_str
	mov	cx,check_len
	mov	di,0
	rep	movsb
;
	mov	si,offset ramdpb.secsiz
	mov	cx,13
	rep	movsb
;
;  now do fats
;
	mov	ax,[ramdpb.secsiz]
	mul	[ramdpb.ressec]
	mov	di,ax
	mov	ax,[ramdpb.secsiz]
	mul	[ramdpb.fatsec]
	mov	bl,[ramdpb.fats]
	sub	ax,3
	mov	dx,ax
set_fats:
	mov	cx,dx
	mov	al,0feh
	stosb
	inc	al
	stosb
	stosb
	inc	al
	rep	stosb
	dec	bl
	jnz	set_fats
;
;	do volume name
;
	call	settime			; set date/time of volume
	mov	si,offset ramvol
	mov	cx,32/2
	rep	movsw
;
;	now do directory
;
	mov	dx,[ramdpb.maxdir]
	dec	dx
set_dir:
	mov	ax,0
	mov	cx,32/2
	rep	stosw
	dec	dx
	jnz	set_dir

	ret

;
;  set date/time to directory of volume.
;
settime:
	push	es
	push	cs
	pop	es
	mov	bx,offset time_work
	mov	ah,0
	int	1ch			; get date and time

	mov	al,[year]		; year (convert and set)
	call	bin_chg
	sub	al,80
	jnc	skip_19xx
	add	al,100
skip_19xx:
	mov	cl,9
	shl	ax,cl
	mov	[vol_date],ax

	mov	al,[month]		; month (convert and set)
	mov	cl,5-4
	shl	ax,cl
	and	ax,0fh shl 5
	or	[vol_date],ax

	mov	al,[day]		; day (conver and set)

	call	bin_chg
	and	ax,001fh
	or	[vol_date],ax

	mov	al,[hour]		; hour (conver and set)
	call	bin_chg
	mov	cl,11
	shl	ax,cl
	mov	[vol_time],ax

	mov	al,[minute]		; minute (convert and set)
	call	bin_chg
	mov	cl,5
	shl	ax,cl
	and	ax,3fh shl 5
	or	[vol_time],ax

	mov	al,[second]		; second (convert and set)

	call	bin_chg
	shr	al,1
	and	ax,001fh
	or	[vol_time],ax

	pop	es
	ret
;
;  packed decimal convert to binary
;	in: al=packed decimal
;	ex: al=binary
;
bin_chg:
	mov	ah,al
	mov	cl,4
	shr	ah,cl
	and	al,0fh
	aad
	ret
;
CODE	ENDS

;************************************************
;*	PROGRAM END				*
;************************************************
	END

	

*

D

